// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> Name of the Sku. </summary>
    public readonly partial struct ApiManagementServiceSkuType : IEquatable<ApiManagementServiceSkuType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ApiManagementServiceSkuType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ApiManagementServiceSkuType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DeveloperValue = "Developer";
        private const string StandardValue = "Standard";
        private const string PremiumValue = "Premium";
        private const string BasicValue = "Basic";
        private const string ConsumptionValue = "Consumption";
        private const string IsolatedValue = "Isolated";

        /// <summary> Developer SKU of Api Management. </summary>
        public static ApiManagementServiceSkuType Developer { get; } = new ApiManagementServiceSkuType(DeveloperValue);
        /// <summary> Standard SKU of Api Management. </summary>
        public static ApiManagementServiceSkuType Standard { get; } = new ApiManagementServiceSkuType(StandardValue);
        /// <summary> Premium SKU of Api Management. </summary>
        public static ApiManagementServiceSkuType Premium { get; } = new ApiManagementServiceSkuType(PremiumValue);
        /// <summary> Basic SKU of Api Management. </summary>
        public static ApiManagementServiceSkuType Basic { get; } = new ApiManagementServiceSkuType(BasicValue);
        /// <summary> Consumption SKU of Api Management. </summary>
        public static ApiManagementServiceSkuType Consumption { get; } = new ApiManagementServiceSkuType(ConsumptionValue);
        /// <summary> Isolated SKU of Api Management. </summary>
        public static ApiManagementServiceSkuType Isolated { get; } = new ApiManagementServiceSkuType(IsolatedValue);
        /// <summary> Determines if two <see cref="ApiManagementServiceSkuType"/> values are the same. </summary>
        public static bool operator ==(ApiManagementServiceSkuType left, ApiManagementServiceSkuType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ApiManagementServiceSkuType"/> values are not the same. </summary>
        public static bool operator !=(ApiManagementServiceSkuType left, ApiManagementServiceSkuType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ApiManagementServiceSkuType"/>. </summary>
        public static implicit operator ApiManagementServiceSkuType(string value) => new ApiManagementServiceSkuType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ApiManagementServiceSkuType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ApiManagementServiceSkuType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
