// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Text;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.ApiManagement.Models
{
    public partial class ApiManagementServicePatch : IUtf8JsonSerializable, IJsonModel<ApiManagementServicePatch>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ApiManagementServicePatch>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ApiManagementServicePatch>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ApiManagementServicePatch>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ApiManagementServicePatch)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsDefined(Sku))
            {
                writer.WritePropertyName("sku"u8);
                writer.WriteObjectValue(Sku, options);
            }
            if (Optional.IsDefined(Identity))
            {
                writer.WritePropertyName("identity"u8);
                JsonSerializer.Serialize(writer, Identity);
            }
            if (options.Format != "W" && Optional.IsDefined(ETag))
            {
                writer.WritePropertyName("etag"u8);
                writer.WriteStringValue(ETag.Value.ToString());
            }
            if (Optional.IsCollectionDefined(Zones))
            {
                writer.WritePropertyName("zones"u8);
                writer.WriteStartArray();
                foreach (var item in Zones)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Tags))
            {
                writer.WritePropertyName("tags"u8);
                writer.WriteStartObject();
                foreach (var item in Tags)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteStringValue(item.Value);
                }
                writer.WriteEndObject();
            }
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(NotificationSenderEmail))
            {
                writer.WritePropertyName("notificationSenderEmail"u8);
                writer.WriteStringValue(NotificationSenderEmail);
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState);
            }
            if (options.Format != "W" && Optional.IsDefined(TargetProvisioningState))
            {
                writer.WritePropertyName("targetProvisioningState"u8);
                writer.WriteStringValue(TargetProvisioningState);
            }
            if (options.Format != "W" && Optional.IsDefined(CreatedAtUtc))
            {
                writer.WritePropertyName("createdAtUtc"u8);
                writer.WriteStringValue(CreatedAtUtc.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(GatewayUri))
            {
                writer.WritePropertyName("gatewayUrl"u8);
                writer.WriteStringValue(GatewayUri.AbsoluteUri);
            }
            if (options.Format != "W" && Optional.IsDefined(GatewayRegionalUri))
            {
                writer.WritePropertyName("gatewayRegionalUrl"u8);
                writer.WriteStringValue(GatewayRegionalUri.AbsoluteUri);
            }
            if (options.Format != "W" && Optional.IsDefined(PortalUri))
            {
                writer.WritePropertyName("portalUrl"u8);
                writer.WriteStringValue(PortalUri.AbsoluteUri);
            }
            if (options.Format != "W" && Optional.IsDefined(ManagementApiUri))
            {
                writer.WritePropertyName("managementApiUrl"u8);
                writer.WriteStringValue(ManagementApiUri.AbsoluteUri);
            }
            if (options.Format != "W" && Optional.IsDefined(ScmUri))
            {
                writer.WritePropertyName("scmUrl"u8);
                writer.WriteStringValue(ScmUri.AbsoluteUri);
            }
            if (options.Format != "W" && Optional.IsDefined(DeveloperPortalUri))
            {
                writer.WritePropertyName("developerPortalUrl"u8);
                writer.WriteStringValue(DeveloperPortalUri.AbsoluteUri);
            }
            if (Optional.IsCollectionDefined(HostnameConfigurations))
            {
                writer.WritePropertyName("hostnameConfigurations"u8);
                writer.WriteStartArray();
                foreach (var item in HostnameConfigurations)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(PublicIPAddresses))
            {
                writer.WritePropertyName("publicIPAddresses"u8);
                writer.WriteStartArray();
                foreach (var item in PublicIPAddresses)
                {
                    if (item == null)
                    {
                        writer.WriteNullValue();
                        continue;
                    }
                    writer.WriteStringValue(item.ToString());
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(PrivateIPAddresses))
            {
                writer.WritePropertyName("privateIPAddresses"u8);
                writer.WriteStartArray();
                foreach (var item in PrivateIPAddresses)
                {
                    if (item == null)
                    {
                        writer.WriteNullValue();
                        continue;
                    }
                    writer.WriteStringValue(item.ToString());
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(PublicIPAddressId))
            {
                writer.WritePropertyName("publicIpAddressId"u8);
                writer.WriteStringValue(PublicIPAddressId);
            }
            if (Optional.IsDefined(PublicNetworkAccess))
            {
                writer.WritePropertyName("publicNetworkAccess"u8);
                writer.WriteStringValue(PublicNetworkAccess.Value.ToString());
            }
            if (Optional.IsDefined(ConfigurationApi))
            {
                writer.WritePropertyName("configurationApi"u8);
                writer.WriteObjectValue(ConfigurationApi, options);
            }
            if (Optional.IsDefined(VirtualNetworkConfiguration))
            {
                writer.WritePropertyName("virtualNetworkConfiguration"u8);
                writer.WriteObjectValue(VirtualNetworkConfiguration, options);
            }
            if (Optional.IsCollectionDefined(AdditionalLocations))
            {
                writer.WritePropertyName("additionalLocations"u8);
                writer.WriteStartArray();
                foreach (var item in AdditionalLocations)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(CustomProperties))
            {
                writer.WritePropertyName("customProperties"u8);
                writer.WriteStartObject();
                foreach (var item in CustomProperties)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteStringValue(item.Value);
                }
                writer.WriteEndObject();
            }
            if (Optional.IsCollectionDefined(Certificates))
            {
                writer.WritePropertyName("certificates"u8);
                writer.WriteStartArray();
                foreach (var item in Certificates)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(EnableClientCertificate))
            {
                writer.WritePropertyName("enableClientCertificate"u8);
                writer.WriteBooleanValue(EnableClientCertificate.Value);
            }
            if (Optional.IsDefined(NatGatewayState))
            {
                writer.WritePropertyName("natGatewayState"u8);
                writer.WriteStringValue(NatGatewayState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(OutboundPublicIPAddresses))
            {
                writer.WritePropertyName("outboundPublicIPAddresses"u8);
                writer.WriteStartArray();
                foreach (var item in OutboundPublicIPAddresses)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(DisableGateway))
            {
                writer.WritePropertyName("disableGateway"u8);
                writer.WriteBooleanValue(DisableGateway.Value);
            }
            if (Optional.IsDefined(VirtualNetworkType))
            {
                writer.WritePropertyName("virtualNetworkType"u8);
                writer.WriteStringValue(VirtualNetworkType.Value.ToString());
            }
            if (Optional.IsDefined(ApiVersionConstraint))
            {
                writer.WritePropertyName("apiVersionConstraint"u8);
                writer.WriteObjectValue(ApiVersionConstraint, options);
            }
            if (Optional.IsDefined(Restore))
            {
                writer.WritePropertyName("restore"u8);
                writer.WriteBooleanValue(Restore.Value);
            }
            if (Optional.IsCollectionDefined(PrivateEndpointConnections))
            {
                writer.WritePropertyName("privateEndpointConnections"u8);
                writer.WriteStartArray();
                foreach (var item in PrivateEndpointConnections)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(PlatformVersion))
            {
                writer.WritePropertyName("platformVersion"u8);
                writer.WriteStringValue(PlatformVersion.Value.ToString());
            }
            if (Optional.IsDefined(LegacyPortalStatus))
            {
                writer.WritePropertyName("legacyPortalStatus"u8);
                writer.WriteStringValue(LegacyPortalStatus.Value.ToString());
            }
            if (Optional.IsDefined(DeveloperPortalStatus))
            {
                writer.WritePropertyName("developerPortalStatus"u8);
                writer.WriteStringValue(DeveloperPortalStatus.Value.ToString());
            }
            if (Optional.IsDefined(PublisherEmail))
            {
                writer.WritePropertyName("publisherEmail"u8);
                writer.WriteStringValue(PublisherEmail);
            }
            if (Optional.IsDefined(PublisherName))
            {
                writer.WritePropertyName("publisherName"u8);
                writer.WriteStringValue(PublisherName);
            }
            writer.WriteEndObject();
        }

        ApiManagementServicePatch IJsonModel<ApiManagementServicePatch>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ApiManagementServicePatch>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ApiManagementServicePatch)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeApiManagementServicePatch(document.RootElement, options);
        }

        internal static ApiManagementServicePatch DeserializeApiManagementServicePatch(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ApiManagementServiceSkuProperties sku = default;
            ManagedServiceIdentity identity = default;
            ETag? etag = default;
            IList<string> zones = default;
            IDictionary<string, string> tags = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string notificationSenderEmail = default;
            string provisioningState = default;
            string targetProvisioningState = default;
            DateTimeOffset? createdAtUtc = default;
            Uri gatewayUri = default;
            Uri gatewayRegionalUri = default;
            Uri portalUri = default;
            Uri managementApiUri = default;
            Uri scmUri = default;
            Uri developerPortalUri = default;
            IList<HostnameConfiguration> hostnameConfigurations = default;
            IReadOnlyList<IPAddress> publicIPAddresses = default;
            IReadOnlyList<IPAddress> privateIPAddresses = default;
            ResourceIdentifier publicIPAddressId = default;
            PublicNetworkAccess? publicNetworkAccess = default;
            ConfigurationApi configurationApi = default;
            VirtualNetworkConfiguration virtualNetworkConfiguration = default;
            IList<AdditionalLocation> additionalLocations = default;
            IDictionary<string, string> customProperties = default;
            IList<CertificateConfiguration> certificates = default;
            bool? enableClientCertificate = default;
            ApiManagementNatGatewayState? natGatewayState = default;
            IReadOnlyList<string> outboundPublicIPAddresses = default;
            bool? disableGateway = default;
            VirtualNetworkType? virtualNetworkType = default;
            ApiVersionConstraint apiVersionConstraint = default;
            bool? restore = default;
            IList<RemotePrivateEndpointConnectionWrapper> privateEndpointConnections = default;
            PlatformVersion? platformVersion = default;
            LegacyPortalStatus? legacyPortalStatus = default;
            DeveloperPortalStatus? developerPortalStatus = default;
            string publisherEmail = default;
            string publisherName = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("sku"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    sku = ApiManagementServiceSkuProperties.DeserializeApiManagementServiceSkuProperties(property.Value, options);
                    continue;
                }
                if (property.NameEquals("identity"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    identity = JsonSerializer.Deserialize<ManagedServiceIdentity>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("etag"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    etag = new ETag(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("zones"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    zones = array;
                    continue;
                }
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("notificationSenderEmail"u8))
                        {
                            notificationSenderEmail = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            provisioningState = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("targetProvisioningState"u8))
                        {
                            targetProvisioningState = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("createdAtUtc"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            createdAtUtc = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("gatewayUrl"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            gatewayUri = new Uri(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("gatewayRegionalUrl"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            gatewayRegionalUri = new Uri(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("portalUrl"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            portalUri = new Uri(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("managementApiUrl"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            managementApiUri = new Uri(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("scmUrl"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            scmUri = new Uri(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("developerPortalUrl"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            developerPortalUri = new Uri(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("hostnameConfigurations"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<HostnameConfiguration> array = new List<HostnameConfiguration>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(HostnameConfiguration.DeserializeHostnameConfiguration(item, options));
                            }
                            hostnameConfigurations = array;
                            continue;
                        }
                        if (property0.NameEquals("publicIPAddresses"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<IPAddress> array = new List<IPAddress>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                if (item.ValueKind == JsonValueKind.Null)
                                {
                                    array.Add(null);
                                }
                                else
                                {
                                    array.Add(IPAddress.Parse(item.GetString()));
                                }
                            }
                            publicIPAddresses = array;
                            continue;
                        }
                        if (property0.NameEquals("privateIPAddresses"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<IPAddress> array = new List<IPAddress>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                if (item.ValueKind == JsonValueKind.Null)
                                {
                                    array.Add(null);
                                }
                                else
                                {
                                    array.Add(IPAddress.Parse(item.GetString()));
                                }
                            }
                            privateIPAddresses = array;
                            continue;
                        }
                        if (property0.NameEquals("publicIpAddressId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            publicIPAddressId = new ResourceIdentifier(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("publicNetworkAccess"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            publicNetworkAccess = new PublicNetworkAccess(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("configurationApi"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            configurationApi = ConfigurationApi.DeserializeConfigurationApi(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("virtualNetworkConfiguration"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            virtualNetworkConfiguration = VirtualNetworkConfiguration.DeserializeVirtualNetworkConfiguration(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("additionalLocations"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<AdditionalLocation> array = new List<AdditionalLocation>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(AdditionalLocation.DeserializeAdditionalLocation(item, options));
                            }
                            additionalLocations = array;
                            continue;
                        }
                        if (property0.NameEquals("customProperties"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            Dictionary<string, string> dictionary = new Dictionary<string, string>();
                            foreach (var property1 in property0.Value.EnumerateObject())
                            {
                                dictionary.Add(property1.Name, property1.Value.GetString());
                            }
                            customProperties = dictionary;
                            continue;
                        }
                        if (property0.NameEquals("certificates"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<CertificateConfiguration> array = new List<CertificateConfiguration>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(CertificateConfiguration.DeserializeCertificateConfiguration(item, options));
                            }
                            certificates = array;
                            continue;
                        }
                        if (property0.NameEquals("enableClientCertificate"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            enableClientCertificate = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("natGatewayState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            natGatewayState = new ApiManagementNatGatewayState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("outboundPublicIPAddresses"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<string> array = new List<string>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString());
                            }
                            outboundPublicIPAddresses = array;
                            continue;
                        }
                        if (property0.NameEquals("disableGateway"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            disableGateway = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("virtualNetworkType"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            virtualNetworkType = new VirtualNetworkType(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("apiVersionConstraint"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            apiVersionConstraint = ApiVersionConstraint.DeserializeApiVersionConstraint(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("restore"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            restore = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("privateEndpointConnections"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<RemotePrivateEndpointConnectionWrapper> array = new List<RemotePrivateEndpointConnectionWrapper>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(RemotePrivateEndpointConnectionWrapper.DeserializeRemotePrivateEndpointConnectionWrapper(item, options));
                            }
                            privateEndpointConnections = array;
                            continue;
                        }
                        if (property0.NameEquals("platformVersion"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            platformVersion = new PlatformVersion(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("legacyPortalStatus"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            legacyPortalStatus = new LegacyPortalStatus(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("developerPortalStatus"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            developerPortalStatus = new DeveloperPortalStatus(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("publisherEmail"u8))
                        {
                            publisherEmail = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("publisherName"u8))
                        {
                            publisherName = property0.Value.GetString();
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ApiManagementServicePatch(
                id,
                name,
                type,
                systemData,
                sku,
                identity,
                etag,
                zones ?? new ChangeTrackingList<string>(),
                notificationSenderEmail,
                provisioningState,
                targetProvisioningState,
                createdAtUtc,
                gatewayUri,
                gatewayRegionalUri,
                portalUri,
                managementApiUri,
                scmUri,
                developerPortalUri,
                hostnameConfigurations ?? new ChangeTrackingList<HostnameConfiguration>(),
                publicIPAddresses ?? new ChangeTrackingList<IPAddress>(),
                privateIPAddresses ?? new ChangeTrackingList<IPAddress>(),
                publicIPAddressId,
                publicNetworkAccess,
                configurationApi,
                virtualNetworkConfiguration,
                additionalLocations ?? new ChangeTrackingList<AdditionalLocation>(),
                customProperties ?? new ChangeTrackingDictionary<string, string>(),
                certificates ?? new ChangeTrackingList<CertificateConfiguration>(),
                enableClientCertificate,
                natGatewayState,
                outboundPublicIPAddresses ?? new ChangeTrackingList<string>(),
                disableGateway,
                virtualNetworkType,
                apiVersionConstraint,
                restore,
                privateEndpointConnections ?? new ChangeTrackingList<RemotePrivateEndpointConnectionWrapper>(),
                platformVersion,
                legacyPortalStatus,
                developerPortalStatus,
                publisherEmail,
                publisherName,
                tags ?? new ChangeTrackingDictionary<string, string>(),
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Name), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  name: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Name))
                {
                    builder.Append("  name: ");
                    if (Name.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Name}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Name}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Tags), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  tags: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Tags))
                {
                    if (Tags.Any())
                    {
                        builder.Append("  tags: ");
                        builder.AppendLine("{");
                        foreach (var item in Tags)
                        {
                            builder.Append($"    '{item.Key}': ");
                            if (item.Value == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Value.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("'''");
                                builder.AppendLine($"{item.Value}'''");
                            }
                            else
                            {
                                builder.AppendLine($"'{item.Value}'");
                            }
                        }
                        builder.AppendLine("  }");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Sku), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  sku: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Sku))
                {
                    builder.Append("  sku: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Sku, options, 2, false, "  sku: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Identity), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  identity: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Identity))
                {
                    builder.Append("  identity: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Identity, options, 2, false, "  identity: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ETag), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  etag: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ETag))
                {
                    builder.Append("  etag: ");
                    builder.AppendLine($"'{ETag.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Zones), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  zones: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Zones))
                {
                    if (Zones.Any())
                    {
                        builder.Append("  zones: ");
                        builder.AppendLine("[");
                        foreach (var item in Zones)
                        {
                            if (item == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("    '''");
                                builder.AppendLine($"{item}'''");
                            }
                            else
                            {
                                builder.AppendLine($"    '{item}'");
                            }
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Id), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  id: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Id))
                {
                    builder.Append("  id: ");
                    builder.AppendLine($"'{Id.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SystemData), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  systemData: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SystemData))
                {
                    builder.Append("  systemData: ");
                    builder.AppendLine($"'{SystemData.ToString()}'");
                }
            }

            builder.Append("  properties:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NotificationSenderEmail), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    notificationSenderEmail: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NotificationSenderEmail))
                {
                    builder.Append("    notificationSenderEmail: ");
                    if (NotificationSenderEmail.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{NotificationSenderEmail}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{NotificationSenderEmail}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ProvisioningState), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    provisioningState: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ProvisioningState))
                {
                    builder.Append("    provisioningState: ");
                    if (ProvisioningState.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ProvisioningState}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ProvisioningState}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TargetProvisioningState), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    targetProvisioningState: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TargetProvisioningState))
                {
                    builder.Append("    targetProvisioningState: ");
                    if (TargetProvisioningState.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{TargetProvisioningState}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{TargetProvisioningState}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CreatedAtUtc), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    createdAtUtc: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CreatedAtUtc))
                {
                    builder.Append("    createdAtUtc: ");
                    var formattedDateTimeString = TypeFormatters.ToString(CreatedAtUtc.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(GatewayUri), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    gatewayUrl: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(GatewayUri))
                {
                    builder.Append("    gatewayUrl: ");
                    builder.AppendLine($"'{GatewayUri.AbsoluteUri}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(GatewayRegionalUri), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    gatewayRegionalUrl: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(GatewayRegionalUri))
                {
                    builder.Append("    gatewayRegionalUrl: ");
                    builder.AppendLine($"'{GatewayRegionalUri.AbsoluteUri}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PortalUri), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    portalUrl: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PortalUri))
                {
                    builder.Append("    portalUrl: ");
                    builder.AppendLine($"'{PortalUri.AbsoluteUri}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ManagementApiUri), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    managementApiUrl: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ManagementApiUri))
                {
                    builder.Append("    managementApiUrl: ");
                    builder.AppendLine($"'{ManagementApiUri.AbsoluteUri}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ScmUri), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    scmUrl: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ScmUri))
                {
                    builder.Append("    scmUrl: ");
                    builder.AppendLine($"'{ScmUri.AbsoluteUri}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DeveloperPortalUri), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    developerPortalUrl: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DeveloperPortalUri))
                {
                    builder.Append("    developerPortalUrl: ");
                    builder.AppendLine($"'{DeveloperPortalUri.AbsoluteUri}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(HostnameConfigurations), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    hostnameConfigurations: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(HostnameConfigurations))
                {
                    if (HostnameConfigurations.Any())
                    {
                        builder.Append("    hostnameConfigurations: ");
                        builder.AppendLine("[");
                        foreach (var item in HostnameConfigurations)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    hostnameConfigurations: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PublicIPAddresses), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    publicIPAddresses: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(PublicIPAddresses))
                {
                    if (PublicIPAddresses.Any())
                    {
                        builder.Append("    publicIPAddresses: ");
                        builder.AppendLine("[");
                        foreach (var item in PublicIPAddresses)
                        {
                            if (item == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            builder.AppendLine($"      '{item.ToString()}'");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PrivateIPAddresses), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    privateIPAddresses: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(PrivateIPAddresses))
                {
                    if (PrivateIPAddresses.Any())
                    {
                        builder.Append("    privateIPAddresses: ");
                        builder.AppendLine("[");
                        foreach (var item in PrivateIPAddresses)
                        {
                            if (item == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            builder.AppendLine($"      '{item.ToString()}'");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PublicIPAddressId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    publicIpAddressId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PublicIPAddressId))
                {
                    builder.Append("    publicIpAddressId: ");
                    builder.AppendLine($"'{PublicIPAddressId.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PublicNetworkAccess), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    publicNetworkAccess: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PublicNetworkAccess))
                {
                    builder.Append("    publicNetworkAccess: ");
                    builder.AppendLine($"'{PublicNetworkAccess.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("LegacyApi", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    configurationApi: ");
                builder.AppendLine("{");
                builder.AppendLine("      configurationApi: {");
                builder.Append("        legacyApi: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("      }");
                builder.AppendLine("    }");
            }
            else
            {
                if (Optional.IsDefined(ConfigurationApi))
                {
                    builder.Append("    configurationApi: ");
                    BicepSerializationHelpers.AppendChildObject(builder, ConfigurationApi, options, 4, false, "    configurationApi: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(VirtualNetworkConfiguration), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    virtualNetworkConfiguration: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(VirtualNetworkConfiguration))
                {
                    builder.Append("    virtualNetworkConfiguration: ");
                    BicepSerializationHelpers.AppendChildObject(builder, VirtualNetworkConfiguration, options, 4, false, "    virtualNetworkConfiguration: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AdditionalLocations), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    additionalLocations: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(AdditionalLocations))
                {
                    if (AdditionalLocations.Any())
                    {
                        builder.Append("    additionalLocations: ");
                        builder.AppendLine("[");
                        foreach (var item in AdditionalLocations)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    additionalLocations: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CustomProperties), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    customProperties: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(CustomProperties))
                {
                    if (CustomProperties.Any())
                    {
                        builder.Append("    customProperties: ");
                        builder.AppendLine("{");
                        foreach (var item in CustomProperties)
                        {
                            builder.Append($"        '{item.Key}': ");
                            if (item.Value == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Value.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("'''");
                                builder.AppendLine($"{item.Value}'''");
                            }
                            else
                            {
                                builder.AppendLine($"'{item.Value}'");
                            }
                        }
                        builder.AppendLine("    }");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Certificates), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    certificates: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Certificates))
                {
                    if (Certificates.Any())
                    {
                        builder.Append("    certificates: ");
                        builder.AppendLine("[");
                        foreach (var item in Certificates)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    certificates: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EnableClientCertificate), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    enableClientCertificate: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EnableClientCertificate))
                {
                    builder.Append("    enableClientCertificate: ");
                    var boolValue = EnableClientCertificate.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NatGatewayState), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    natGatewayState: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NatGatewayState))
                {
                    builder.Append("    natGatewayState: ");
                    builder.AppendLine($"'{NatGatewayState.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(OutboundPublicIPAddresses), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    outboundPublicIPAddresses: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(OutboundPublicIPAddresses))
                {
                    if (OutboundPublicIPAddresses.Any())
                    {
                        builder.Append("    outboundPublicIPAddresses: ");
                        builder.AppendLine("[");
                        foreach (var item in OutboundPublicIPAddresses)
                        {
                            if (item == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("      '''");
                                builder.AppendLine($"{item}'''");
                            }
                            else
                            {
                                builder.AppendLine($"      '{item}'");
                            }
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DisableGateway), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    disableGateway: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DisableGateway))
                {
                    builder.Append("    disableGateway: ");
                    var boolValue = DisableGateway.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(VirtualNetworkType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    virtualNetworkType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(VirtualNetworkType))
                {
                    builder.Append("    virtualNetworkType: ");
                    builder.AppendLine($"'{VirtualNetworkType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue("MinApiVersion", out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    apiVersionConstraint: ");
                builder.AppendLine("{");
                builder.AppendLine("      apiVersionConstraint: {");
                builder.Append("        minApiVersion: ");
                builder.AppendLine(propertyOverride);
                builder.AppendLine("      }");
                builder.AppendLine("    }");
            }
            else
            {
                if (Optional.IsDefined(ApiVersionConstraint))
                {
                    builder.Append("    apiVersionConstraint: ");
                    BicepSerializationHelpers.AppendChildObject(builder, ApiVersionConstraint, options, 4, false, "    apiVersionConstraint: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Restore), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    restore: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Restore))
                {
                    builder.Append("    restore: ");
                    var boolValue = Restore.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PrivateEndpointConnections), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    privateEndpointConnections: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(PrivateEndpointConnections))
                {
                    if (PrivateEndpointConnections.Any())
                    {
                        builder.Append("    privateEndpointConnections: ");
                        builder.AppendLine("[");
                        foreach (var item in PrivateEndpointConnections)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    privateEndpointConnections: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PlatformVersion), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    platformVersion: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PlatformVersion))
                {
                    builder.Append("    platformVersion: ");
                    builder.AppendLine($"'{PlatformVersion.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LegacyPortalStatus), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    legacyPortalStatus: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LegacyPortalStatus))
                {
                    builder.Append("    legacyPortalStatus: ");
                    builder.AppendLine($"'{LegacyPortalStatus.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DeveloperPortalStatus), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    developerPortalStatus: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DeveloperPortalStatus))
                {
                    builder.Append("    developerPortalStatus: ");
                    builder.AppendLine($"'{DeveloperPortalStatus.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PublisherEmail), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    publisherEmail: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PublisherEmail))
                {
                    builder.Append("    publisherEmail: ");
                    if (PublisherEmail.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{PublisherEmail}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{PublisherEmail}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PublisherName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    publisherName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PublisherName))
                {
                    builder.Append("    publisherName: ");
                    if (PublisherName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{PublisherName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{PublisherName}'");
                    }
                }
            }

            builder.AppendLine("  }");
            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<ApiManagementServicePatch>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ApiManagementServicePatch>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(ApiManagementServicePatch)} does not support writing '{options.Format}' format.");
            }
        }

        ApiManagementServicePatch IPersistableModel<ApiManagementServicePatch>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ApiManagementServicePatch>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeApiManagementServicePatch(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ApiManagementServicePatch)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ApiManagementServicePatch>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
