// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.ApiManagement.Models
{
    internal static partial class ApiManagementProductStateExtensions
    {
        public static string ToSerialString(this ApiManagementProductState value) => value switch
        {
            ApiManagementProductState.NotPublished => "notPublished",
            ApiManagementProductState.Published => "published",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ApiManagementProductState value.")
        };

        public static ApiManagementProductState ToApiManagementProductState(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "notPublished")) return ApiManagementProductState.NotPublished;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "published")) return ApiManagementProductState.Published;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ApiManagementProductState value.");
        }
    }
}
