// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> Property can be used to enable NAT Gateway for this API Management service. </summary>
    public readonly partial struct ApiManagementNatGatewayState : IEquatable<ApiManagementNatGatewayState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ApiManagementNatGatewayState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ApiManagementNatGatewayState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Nat Gateway is enabled for the service. </summary>
        public static ApiManagementNatGatewayState Enabled { get; } = new ApiManagementNatGatewayState(EnabledValue);
        /// <summary> Nat Gateway is disabled for the service. </summary>
        public static ApiManagementNatGatewayState Disabled { get; } = new ApiManagementNatGatewayState(DisabledValue);
        /// <summary> Determines if two <see cref="ApiManagementNatGatewayState"/> values are the same. </summary>
        public static bool operator ==(ApiManagementNatGatewayState left, ApiManagementNatGatewayState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ApiManagementNatGatewayState"/> values are not the same. </summary>
        public static bool operator !=(ApiManagementNatGatewayState left, ApiManagementNatGatewayState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ApiManagementNatGatewayState"/>. </summary>
        public static implicit operator ApiManagementNatGatewayState(string value) => new ApiManagementNatGatewayState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ApiManagementNatGatewayState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ApiManagementNatGatewayState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
