// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> Certificate create or update details. </summary>
    public partial class ApiManagementCertificateCreateOrUpdateContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ApiManagementCertificateCreateOrUpdateContent"/>. </summary>
        public ApiManagementCertificateCreateOrUpdateContent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ApiManagementCertificateCreateOrUpdateContent"/>. </summary>
        /// <param name="data"> Base 64 encoded certificate using the application/x-pkcs12 representation. </param>
        /// <param name="password"> Password for the Certificate. </param>
        /// <param name="keyVaultDetails"> KeyVault location details of the certificate. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ApiManagementCertificateCreateOrUpdateContent(string data, string password, KeyVaultContractCreateProperties keyVaultDetails, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Data = data;
            Password = password;
            KeyVaultDetails = keyVaultDetails;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Base 64 encoded certificate using the application/x-pkcs12 representation. </summary>
        [WirePath("properties.data")]
        public string Data { get; set; }
        /// <summary> Password for the Certificate. </summary>
        [WirePath("properties.password")]
        public string Password { get; set; }
        /// <summary> KeyVault location details of the certificate. </summary>
        [WirePath("properties.keyVault")]
        public KeyVaultContractCreateProperties KeyVaultDetails { get; set; }
    }
}
