// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> Backend update parameters. </summary>
    public partial class ApiManagementBackendPatch
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ApiManagementBackendPatch"/>. </summary>
        public ApiManagementBackendPatch()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ApiManagementBackendPatch"/>. </summary>
        /// <param name="title"> Backend Title. </param>
        /// <param name="description"> Backend Description. </param>
        /// <param name="resourceUri"> Management Uri of the Resource in External System. This URL can be the Arm Resource Id of Logic Apps, Function Apps or API Apps. </param>
        /// <param name="properties"> Backend Properties contract. </param>
        /// <param name="credentials"> Backend Credentials Contract Properties. </param>
        /// <param name="proxy"> Backend gateway Contract Properties. </param>
        /// <param name="tls"> Backend TLS Properties. </param>
        /// <param name="circuitBreaker"> Backend Circuit Breaker Configuration. </param>
        /// <param name="uri"> Runtime Url of the Backend. </param>
        /// <param name="protocol"> Backend communication protocol. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ApiManagementBackendPatch(string title, string description, Uri resourceUri, BackendProperties properties, BackendCredentialsContract credentials, BackendProxyContract proxy, BackendTlsProperties tls, BackendCircuitBreaker circuitBreaker, Uri uri, BackendProtocol? protocol, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Title = title;
            Description = description;
            ResourceUri = resourceUri;
            Properties = properties;
            Credentials = credentials;
            Proxy = proxy;
            Tls = tls;
            CircuitBreaker = circuitBreaker;
            Uri = uri;
            Protocol = protocol;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Backend Title. </summary>
        [WirePath("properties.title")]
        public string Title { get; set; }
        /// <summary> Backend Description. </summary>
        [WirePath("properties.description")]
        public string Description { get; set; }
        /// <summary> Management Uri of the Resource in External System. This URL can be the Arm Resource Id of Logic Apps, Function Apps or API Apps. </summary>
        [WirePath("properties.resourceId")]
        public Uri ResourceUri { get; set; }
        /// <summary> Backend Properties contract. </summary>
        internal BackendProperties Properties { get; set; }
        /// <summary> Backend Service Fabric Cluster Properties. </summary>
        [WirePath("properties.properties.serviceFabricCluster")]
        public BackendServiceFabricClusterProperties BackendServiceFabricCluster
        {
            get => Properties is null ? default : Properties.ServiceFabricCluster;
            set
            {
                if (Properties is null)
                    Properties = new BackendProperties();
                Properties.ServiceFabricCluster = value;
            }
        }

        /// <summary> Backend Credentials Contract Properties. </summary>
        [WirePath("properties.credentials")]
        public BackendCredentialsContract Credentials { get; set; }
        /// <summary> Backend gateway Contract Properties. </summary>
        [WirePath("properties.proxy")]
        public BackendProxyContract Proxy { get; set; }
        /// <summary> Backend TLS Properties. </summary>
        [WirePath("properties.tls")]
        public BackendTlsProperties Tls { get; set; }
        /// <summary> Backend Circuit Breaker Configuration. </summary>
        internal BackendCircuitBreaker CircuitBreaker { get; set; }
        /// <summary> The rules for tripping the backend. </summary>
        [WirePath("properties.circuitBreaker.rules")]
        public IList<CircuitBreakerRule> CircuitBreakerRules
        {
            get
            {
                if (CircuitBreaker is null)
                    CircuitBreaker = new BackendCircuitBreaker();
                return CircuitBreaker.Rules;
            }
        }

        /// <summary> Runtime Url of the Backend. </summary>
        [WirePath("properties.url")]
        public Uri Uri { get; set; }
        /// <summary> Backend communication protocol. </summary>
        [WirePath("properties.protocol")]
        public BackendProtocol? Protocol { get; set; }
    }
}
