// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.ApiManagement.Models
{
    public partial class ApiManagementAuthorizationServerPatch : IUtf8JsonSerializable, IJsonModel<ApiManagementAuthorizationServerPatch>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ApiManagementAuthorizationServerPatch>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ApiManagementAuthorizationServerPatch>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ApiManagementAuthorizationServerPatch>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ApiManagementAuthorizationServerPatch)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(Description))
            {
                writer.WritePropertyName("description"u8);
                writer.WriteStringValue(Description);
            }
            if (Optional.IsCollectionDefined(AuthorizationMethods))
            {
                writer.WritePropertyName("authorizationMethods"u8);
                writer.WriteStartArray();
                foreach (var item in AuthorizationMethods)
                {
                    writer.WriteStringValue(item.ToSerialString());
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(ClientAuthenticationMethods))
            {
                writer.WritePropertyName("clientAuthenticationMethod"u8);
                writer.WriteStartArray();
                foreach (var item in ClientAuthenticationMethods)
                {
                    writer.WriteStringValue(item.ToString());
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(TokenBodyParameters))
            {
                writer.WritePropertyName("tokenBodyParameters"u8);
                writer.WriteStartArray();
                foreach (var item in TokenBodyParameters)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(TokenEndpoint))
            {
                writer.WritePropertyName("tokenEndpoint"u8);
                writer.WriteStringValue(TokenEndpoint);
            }
            if (Optional.IsDefined(DoesSupportState))
            {
                writer.WritePropertyName("supportState"u8);
                writer.WriteBooleanValue(DoesSupportState.Value);
            }
            if (Optional.IsDefined(DefaultScope))
            {
                writer.WritePropertyName("defaultScope"u8);
                writer.WriteStringValue(DefaultScope);
            }
            if (Optional.IsCollectionDefined(BearerTokenSendingMethods))
            {
                writer.WritePropertyName("bearerTokenSendingMethods"u8);
                writer.WriteStartArray();
                foreach (var item in BearerTokenSendingMethods)
                {
                    writer.WriteStringValue(item.ToString());
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(ResourceOwnerUsername))
            {
                writer.WritePropertyName("resourceOwnerUsername"u8);
                writer.WriteStringValue(ResourceOwnerUsername);
            }
            if (Optional.IsDefined(ResourceOwnerPassword))
            {
                writer.WritePropertyName("resourceOwnerPassword"u8);
                writer.WriteStringValue(ResourceOwnerPassword);
            }
            if (Optional.IsDefined(DisplayName))
            {
                writer.WritePropertyName("displayName"u8);
                writer.WriteStringValue(DisplayName);
            }
            if (Optional.IsDefined(UseInTestConsole))
            {
                writer.WritePropertyName("useInTestConsole"u8);
                writer.WriteBooleanValue(UseInTestConsole.Value);
            }
            if (Optional.IsDefined(UseInApiDocumentation))
            {
                writer.WritePropertyName("useInApiDocumentation"u8);
                writer.WriteBooleanValue(UseInApiDocumentation.Value);
            }
            if (Optional.IsDefined(ClientRegistrationEndpoint))
            {
                writer.WritePropertyName("clientRegistrationEndpoint"u8);
                writer.WriteStringValue(ClientRegistrationEndpoint);
            }
            if (Optional.IsDefined(AuthorizationEndpoint))
            {
                writer.WritePropertyName("authorizationEndpoint"u8);
                writer.WriteStringValue(AuthorizationEndpoint);
            }
            if (Optional.IsCollectionDefined(GrantTypes))
            {
                writer.WritePropertyName("grantTypes"u8);
                writer.WriteStartArray();
                foreach (var item in GrantTypes)
                {
                    writer.WriteStringValue(item.ToString());
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(ClientId))
            {
                writer.WritePropertyName("clientId"u8);
                writer.WriteStringValue(ClientId);
            }
            if (Optional.IsDefined(ClientSecret))
            {
                writer.WritePropertyName("clientSecret"u8);
                writer.WriteStringValue(ClientSecret);
            }
            writer.WriteEndObject();
        }

        ApiManagementAuthorizationServerPatch IJsonModel<ApiManagementAuthorizationServerPatch>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ApiManagementAuthorizationServerPatch>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ApiManagementAuthorizationServerPatch)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeApiManagementAuthorizationServerPatch(document.RootElement, options);
        }

        internal static ApiManagementAuthorizationServerPatch DeserializeApiManagementAuthorizationServerPatch(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string description = default;
            IList<AuthorizationMethod> authorizationMethods = default;
            IList<ClientAuthenticationMethod> clientAuthenticationMethod = default;
            IList<TokenBodyParameterContract> tokenBodyParameters = default;
            string tokenEndpoint = default;
            bool? supportState = default;
            string defaultScope = default;
            IList<BearerTokenSendingMethod> bearerTokenSendingMethods = default;
            string resourceOwnerUsername = default;
            string resourceOwnerPassword = default;
            string displayName = default;
            bool? useInTestConsole = default;
            bool? useInApiDocumentation = default;
            string clientRegistrationEndpoint = default;
            string authorizationEndpoint = default;
            IList<GrantType> grantTypes = default;
            string clientId = default;
            string clientSecret = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("description"u8))
                        {
                            description = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("authorizationMethods"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<AuthorizationMethod> array = new List<AuthorizationMethod>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString().ToAuthorizationMethod());
                            }
                            authorizationMethods = array;
                            continue;
                        }
                        if (property0.NameEquals("clientAuthenticationMethod"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<ClientAuthenticationMethod> array = new List<ClientAuthenticationMethod>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(new ClientAuthenticationMethod(item.GetString()));
                            }
                            clientAuthenticationMethod = array;
                            continue;
                        }
                        if (property0.NameEquals("tokenBodyParameters"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<TokenBodyParameterContract> array = new List<TokenBodyParameterContract>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(TokenBodyParameterContract.DeserializeTokenBodyParameterContract(item, options));
                            }
                            tokenBodyParameters = array;
                            continue;
                        }
                        if (property0.NameEquals("tokenEndpoint"u8))
                        {
                            tokenEndpoint = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("supportState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            supportState = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("defaultScope"u8))
                        {
                            defaultScope = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("bearerTokenSendingMethods"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<BearerTokenSendingMethod> array = new List<BearerTokenSendingMethod>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(new BearerTokenSendingMethod(item.GetString()));
                            }
                            bearerTokenSendingMethods = array;
                            continue;
                        }
                        if (property0.NameEquals("resourceOwnerUsername"u8))
                        {
                            resourceOwnerUsername = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("resourceOwnerPassword"u8))
                        {
                            resourceOwnerPassword = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("displayName"u8))
                        {
                            displayName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("useInTestConsole"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            useInTestConsole = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("useInApiDocumentation"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            useInApiDocumentation = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("clientRegistrationEndpoint"u8))
                        {
                            clientRegistrationEndpoint = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("authorizationEndpoint"u8))
                        {
                            authorizationEndpoint = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("grantTypes"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<GrantType> array = new List<GrantType>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(new GrantType(item.GetString()));
                            }
                            grantTypes = array;
                            continue;
                        }
                        if (property0.NameEquals("clientId"u8))
                        {
                            clientId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("clientSecret"u8))
                        {
                            clientSecret = property0.Value.GetString();
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ApiManagementAuthorizationServerPatch(
                id,
                name,
                type,
                systemData,
                description,
                authorizationMethods ?? new ChangeTrackingList<AuthorizationMethod>(),
                clientAuthenticationMethod ?? new ChangeTrackingList<ClientAuthenticationMethod>(),
                tokenBodyParameters ?? new ChangeTrackingList<TokenBodyParameterContract>(),
                tokenEndpoint,
                supportState,
                defaultScope,
                bearerTokenSendingMethods ?? new ChangeTrackingList<BearerTokenSendingMethod>(),
                resourceOwnerUsername,
                resourceOwnerPassword,
                displayName,
                useInTestConsole,
                useInApiDocumentation,
                clientRegistrationEndpoint,
                authorizationEndpoint,
                grantTypes ?? new ChangeTrackingList<GrantType>(),
                clientId,
                clientSecret,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Name), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  name: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Name))
                {
                    builder.Append("  name: ");
                    if (Name.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Name}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Name}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Id), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  id: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Id))
                {
                    builder.Append("  id: ");
                    builder.AppendLine($"'{Id.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SystemData), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  systemData: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SystemData))
                {
                    builder.Append("  systemData: ");
                    builder.AppendLine($"'{SystemData.ToString()}'");
                }
            }

            builder.Append("  properties:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Description), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    description: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Description))
                {
                    builder.Append("    description: ");
                    if (Description.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Description}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Description}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AuthorizationMethods), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    authorizationMethods: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(AuthorizationMethods))
                {
                    if (AuthorizationMethods.Any())
                    {
                        builder.Append("    authorizationMethods: ");
                        builder.AppendLine("[");
                        foreach (var item in AuthorizationMethods)
                        {
                            builder.AppendLine($"      '{item.ToSerialString()}'");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ClientAuthenticationMethods), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    clientAuthenticationMethod: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(ClientAuthenticationMethods))
                {
                    if (ClientAuthenticationMethods.Any())
                    {
                        builder.Append("    clientAuthenticationMethod: ");
                        builder.AppendLine("[");
                        foreach (var item in ClientAuthenticationMethods)
                        {
                            builder.AppendLine($"      '{item.ToString()}'");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TokenBodyParameters), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    tokenBodyParameters: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(TokenBodyParameters))
                {
                    if (TokenBodyParameters.Any())
                    {
                        builder.Append("    tokenBodyParameters: ");
                        builder.AppendLine("[");
                        foreach (var item in TokenBodyParameters)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    tokenBodyParameters: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TokenEndpoint), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    tokenEndpoint: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TokenEndpoint))
                {
                    builder.Append("    tokenEndpoint: ");
                    if (TokenEndpoint.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{TokenEndpoint}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{TokenEndpoint}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DoesSupportState), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    supportState: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DoesSupportState))
                {
                    builder.Append("    supportState: ");
                    var boolValue = DoesSupportState.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DefaultScope), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    defaultScope: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DefaultScope))
                {
                    builder.Append("    defaultScope: ");
                    if (DefaultScope.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{DefaultScope}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{DefaultScope}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(BearerTokenSendingMethods), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    bearerTokenSendingMethods: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(BearerTokenSendingMethods))
                {
                    if (BearerTokenSendingMethods.Any())
                    {
                        builder.Append("    bearerTokenSendingMethods: ");
                        builder.AppendLine("[");
                        foreach (var item in BearerTokenSendingMethods)
                        {
                            builder.AppendLine($"      '{item.ToString()}'");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ResourceOwnerUsername), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    resourceOwnerUsername: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ResourceOwnerUsername))
                {
                    builder.Append("    resourceOwnerUsername: ");
                    if (ResourceOwnerUsername.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ResourceOwnerUsername}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ResourceOwnerUsername}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ResourceOwnerPassword), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    resourceOwnerPassword: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ResourceOwnerPassword))
                {
                    builder.Append("    resourceOwnerPassword: ");
                    if (ResourceOwnerPassword.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ResourceOwnerPassword}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ResourceOwnerPassword}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DisplayName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    displayName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DisplayName))
                {
                    builder.Append("    displayName: ");
                    if (DisplayName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{DisplayName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{DisplayName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(UseInTestConsole), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    useInTestConsole: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(UseInTestConsole))
                {
                    builder.Append("    useInTestConsole: ");
                    var boolValue = UseInTestConsole.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(UseInApiDocumentation), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    useInApiDocumentation: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(UseInApiDocumentation))
                {
                    builder.Append("    useInApiDocumentation: ");
                    var boolValue = UseInApiDocumentation.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ClientRegistrationEndpoint), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    clientRegistrationEndpoint: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ClientRegistrationEndpoint))
                {
                    builder.Append("    clientRegistrationEndpoint: ");
                    if (ClientRegistrationEndpoint.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ClientRegistrationEndpoint}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ClientRegistrationEndpoint}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AuthorizationEndpoint), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    authorizationEndpoint: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AuthorizationEndpoint))
                {
                    builder.Append("    authorizationEndpoint: ");
                    if (AuthorizationEndpoint.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{AuthorizationEndpoint}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{AuthorizationEndpoint}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(GrantTypes), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    grantTypes: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(GrantTypes))
                {
                    if (GrantTypes.Any())
                    {
                        builder.Append("    grantTypes: ");
                        builder.AppendLine("[");
                        foreach (var item in GrantTypes)
                        {
                            builder.AppendLine($"      '{item.ToString()}'");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ClientId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    clientId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ClientId))
                {
                    builder.Append("    clientId: ");
                    if (ClientId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ClientId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ClientId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ClientSecret), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    clientSecret: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ClientSecret))
                {
                    builder.Append("    clientSecret: ");
                    if (ClientSecret.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ClientSecret}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ClientSecret}'");
                    }
                }
            }

            builder.AppendLine("  }");
            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<ApiManagementAuthorizationServerPatch>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ApiManagementAuthorizationServerPatch>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(ApiManagementAuthorizationServerPatch)} does not support writing '{options.Format}' format.");
            }
        }

        ApiManagementAuthorizationServerPatch IPersistableModel<ApiManagementAuthorizationServerPatch>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ApiManagementAuthorizationServerPatch>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeApiManagementAuthorizationServerPatch(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ApiManagementAuthorizationServerPatch)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ApiManagementAuthorizationServerPatch>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
