// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ApiManagement.Models
{
    /// <summary> API contact information. </summary>
    public partial class ApiContactInformation
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ApiContactInformation"/>. </summary>
        public ApiContactInformation()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ApiContactInformation"/>. </summary>
        /// <param name="name"> The identifying name of the contact person/organization. </param>
        /// <param name="uri"> The URL pointing to the contact information. MUST be in the format of a URL. </param>
        /// <param name="email"> The email address of the contact person/organization. MUST be in the format of an email address. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ApiContactInformation(string name, Uri uri, string email, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Uri = uri;
            Email = email;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The identifying name of the contact person/organization. </summary>
        [WirePath("name")]
        public string Name { get; set; }
        /// <summary> The URL pointing to the contact information. MUST be in the format of a URL. </summary>
        [WirePath("url")]
        public Uri Uri { get; set; }
        /// <summary> The email address of the contact person/organization. MUST be in the format of an email address. </summary>
        [WirePath("email")]
        public string Email { get; set; }
    }
}
