// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ApiManagement
{
    internal class ServiceWorkspaceSchemaOperationSource : IOperationSource<ServiceWorkspaceSchemaResource>
    {
        private readonly ArmClient _client;

        internal ServiceWorkspaceSchemaOperationSource(ArmClient client)
        {
            _client = client;
        }

        ServiceWorkspaceSchemaResource IOperationSource<ServiceWorkspaceSchemaResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ApiManagementGlobalSchemaData.DeserializeApiManagementGlobalSchemaData(document.RootElement);
            return new ServiceWorkspaceSchemaResource(_client, data);
        }

        async ValueTask<ServiceWorkspaceSchemaResource> IOperationSource<ServiceWorkspaceSchemaResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ApiManagementGlobalSchemaData.DeserializeApiManagementGlobalSchemaData(document.RootElement);
            return new ServiceWorkspaceSchemaResource(_client, data);
        }
    }
}
