// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ApiManagement
{
    internal class ServiceWorkspaceNamedValueOperationSource : IOperationSource<ServiceWorkspaceNamedValueResource>
    {
        private readonly ArmClient _client;

        internal ServiceWorkspaceNamedValueOperationSource(ArmClient client)
        {
            _client = client;
        }

        ServiceWorkspaceNamedValueResource IOperationSource<ServiceWorkspaceNamedValueResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ApiManagementNamedValueData.DeserializeApiManagementNamedValueData(document.RootElement);
            return new ServiceWorkspaceNamedValueResource(_client, data);
        }

        async ValueTask<ServiceWorkspaceNamedValueResource> IOperationSource<ServiceWorkspaceNamedValueResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ApiManagementNamedValueData.DeserializeApiManagementNamedValueData(document.RootElement);
            return new ServiceWorkspaceNamedValueResource(_client, data);
        }
    }
}
