// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ApiManagement
{
    internal class ServiceWorkspaceApiOperationSource : IOperationSource<ServiceWorkspaceApiResource>
    {
        private readonly ArmClient _client;

        internal ServiceWorkspaceApiOperationSource(ArmClient client)
        {
            _client = client;
        }

        ServiceWorkspaceApiResource IOperationSource<ServiceWorkspaceApiResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ApiData.DeserializeApiData(document.RootElement);
            return new ServiceWorkspaceApiResource(_client, data);
        }

        async ValueTask<ServiceWorkspaceApiResource> IOperationSource<ServiceWorkspaceApiResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ApiData.DeserializeApiData(document.RootElement);
            return new ServiceWorkspaceApiResource(_client, data);
        }
    }
}
