// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ApiManagement
{
    internal class ApiOperationSource : IOperationSource<ApiResource>
    {
        private readonly ArmClient _client;

        internal ApiOperationSource(ArmClient client)
        {
            _client = client;
        }

        ApiResource IOperationSource<ApiResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ApiData.DeserializeApiData(document.RootElement);
            return new ApiResource(_client, data);
        }

        async ValueTask<ApiResource> IOperationSource<ApiResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ApiData.DeserializeApiData(document.RootElement);
            return new ApiResource(_client, data);
        }
    }
}
