// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.ApiManagement.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableApiManagementArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableApiManagementArmClient"/> class for mocking. </summary>
        protected MockableApiManagementArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableApiManagementArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableApiManagementArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableApiManagementArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiResource.CreateResourceIdentifier" /> to create an <see cref="ApiResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiResource"/> object. </returns>
        public virtual ApiResource GetApiResource(ResourceIdentifier id)
        {
            ApiResource.ValidateResourceId(id);
            return new ApiResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ServiceWorkspaceApiResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ServiceWorkspaceApiResource.CreateResourceIdentifier" /> to create a <see cref="ServiceWorkspaceApiResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ServiceWorkspaceApiResource"/> object. </returns>
        public virtual ServiceWorkspaceApiResource GetServiceWorkspaceApiResource(ResourceIdentifier id)
        {
            ServiceWorkspaceApiResource.ValidateResourceId(id);
            return new ServiceWorkspaceApiResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiReleaseResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiReleaseResource.CreateResourceIdentifier" /> to create an <see cref="ApiReleaseResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiReleaseResource"/> object. </returns>
        public virtual ApiReleaseResource GetApiReleaseResource(ResourceIdentifier id)
        {
            ApiReleaseResource.ValidateResourceId(id);
            return new ApiReleaseResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ServiceWorkspaceApiReleaseResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ServiceWorkspaceApiReleaseResource.CreateResourceIdentifier" /> to create a <see cref="ServiceWorkspaceApiReleaseResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ServiceWorkspaceApiReleaseResource"/> object. </returns>
        public virtual ServiceWorkspaceApiReleaseResource GetServiceWorkspaceApiReleaseResource(ResourceIdentifier id)
        {
            ServiceWorkspaceApiReleaseResource.ValidateResourceId(id);
            return new ServiceWorkspaceApiReleaseResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiOperationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiOperationResource.CreateResourceIdentifier" /> to create an <see cref="ApiOperationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiOperationResource"/> object. </returns>
        public virtual ApiOperationResource GetApiOperationResource(ResourceIdentifier id)
        {
            ApiOperationResource.ValidateResourceId(id);
            return new ApiOperationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ServiceWorkspaceApiOperationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ServiceWorkspaceApiOperationResource.CreateResourceIdentifier" /> to create a <see cref="ServiceWorkspaceApiOperationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ServiceWorkspaceApiOperationResource"/> object. </returns>
        public virtual ServiceWorkspaceApiOperationResource GetServiceWorkspaceApiOperationResource(ResourceIdentifier id)
        {
            ServiceWorkspaceApiOperationResource.ValidateResourceId(id);
            return new ServiceWorkspaceApiOperationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiOperationPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiOperationPolicyResource.CreateResourceIdentifier" /> to create an <see cref="ApiOperationPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiOperationPolicyResource"/> object. </returns>
        public virtual ApiOperationPolicyResource GetApiOperationPolicyResource(ResourceIdentifier id)
        {
            ApiOperationPolicyResource.ValidateResourceId(id);
            return new ApiOperationPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ServiceApiResolverPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ServiceApiResolverPolicyResource.CreateResourceIdentifier" /> to create a <see cref="ServiceApiResolverPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ServiceApiResolverPolicyResource"/> object. </returns>
        public virtual ServiceApiResolverPolicyResource GetServiceApiResolverPolicyResource(ResourceIdentifier id)
        {
            ServiceApiResolverPolicyResource.ValidateResourceId(id);
            return new ServiceApiResolverPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiPolicyResource.CreateResourceIdentifier" /> to create an <see cref="ApiPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiPolicyResource"/> object. </returns>
        public virtual ApiPolicyResource GetApiPolicyResource(ResourceIdentifier id)
        {
            ApiPolicyResource.ValidateResourceId(id);
            return new ApiPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiManagementPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiManagementPolicyResource.CreateResourceIdentifier" /> to create an <see cref="ApiManagementPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiManagementPolicyResource"/> object. </returns>
        public virtual ApiManagementPolicyResource GetApiManagementPolicyResource(ResourceIdentifier id)
        {
            ApiManagementPolicyResource.ValidateResourceId(id);
            return new ApiManagementPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiManagementProductPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiManagementProductPolicyResource.CreateResourceIdentifier" /> to create an <see cref="ApiManagementProductPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiManagementProductPolicyResource"/> object. </returns>
        public virtual ApiManagementProductPolicyResource GetApiManagementProductPolicyResource(ResourceIdentifier id)
        {
            ApiManagementProductPolicyResource.ValidateResourceId(id);
            return new ApiManagementProductPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ServiceWorkspacePolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ServiceWorkspacePolicyResource.CreateResourceIdentifier" /> to create a <see cref="ServiceWorkspacePolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ServiceWorkspacePolicyResource"/> object. </returns>
        public virtual ServiceWorkspacePolicyResource GetServiceWorkspacePolicyResource(ResourceIdentifier id)
        {
            ServiceWorkspacePolicyResource.ValidateResourceId(id);
            return new ServiceWorkspacePolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ServiceWorkspaceApiOperationPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ServiceWorkspaceApiOperationPolicyResource.CreateResourceIdentifier" /> to create a <see cref="ServiceWorkspaceApiOperationPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ServiceWorkspaceApiOperationPolicyResource"/> object. </returns>
        public virtual ServiceWorkspaceApiOperationPolicyResource GetServiceWorkspaceApiOperationPolicyResource(ResourceIdentifier id)
        {
            ServiceWorkspaceApiOperationPolicyResource.ValidateResourceId(id);
            return new ServiceWorkspaceApiOperationPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ServiceWorkspaceApiPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ServiceWorkspaceApiPolicyResource.CreateResourceIdentifier" /> to create a <see cref="ServiceWorkspaceApiPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ServiceWorkspaceApiPolicyResource"/> object. </returns>
        public virtual ServiceWorkspaceApiPolicyResource GetServiceWorkspaceApiPolicyResource(ResourceIdentifier id)
        {
            ServiceWorkspaceApiPolicyResource.ValidateResourceId(id);
            return new ServiceWorkspaceApiPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ServiceWorkspaceProductPolicyResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ServiceWorkspaceProductPolicyResource.CreateResourceIdentifier" /> to create a <see cref="ServiceWorkspaceProductPolicyResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ServiceWorkspaceProductPolicyResource"/> object. </returns>
        public virtual ServiceWorkspaceProductPolicyResource GetServiceWorkspaceProductPolicyResource(ResourceIdentifier id)
        {
            ServiceWorkspaceProductPolicyResource.ValidateResourceId(id);
            return new ServiceWorkspaceProductPolicyResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiOperationTagResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiOperationTagResource.CreateResourceIdentifier" /> to create an <see cref="ApiOperationTagResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiOperationTagResource"/> object. </returns>
        public virtual ApiOperationTagResource GetApiOperationTagResource(ResourceIdentifier id)
        {
            ApiOperationTagResource.ValidateResourceId(id);
            return new ApiOperationTagResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiTagResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiTagResource.CreateResourceIdentifier" /> to create an <see cref="ApiTagResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiTagResource"/> object. </returns>
        public virtual ApiTagResource GetApiTagResource(ResourceIdentifier id)
        {
            ApiTagResource.ValidateResourceId(id);
            return new ApiTagResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiManagementProductTagResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiManagementProductTagResource.CreateResourceIdentifier" /> to create an <see cref="ApiManagementProductTagResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiManagementProductTagResource"/> object. </returns>
        public virtual ApiManagementProductTagResource GetApiManagementProductTagResource(ResourceIdentifier id)
        {
            ApiManagementProductTagResource.ValidateResourceId(id);
            return new ApiManagementProductTagResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiManagementTagResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiManagementTagResource.CreateResourceIdentifier" /> to create an <see cref="ApiManagementTagResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiManagementTagResource"/> object. </returns>
        public virtual ApiManagementTagResource GetApiManagementTagResource(ResourceIdentifier id)
        {
            ApiManagementTagResource.ValidateResourceId(id);
            return new ApiManagementTagResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ServiceWorkspaceTagResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ServiceWorkspaceTagResource.CreateResourceIdentifier" /> to create a <see cref="ServiceWorkspaceTagResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ServiceWorkspaceTagResource"/> object. </returns>
        public virtual ServiceWorkspaceTagResource GetServiceWorkspaceTagResource(ResourceIdentifier id)
        {
            ServiceWorkspaceTagResource.ValidateResourceId(id);
            return new ServiceWorkspaceTagResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ResolverContractResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ResolverContractResource.CreateResourceIdentifier" /> to create a <see cref="ResolverContractResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ResolverContractResource"/> object. </returns>
        public virtual ResolverContractResource GetResolverContractResource(ResourceIdentifier id)
        {
            ResolverContractResource.ValidateResourceId(id);
            return new ResolverContractResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiSchemaResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiSchemaResource.CreateResourceIdentifier" /> to create an <see cref="ApiSchemaResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiSchemaResource"/> object. </returns>
        public virtual ApiSchemaResource GetApiSchemaResource(ResourceIdentifier id)
        {
            ApiSchemaResource.ValidateResourceId(id);
            return new ApiSchemaResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ServiceWorkspaceApiSchemaResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ServiceWorkspaceApiSchemaResource.CreateResourceIdentifier" /> to create a <see cref="ServiceWorkspaceApiSchemaResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ServiceWorkspaceApiSchemaResource"/> object. </returns>
        public virtual ServiceWorkspaceApiSchemaResource GetServiceWorkspaceApiSchemaResource(ResourceIdentifier id)
        {
            ServiceWorkspaceApiSchemaResource.ValidateResourceId(id);
            return new ServiceWorkspaceApiSchemaResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiDiagnosticResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiDiagnosticResource.CreateResourceIdentifier" /> to create an <see cref="ApiDiagnosticResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiDiagnosticResource"/> object. </returns>
        public virtual ApiDiagnosticResource GetApiDiagnosticResource(ResourceIdentifier id)
        {
            ApiDiagnosticResource.ValidateResourceId(id);
            return new ApiDiagnosticResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiManagementDiagnosticResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiManagementDiagnosticResource.CreateResourceIdentifier" /> to create an <see cref="ApiManagementDiagnosticResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiManagementDiagnosticResource"/> object. </returns>
        public virtual ApiManagementDiagnosticResource GetApiManagementDiagnosticResource(ResourceIdentifier id)
        {
            ApiManagementDiagnosticResource.ValidateResourceId(id);
            return new ApiManagementDiagnosticResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiIssueResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiIssueResource.CreateResourceIdentifier" /> to create an <see cref="ApiIssueResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiIssueResource"/> object. </returns>
        public virtual ApiIssueResource GetApiIssueResource(ResourceIdentifier id)
        {
            ApiIssueResource.ValidateResourceId(id);
            return new ApiIssueResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiManagementIssueResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiManagementIssueResource.CreateResourceIdentifier" /> to create an <see cref="ApiManagementIssueResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiManagementIssueResource"/> object. </returns>
        public virtual ApiManagementIssueResource GetApiManagementIssueResource(ResourceIdentifier id)
        {
            ApiManagementIssueResource.ValidateResourceId(id);
            return new ApiManagementIssueResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiIssueCommentResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiIssueCommentResource.CreateResourceIdentifier" /> to create an <see cref="ApiIssueCommentResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiIssueCommentResource"/> object. </returns>
        public virtual ApiIssueCommentResource GetApiIssueCommentResource(ResourceIdentifier id)
        {
            ApiIssueCommentResource.ValidateResourceId(id);
            return new ApiIssueCommentResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiIssueAttachmentResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiIssueAttachmentResource.CreateResourceIdentifier" /> to create an <see cref="ApiIssueAttachmentResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiIssueAttachmentResource"/> object. </returns>
        public virtual ApiIssueAttachmentResource GetApiIssueAttachmentResource(ResourceIdentifier id)
        {
            ApiIssueAttachmentResource.ValidateResourceId(id);
            return new ApiIssueAttachmentResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiTagDescriptionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiTagDescriptionResource.CreateResourceIdentifier" /> to create an <see cref="ApiTagDescriptionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiTagDescriptionResource"/> object. </returns>
        public virtual ApiTagDescriptionResource GetApiTagDescriptionResource(ResourceIdentifier id)
        {
            ApiTagDescriptionResource.ValidateResourceId(id);
            return new ApiTagDescriptionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ServiceApiWikiResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ServiceApiWikiResource.CreateResourceIdentifier" /> to create a <see cref="ServiceApiWikiResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ServiceApiWikiResource"/> object. </returns>
        public virtual ServiceApiWikiResource GetServiceApiWikiResource(ResourceIdentifier id)
        {
            ServiceApiWikiResource.ValidateResourceId(id);
            return new ServiceApiWikiResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ServiceProductWikiResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ServiceProductWikiResource.CreateResourceIdentifier" /> to create a <see cref="ServiceProductWikiResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ServiceProductWikiResource"/> object. </returns>
        public virtual ServiceProductWikiResource GetServiceProductWikiResource(ResourceIdentifier id)
        {
            ServiceProductWikiResource.ValidateResourceId(id);
            return new ServiceProductWikiResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiVersionSetResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiVersionSetResource.CreateResourceIdentifier" /> to create an <see cref="ApiVersionSetResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiVersionSetResource"/> object. </returns>
        public virtual ApiVersionSetResource GetApiVersionSetResource(ResourceIdentifier id)
        {
            ApiVersionSetResource.ValidateResourceId(id);
            return new ApiVersionSetResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ServiceWorkspaceApiVersionSetResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ServiceWorkspaceApiVersionSetResource.CreateResourceIdentifier" /> to create a <see cref="ServiceWorkspaceApiVersionSetResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ServiceWorkspaceApiVersionSetResource"/> object. </returns>
        public virtual ServiceWorkspaceApiVersionSetResource GetServiceWorkspaceApiVersionSetResource(ResourceIdentifier id)
        {
            ServiceWorkspaceApiVersionSetResource.ValidateResourceId(id);
            return new ServiceWorkspaceApiVersionSetResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="AuthorizationProviderContractResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="AuthorizationProviderContractResource.CreateResourceIdentifier" /> to create an <see cref="AuthorizationProviderContractResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="AuthorizationProviderContractResource"/> object. </returns>
        public virtual AuthorizationProviderContractResource GetAuthorizationProviderContractResource(ResourceIdentifier id)
        {
            AuthorizationProviderContractResource.ValidateResourceId(id);
            return new AuthorizationProviderContractResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="AuthorizationContractResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="AuthorizationContractResource.CreateResourceIdentifier" /> to create an <see cref="AuthorizationContractResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="AuthorizationContractResource"/> object. </returns>
        public virtual AuthorizationContractResource GetAuthorizationContractResource(ResourceIdentifier id)
        {
            AuthorizationContractResource.ValidateResourceId(id);
            return new AuthorizationContractResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="AuthorizationAccessPolicyContractResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="AuthorizationAccessPolicyContractResource.CreateResourceIdentifier" /> to create an <see cref="AuthorizationAccessPolicyContractResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="AuthorizationAccessPolicyContractResource"/> object. </returns>
        public virtual AuthorizationAccessPolicyContractResource GetAuthorizationAccessPolicyContractResource(ResourceIdentifier id)
        {
            AuthorizationAccessPolicyContractResource.ValidateResourceId(id);
            return new AuthorizationAccessPolicyContractResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiManagementAuthorizationServerResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiManagementAuthorizationServerResource.CreateResourceIdentifier" /> to create an <see cref="ApiManagementAuthorizationServerResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiManagementAuthorizationServerResource"/> object. </returns>
        public virtual ApiManagementAuthorizationServerResource GetApiManagementAuthorizationServerResource(ResourceIdentifier id)
        {
            ApiManagementAuthorizationServerResource.ValidateResourceId(id);
            return new ApiManagementAuthorizationServerResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiManagementBackendResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiManagementBackendResource.CreateResourceIdentifier" /> to create an <see cref="ApiManagementBackendResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiManagementBackendResource"/> object. </returns>
        public virtual ApiManagementBackendResource GetApiManagementBackendResource(ResourceIdentifier id)
        {
            ApiManagementBackendResource.ValidateResourceId(id);
            return new ApiManagementBackendResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiManagementCacheResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiManagementCacheResource.CreateResourceIdentifier" /> to create an <see cref="ApiManagementCacheResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiManagementCacheResource"/> object. </returns>
        public virtual ApiManagementCacheResource GetApiManagementCacheResource(ResourceIdentifier id)
        {
            ApiManagementCacheResource.ValidateResourceId(id);
            return new ApiManagementCacheResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiManagementCertificateResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiManagementCertificateResource.CreateResourceIdentifier" /> to create an <see cref="ApiManagementCertificateResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiManagementCertificateResource"/> object. </returns>
        public virtual ApiManagementCertificateResource GetApiManagementCertificateResource(ResourceIdentifier id)
        {
            ApiManagementCertificateResource.ValidateResourceId(id);
            return new ApiManagementCertificateResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiManagementDeletedServiceResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiManagementDeletedServiceResource.CreateResourceIdentifier" /> to create an <see cref="ApiManagementDeletedServiceResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiManagementDeletedServiceResource"/> object. </returns>
        public virtual ApiManagementDeletedServiceResource GetApiManagementDeletedServiceResource(ResourceIdentifier id)
        {
            ApiManagementDeletedServiceResource.ValidateResourceId(id);
            return new ApiManagementDeletedServiceResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiManagementServiceResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiManagementServiceResource.CreateResourceIdentifier" /> to create an <see cref="ApiManagementServiceResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiManagementServiceResource"/> object. </returns>
        public virtual ApiManagementServiceResource GetApiManagementServiceResource(ResourceIdentifier id)
        {
            ApiManagementServiceResource.ValidateResourceId(id);
            return new ApiManagementServiceResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DocumentationContractResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DocumentationContractResource.CreateResourceIdentifier" /> to create a <see cref="DocumentationContractResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DocumentationContractResource"/> object. </returns>
        public virtual DocumentationContractResource GetDocumentationContractResource(ResourceIdentifier id)
        {
            DocumentationContractResource.ValidateResourceId(id);
            return new DocumentationContractResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiManagementEmailTemplateResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiManagementEmailTemplateResource.CreateResourceIdentifier" /> to create an <see cref="ApiManagementEmailTemplateResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiManagementEmailTemplateResource"/> object. </returns>
        public virtual ApiManagementEmailTemplateResource GetApiManagementEmailTemplateResource(ResourceIdentifier id)
        {
            ApiManagementEmailTemplateResource.ValidateResourceId(id);
            return new ApiManagementEmailTemplateResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiManagementGatewayResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiManagementGatewayResource.CreateResourceIdentifier" /> to create an <see cref="ApiManagementGatewayResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiManagementGatewayResource"/> object. </returns>
        public virtual ApiManagementGatewayResource GetApiManagementGatewayResource(ResourceIdentifier id)
        {
            ApiManagementGatewayResource.ValidateResourceId(id);
            return new ApiManagementGatewayResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiManagementGatewayHostnameConfigurationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiManagementGatewayHostnameConfigurationResource.CreateResourceIdentifier" /> to create an <see cref="ApiManagementGatewayHostnameConfigurationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiManagementGatewayHostnameConfigurationResource"/> object. </returns>
        public virtual ApiManagementGatewayHostnameConfigurationResource GetApiManagementGatewayHostnameConfigurationResource(ResourceIdentifier id)
        {
            ApiManagementGatewayHostnameConfigurationResource.ValidateResourceId(id);
            return new ApiManagementGatewayHostnameConfigurationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiManagementGatewayCertificateAuthorityResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiManagementGatewayCertificateAuthorityResource.CreateResourceIdentifier" /> to create an <see cref="ApiManagementGatewayCertificateAuthorityResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiManagementGatewayCertificateAuthorityResource"/> object. </returns>
        public virtual ApiManagementGatewayCertificateAuthorityResource GetApiManagementGatewayCertificateAuthorityResource(ResourceIdentifier id)
        {
            ApiManagementGatewayCertificateAuthorityResource.ValidateResourceId(id);
            return new ApiManagementGatewayCertificateAuthorityResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiManagementGroupResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiManagementGroupResource.CreateResourceIdentifier" /> to create an <see cref="ApiManagementGroupResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiManagementGroupResource"/> object. </returns>
        public virtual ApiManagementGroupResource GetApiManagementGroupResource(ResourceIdentifier id)
        {
            ApiManagementGroupResource.ValidateResourceId(id);
            return new ApiManagementGroupResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ServiceWorkspaceGroupResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ServiceWorkspaceGroupResource.CreateResourceIdentifier" /> to create a <see cref="ServiceWorkspaceGroupResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ServiceWorkspaceGroupResource"/> object. </returns>
        public virtual ServiceWorkspaceGroupResource GetServiceWorkspaceGroupResource(ResourceIdentifier id)
        {
            ServiceWorkspaceGroupResource.ValidateResourceId(id);
            return new ServiceWorkspaceGroupResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiManagementIdentityProviderResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiManagementIdentityProviderResource.CreateResourceIdentifier" /> to create an <see cref="ApiManagementIdentityProviderResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiManagementIdentityProviderResource"/> object. </returns>
        public virtual ApiManagementIdentityProviderResource GetApiManagementIdentityProviderResource(ResourceIdentifier id)
        {
            ApiManagementIdentityProviderResource.ValidateResourceId(id);
            return new ApiManagementIdentityProviderResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiManagementLoggerResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiManagementLoggerResource.CreateResourceIdentifier" /> to create an <see cref="ApiManagementLoggerResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiManagementLoggerResource"/> object. </returns>
        public virtual ApiManagementLoggerResource GetApiManagementLoggerResource(ResourceIdentifier id)
        {
            ApiManagementLoggerResource.ValidateResourceId(id);
            return new ApiManagementLoggerResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiManagementNamedValueResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiManagementNamedValueResource.CreateResourceIdentifier" /> to create an <see cref="ApiManagementNamedValueResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiManagementNamedValueResource"/> object. </returns>
        public virtual ApiManagementNamedValueResource GetApiManagementNamedValueResource(ResourceIdentifier id)
        {
            ApiManagementNamedValueResource.ValidateResourceId(id);
            return new ApiManagementNamedValueResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ServiceWorkspaceNamedValueResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ServiceWorkspaceNamedValueResource.CreateResourceIdentifier" /> to create a <see cref="ServiceWorkspaceNamedValueResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ServiceWorkspaceNamedValueResource"/> object. </returns>
        public virtual ServiceWorkspaceNamedValueResource GetServiceWorkspaceNamedValueResource(ResourceIdentifier id)
        {
            ServiceWorkspaceNamedValueResource.ValidateResourceId(id);
            return new ServiceWorkspaceNamedValueResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiManagementNotificationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiManagementNotificationResource.CreateResourceIdentifier" /> to create an <see cref="ApiManagementNotificationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiManagementNotificationResource"/> object. </returns>
        public virtual ApiManagementNotificationResource GetApiManagementNotificationResource(ResourceIdentifier id)
        {
            ApiManagementNotificationResource.ValidateResourceId(id);
            return new ApiManagementNotificationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ServiceWorkspaceNotificationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ServiceWorkspaceNotificationResource.CreateResourceIdentifier" /> to create a <see cref="ServiceWorkspaceNotificationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ServiceWorkspaceNotificationResource"/> object. </returns>
        public virtual ServiceWorkspaceNotificationResource GetServiceWorkspaceNotificationResource(ResourceIdentifier id)
        {
            ServiceWorkspaceNotificationResource.ValidateResourceId(id);
            return new ServiceWorkspaceNotificationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiManagementOpenIdConnectProviderResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiManagementOpenIdConnectProviderResource.CreateResourceIdentifier" /> to create an <see cref="ApiManagementOpenIdConnectProviderResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiManagementOpenIdConnectProviderResource"/> object. </returns>
        public virtual ApiManagementOpenIdConnectProviderResource GetApiManagementOpenIdConnectProviderResource(ResourceIdentifier id)
        {
            ApiManagementOpenIdConnectProviderResource.ValidateResourceId(id);
            return new ApiManagementOpenIdConnectProviderResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="PolicyFragmentContractResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PolicyFragmentContractResource.CreateResourceIdentifier" /> to create a <see cref="PolicyFragmentContractResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PolicyFragmentContractResource"/> object. </returns>
        public virtual PolicyFragmentContractResource GetPolicyFragmentContractResource(ResourceIdentifier id)
        {
            PolicyFragmentContractResource.ValidateResourceId(id);
            return new PolicyFragmentContractResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ServiceWorkspacePolicyFragmentResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ServiceWorkspacePolicyFragmentResource.CreateResourceIdentifier" /> to create a <see cref="ServiceWorkspacePolicyFragmentResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ServiceWorkspacePolicyFragmentResource"/> object. </returns>
        public virtual ServiceWorkspacePolicyFragmentResource GetServiceWorkspacePolicyFragmentResource(ResourceIdentifier id)
        {
            ServiceWorkspacePolicyFragmentResource.ValidateResourceId(id);
            return new ServiceWorkspacePolicyFragmentResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="PortalConfigContractResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PortalConfigContractResource.CreateResourceIdentifier" /> to create a <see cref="PortalConfigContractResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PortalConfigContractResource"/> object. </returns>
        public virtual PortalConfigContractResource GetPortalConfigContractResource(ResourceIdentifier id)
        {
            PortalConfigContractResource.ValidateResourceId(id);
            return new PortalConfigContractResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiManagementPortalRevisionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiManagementPortalRevisionResource.CreateResourceIdentifier" /> to create an <see cref="ApiManagementPortalRevisionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiManagementPortalRevisionResource"/> object. </returns>
        public virtual ApiManagementPortalRevisionResource GetApiManagementPortalRevisionResource(ResourceIdentifier id)
        {
            ApiManagementPortalRevisionResource.ValidateResourceId(id);
            return new ApiManagementPortalRevisionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiManagementPortalSignInSettingResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiManagementPortalSignInSettingResource.CreateResourceIdentifier" /> to create an <see cref="ApiManagementPortalSignInSettingResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiManagementPortalSignInSettingResource"/> object. </returns>
        public virtual ApiManagementPortalSignInSettingResource GetApiManagementPortalSignInSettingResource(ResourceIdentifier id)
        {
            ApiManagementPortalSignInSettingResource.ValidateResourceId(id);
            return new ApiManagementPortalSignInSettingResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiManagementPortalSignUpSettingResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiManagementPortalSignUpSettingResource.CreateResourceIdentifier" /> to create an <see cref="ApiManagementPortalSignUpSettingResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiManagementPortalSignUpSettingResource"/> object. </returns>
        public virtual ApiManagementPortalSignUpSettingResource GetApiManagementPortalSignUpSettingResource(ResourceIdentifier id)
        {
            ApiManagementPortalSignUpSettingResource.ValidateResourceId(id);
            return new ApiManagementPortalSignUpSettingResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiManagementPortalDelegationSettingResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiManagementPortalDelegationSettingResource.CreateResourceIdentifier" /> to create an <see cref="ApiManagementPortalDelegationSettingResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiManagementPortalDelegationSettingResource"/> object. </returns>
        public virtual ApiManagementPortalDelegationSettingResource GetApiManagementPortalDelegationSettingResource(ResourceIdentifier id)
        {
            ApiManagementPortalDelegationSettingResource.ValidateResourceId(id);
            return new ApiManagementPortalDelegationSettingResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiManagementPrivateEndpointConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiManagementPrivateEndpointConnectionResource.CreateResourceIdentifier" /> to create an <see cref="ApiManagementPrivateEndpointConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiManagementPrivateEndpointConnectionResource"/> object. </returns>
        public virtual ApiManagementPrivateEndpointConnectionResource GetApiManagementPrivateEndpointConnectionResource(ResourceIdentifier id)
        {
            ApiManagementPrivateEndpointConnectionResource.ValidateResourceId(id);
            return new ApiManagementPrivateEndpointConnectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiManagementPrivateLinkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiManagementPrivateLinkResource.CreateResourceIdentifier" /> to create an <see cref="ApiManagementPrivateLinkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiManagementPrivateLinkResource"/> object. </returns>
        public virtual ApiManagementPrivateLinkResource GetApiManagementPrivateLinkResource(ResourceIdentifier id)
        {
            ApiManagementPrivateLinkResource.ValidateResourceId(id);
            return new ApiManagementPrivateLinkResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiManagementProductResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiManagementProductResource.CreateResourceIdentifier" /> to create an <see cref="ApiManagementProductResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiManagementProductResource"/> object. </returns>
        public virtual ApiManagementProductResource GetApiManagementProductResource(ResourceIdentifier id)
        {
            ApiManagementProductResource.ValidateResourceId(id);
            return new ApiManagementProductResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ServiceWorkspaceProductResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ServiceWorkspaceProductResource.CreateResourceIdentifier" /> to create a <see cref="ServiceWorkspaceProductResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ServiceWorkspaceProductResource"/> object. </returns>
        public virtual ServiceWorkspaceProductResource GetServiceWorkspaceProductResource(ResourceIdentifier id)
        {
            ServiceWorkspaceProductResource.ValidateResourceId(id);
            return new ServiceWorkspaceProductResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ServiceProductApiLinkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ServiceProductApiLinkResource.CreateResourceIdentifier" /> to create a <see cref="ServiceProductApiLinkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ServiceProductApiLinkResource"/> object. </returns>
        public virtual ServiceProductApiLinkResource GetServiceProductApiLinkResource(ResourceIdentifier id)
        {
            ServiceProductApiLinkResource.ValidateResourceId(id);
            return new ServiceProductApiLinkResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ServiceWorkspaceProductApiLinkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ServiceWorkspaceProductApiLinkResource.CreateResourceIdentifier" /> to create a <see cref="ServiceWorkspaceProductApiLinkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ServiceWorkspaceProductApiLinkResource"/> object. </returns>
        public virtual ServiceWorkspaceProductApiLinkResource GetServiceWorkspaceProductApiLinkResource(ResourceIdentifier id)
        {
            ServiceWorkspaceProductApiLinkResource.ValidateResourceId(id);
            return new ServiceWorkspaceProductApiLinkResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ServiceProductGroupLinkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ServiceProductGroupLinkResource.CreateResourceIdentifier" /> to create a <see cref="ServiceProductGroupLinkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ServiceProductGroupLinkResource"/> object. </returns>
        public virtual ServiceProductGroupLinkResource GetServiceProductGroupLinkResource(ResourceIdentifier id)
        {
            ServiceProductGroupLinkResource.ValidateResourceId(id);
            return new ServiceProductGroupLinkResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ServiceWorkspaceProductGroupLinkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ServiceWorkspaceProductGroupLinkResource.CreateResourceIdentifier" /> to create a <see cref="ServiceWorkspaceProductGroupLinkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ServiceWorkspaceProductGroupLinkResource"/> object. </returns>
        public virtual ServiceWorkspaceProductGroupLinkResource GetServiceWorkspaceProductGroupLinkResource(ResourceIdentifier id)
        {
            ServiceWorkspaceProductGroupLinkResource.ValidateResourceId(id);
            return new ServiceWorkspaceProductGroupLinkResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiManagementGlobalSchemaResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiManagementGlobalSchemaResource.CreateResourceIdentifier" /> to create an <see cref="ApiManagementGlobalSchemaResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiManagementGlobalSchemaResource"/> object. </returns>
        public virtual ApiManagementGlobalSchemaResource GetApiManagementGlobalSchemaResource(ResourceIdentifier id)
        {
            ApiManagementGlobalSchemaResource.ValidateResourceId(id);
            return new ApiManagementGlobalSchemaResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ServiceWorkspaceSchemaResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ServiceWorkspaceSchemaResource.CreateResourceIdentifier" /> to create a <see cref="ServiceWorkspaceSchemaResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ServiceWorkspaceSchemaResource"/> object. </returns>
        public virtual ServiceWorkspaceSchemaResource GetServiceWorkspaceSchemaResource(ResourceIdentifier id)
        {
            ServiceWorkspaceSchemaResource.ValidateResourceId(id);
            return new ServiceWorkspaceSchemaResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiManagementTenantSettingResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiManagementTenantSettingResource.CreateResourceIdentifier" /> to create an <see cref="ApiManagementTenantSettingResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiManagementTenantSettingResource"/> object. </returns>
        public virtual ApiManagementTenantSettingResource GetApiManagementTenantSettingResource(ResourceIdentifier id)
        {
            ApiManagementTenantSettingResource.ValidateResourceId(id);
            return new ApiManagementTenantSettingResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiManagementSubscriptionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiManagementSubscriptionResource.CreateResourceIdentifier" /> to create an <see cref="ApiManagementSubscriptionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiManagementSubscriptionResource"/> object. </returns>
        public virtual ApiManagementSubscriptionResource GetApiManagementSubscriptionResource(ResourceIdentifier id)
        {
            ApiManagementSubscriptionResource.ValidateResourceId(id);
            return new ApiManagementSubscriptionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiManagementUserSubscriptionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiManagementUserSubscriptionResource.CreateResourceIdentifier" /> to create an <see cref="ApiManagementUserSubscriptionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiManagementUserSubscriptionResource"/> object. </returns>
        public virtual ApiManagementUserSubscriptionResource GetApiManagementUserSubscriptionResource(ResourceIdentifier id)
        {
            ApiManagementUserSubscriptionResource.ValidateResourceId(id);
            return new ApiManagementUserSubscriptionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ServiceWorkspaceSubscriptionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ServiceWorkspaceSubscriptionResource.CreateResourceIdentifier" /> to create a <see cref="ServiceWorkspaceSubscriptionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ServiceWorkspaceSubscriptionResource"/> object. </returns>
        public virtual ServiceWorkspaceSubscriptionResource GetServiceWorkspaceSubscriptionResource(ResourceIdentifier id)
        {
            ServiceWorkspaceSubscriptionResource.ValidateResourceId(id);
            return new ServiceWorkspaceSubscriptionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ServiceTagApiLinkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ServiceTagApiLinkResource.CreateResourceIdentifier" /> to create a <see cref="ServiceTagApiLinkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ServiceTagApiLinkResource"/> object. </returns>
        public virtual ServiceTagApiLinkResource GetServiceTagApiLinkResource(ResourceIdentifier id)
        {
            ServiceTagApiLinkResource.ValidateResourceId(id);
            return new ServiceTagApiLinkResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ServiceWorkspaceTagApiLinkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ServiceWorkspaceTagApiLinkResource.CreateResourceIdentifier" /> to create a <see cref="ServiceWorkspaceTagApiLinkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ServiceWorkspaceTagApiLinkResource"/> object. </returns>
        public virtual ServiceWorkspaceTagApiLinkResource GetServiceWorkspaceTagApiLinkResource(ResourceIdentifier id)
        {
            ServiceWorkspaceTagApiLinkResource.ValidateResourceId(id);
            return new ServiceWorkspaceTagApiLinkResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ServiceTagOperationLinkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ServiceTagOperationLinkResource.CreateResourceIdentifier" /> to create a <see cref="ServiceTagOperationLinkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ServiceTagOperationLinkResource"/> object. </returns>
        public virtual ServiceTagOperationLinkResource GetServiceTagOperationLinkResource(ResourceIdentifier id)
        {
            ServiceTagOperationLinkResource.ValidateResourceId(id);
            return new ServiceTagOperationLinkResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ServiceWorkspaceTagOperationLinkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ServiceWorkspaceTagOperationLinkResource.CreateResourceIdentifier" /> to create a <see cref="ServiceWorkspaceTagOperationLinkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ServiceWorkspaceTagOperationLinkResource"/> object. </returns>
        public virtual ServiceWorkspaceTagOperationLinkResource GetServiceWorkspaceTagOperationLinkResource(ResourceIdentifier id)
        {
            ServiceWorkspaceTagOperationLinkResource.ValidateResourceId(id);
            return new ServiceWorkspaceTagOperationLinkResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ServiceTagProductLinkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ServiceTagProductLinkResource.CreateResourceIdentifier" /> to create a <see cref="ServiceTagProductLinkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ServiceTagProductLinkResource"/> object. </returns>
        public virtual ServiceTagProductLinkResource GetServiceTagProductLinkResource(ResourceIdentifier id)
        {
            ServiceTagProductLinkResource.ValidateResourceId(id);
            return new ServiceTagProductLinkResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ServiceWorkspaceTagProductLinkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ServiceWorkspaceTagProductLinkResource.CreateResourceIdentifier" /> to create a <see cref="ServiceWorkspaceTagProductLinkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ServiceWorkspaceTagProductLinkResource"/> object. </returns>
        public virtual ServiceWorkspaceTagProductLinkResource GetServiceWorkspaceTagProductLinkResource(ResourceIdentifier id)
        {
            ServiceWorkspaceTagProductLinkResource.ValidateResourceId(id);
            return new ServiceWorkspaceTagProductLinkResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="TenantAccessInfoResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="TenantAccessInfoResource.CreateResourceIdentifier" /> to create a <see cref="TenantAccessInfoResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="TenantAccessInfoResource"/> object. </returns>
        public virtual TenantAccessInfoResource GetTenantAccessInfoResource(ResourceIdentifier id)
        {
            TenantAccessInfoResource.ValidateResourceId(id);
            return new TenantAccessInfoResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="ApiManagementUserResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ApiManagementUserResource.CreateResourceIdentifier" /> to create an <see cref="ApiManagementUserResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ApiManagementUserResource"/> object. </returns>
        public virtual ApiManagementUserResource GetApiManagementUserResource(ResourceIdentifier id)
        {
            ApiManagementUserResource.ValidateResourceId(id);
            return new ApiManagementUserResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="WorkspaceContractResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="WorkspaceContractResource.CreateResourceIdentifier" /> to create a <see cref="WorkspaceContractResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="WorkspaceContractResource"/> object. </returns>
        public virtual WorkspaceContractResource GetWorkspaceContractResource(ResourceIdentifier id)
        {
            WorkspaceContractResource.ValidateResourceId(id);
            return new WorkspaceContractResource(Client, id);
        }
    }
}
