// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.ApiManagement.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.ApiManagement
{
    public partial class DiagnosticContractData : IUtf8JsonSerializable, IJsonModel<DiagnosticContractData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<DiagnosticContractData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<DiagnosticContractData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DiagnosticContractData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DiagnosticContractData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(AlwaysLog))
            {
                writer.WritePropertyName("alwaysLog"u8);
                writer.WriteStringValue(AlwaysLog.Value.ToString());
            }
            if (Optional.IsDefined(LoggerId))
            {
                writer.WritePropertyName("loggerId"u8);
                writer.WriteStringValue(LoggerId);
            }
            if (Optional.IsDefined(Sampling))
            {
                writer.WritePropertyName("sampling"u8);
                writer.WriteObjectValue(Sampling, options);
            }
            if (Optional.IsDefined(Frontend))
            {
                writer.WritePropertyName("frontend"u8);
                writer.WriteObjectValue(Frontend, options);
            }
            if (Optional.IsDefined(Backend))
            {
                writer.WritePropertyName("backend"u8);
                writer.WriteObjectValue(Backend, options);
            }
            if (Optional.IsDefined(IsLogClientIPEnabled))
            {
                writer.WritePropertyName("logClientIp"u8);
                writer.WriteBooleanValue(IsLogClientIPEnabled.Value);
            }
            if (Optional.IsDefined(HttpCorrelationProtocol))
            {
                writer.WritePropertyName("httpCorrelationProtocol"u8);
                writer.WriteStringValue(HttpCorrelationProtocol.Value.ToString());
            }
            if (Optional.IsDefined(Verbosity))
            {
                writer.WritePropertyName("verbosity"u8);
                writer.WriteStringValue(Verbosity.Value.ToString());
            }
            if (Optional.IsDefined(OperationNameFormat))
            {
                writer.WritePropertyName("operationNameFormat"u8);
                writer.WriteStringValue(OperationNameFormat.Value.ToString());
            }
            if (Optional.IsDefined(Metrics))
            {
                writer.WritePropertyName("metrics"u8);
                writer.WriteBooleanValue(Metrics.Value);
            }
            writer.WriteEndObject();
        }

        DiagnosticContractData IJsonModel<DiagnosticContractData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DiagnosticContractData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DiagnosticContractData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeDiagnosticContractData(document.RootElement, options);
        }

        internal static DiagnosticContractData DeserializeDiagnosticContractData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            AlwaysLog? alwaysLog = default;
            string loggerId = default;
            SamplingSettings sampling = default;
            PipelineDiagnosticSettings frontend = default;
            PipelineDiagnosticSettings backend = default;
            bool? logClientIP = default;
            HttpCorrelationProtocol? httpCorrelationProtocol = default;
            TraceVerbosityLevel? verbosity = default;
            OperationNameFormat? operationNameFormat = default;
            bool? metrics = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("alwaysLog"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            alwaysLog = new AlwaysLog(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("loggerId"u8))
                        {
                            loggerId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("sampling"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            sampling = SamplingSettings.DeserializeSamplingSettings(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("frontend"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            frontend = PipelineDiagnosticSettings.DeserializePipelineDiagnosticSettings(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("backend"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            backend = PipelineDiagnosticSettings.DeserializePipelineDiagnosticSettings(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("logClientIp"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            logClientIP = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("httpCorrelationProtocol"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            httpCorrelationProtocol = new HttpCorrelationProtocol(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("verbosity"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            verbosity = new TraceVerbosityLevel(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("operationNameFormat"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            operationNameFormat = new OperationNameFormat(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("metrics"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            metrics = property0.Value.GetBoolean();
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new DiagnosticContractData(
                id,
                name,
                type,
                systemData,
                alwaysLog,
                loggerId,
                sampling,
                frontend,
                backend,
                logClientIP,
                httpCorrelationProtocol,
                verbosity,
                operationNameFormat,
                metrics,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Name), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  name: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Name))
                {
                    builder.Append("  name: ");
                    if (Name.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Name}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Name}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Id), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  id: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Id))
                {
                    builder.Append("  id: ");
                    builder.AppendLine($"'{Id.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SystemData), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  systemData: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SystemData))
                {
                    builder.Append("  systemData: ");
                    builder.AppendLine($"'{SystemData.ToString()}'");
                }
            }

            builder.Append("  properties:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AlwaysLog), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    alwaysLog: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AlwaysLog))
                {
                    builder.Append("    alwaysLog: ");
                    builder.AppendLine($"'{AlwaysLog.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LoggerId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    loggerId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LoggerId))
                {
                    builder.Append("    loggerId: ");
                    if (LoggerId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{LoggerId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{LoggerId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Sampling), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    sampling: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Sampling))
                {
                    builder.Append("    sampling: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Sampling, options, 4, false, "    sampling: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Frontend), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    frontend: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Frontend))
                {
                    builder.Append("    frontend: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Frontend, options, 4, false, "    frontend: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Backend), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    backend: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Backend))
                {
                    builder.Append("    backend: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Backend, options, 4, false, "    backend: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsLogClientIPEnabled), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    logClientIp: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsLogClientIPEnabled))
                {
                    builder.Append("    logClientIp: ");
                    var boolValue = IsLogClientIPEnabled.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(HttpCorrelationProtocol), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    httpCorrelationProtocol: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(HttpCorrelationProtocol))
                {
                    builder.Append("    httpCorrelationProtocol: ");
                    builder.AppendLine($"'{HttpCorrelationProtocol.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Verbosity), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    verbosity: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Verbosity))
                {
                    builder.Append("    verbosity: ");
                    builder.AppendLine($"'{Verbosity.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(OperationNameFormat), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    operationNameFormat: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(OperationNameFormat))
                {
                    builder.Append("    operationNameFormat: ");
                    builder.AppendLine($"'{OperationNameFormat.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Metrics), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    metrics: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Metrics))
                {
                    builder.Append("    metrics: ");
                    var boolValue = Metrics.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            builder.AppendLine("  }");
            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<DiagnosticContractData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DiagnosticContractData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(DiagnosticContractData)} does not support writing '{options.Format}' format.");
            }
        }

        DiagnosticContractData IPersistableModel<DiagnosticContractData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DiagnosticContractData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeDiagnosticContractData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(DiagnosticContractData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<DiagnosticContractData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
