// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.ApiManagement.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.ApiManagement
{
    /// <summary>
    /// A class representing the AuthorizationProviderContract data model.
    /// Authorization Provider contract.
    /// </summary>
    public partial class AuthorizationProviderContractData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AuthorizationProviderContractData"/>. </summary>
        public AuthorizationProviderContractData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AuthorizationProviderContractData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="displayName"> Authorization Provider name. Must be 1 to 300 characters long. </param>
        /// <param name="identityProvider"> Identity provider name. Must be 1 to 300 characters long. </param>
        /// <param name="oauth2"> OAuth2 settings. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AuthorizationProviderContractData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string displayName, string identityProvider, AuthorizationProviderOAuth2Settings oauth2, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            DisplayName = displayName;
            IdentityProvider = identityProvider;
            Oauth2 = oauth2;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Authorization Provider name. Must be 1 to 300 characters long. </summary>
        [WirePath("properties.displayName")]
        public string DisplayName { get; set; }
        /// <summary> Identity provider name. Must be 1 to 300 characters long. </summary>
        [WirePath("properties.identityProvider")]
        public string IdentityProvider { get; set; }
        /// <summary> OAuth2 settings. </summary>
        [WirePath("properties.oauth2")]
        public AuthorizationProviderOAuth2Settings Oauth2 { get; set; }
    }
}
