// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.ApiManagement.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.ApiManagement
{
    /// <summary>
    /// A class representing the AuthorizationContract data model.
    /// Authorization contract.
    /// </summary>
    public partial class AuthorizationContractData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AuthorizationContractData"/>. </summary>
        public AuthorizationContractData()
        {
            Parameters = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="AuthorizationContractData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="authorizationType"> Authorization type options. </param>
        /// <param name="oAuth2GrantType"> OAuth2 grant type options. </param>
        /// <param name="parameters"> Authorization parameters. </param>
        /// <param name="error"> Authorization error details. </param>
        /// <param name="status"> Status of the Authorization. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AuthorizationContractData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, ApiManagementAuthorizationType? authorizationType, OAuth2GrantType? oAuth2GrantType, IDictionary<string, string> parameters, ApiManagementAuthorizationError error, string status, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            AuthorizationType = authorizationType;
            OAuth2GrantType = oAuth2GrantType;
            Parameters = parameters;
            Error = error;
            Status = status;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Authorization type options. </summary>
        [WirePath("properties.authorizationType")]
        public ApiManagementAuthorizationType? AuthorizationType { get; set; }
        /// <summary> OAuth2 grant type options. </summary>
        [WirePath("properties.oauth2grantType")]
        public OAuth2GrantType? OAuth2GrantType { get; set; }
        /// <summary> Authorization parameters. </summary>
        [WirePath("properties.parameters")]
        public IDictionary<string, string> Parameters { get; }
        /// <summary> Authorization error details. </summary>
        [WirePath("properties.error")]
        public ApiManagementAuthorizationError Error { get; set; }
        /// <summary> Status of the Authorization. </summary>
        [WirePath("properties.status")]
        public string Status { get; set; }
    }
}
