// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.ApiManagement
{
    /// <summary>
    /// A class representing a collection of <see cref="AuthorizationContractResource"/> and their operations.
    /// Each <see cref="AuthorizationContractResource"/> in the collection will belong to the same instance of <see cref="AuthorizationProviderContractResource"/>.
    /// To get an <see cref="AuthorizationContractCollection"/> instance call the GetAuthorizationContracts method from an instance of <see cref="AuthorizationProviderContractResource"/>.
    /// </summary>
    public partial class AuthorizationContractCollection : ArmCollection, IEnumerable<AuthorizationContractResource>, IAsyncEnumerable<AuthorizationContractResource>
    {
        private readonly ClientDiagnostics _authorizationContractAuthorizationClientDiagnostics;
        private readonly AuthorizationRestOperations _authorizationContractAuthorizationRestClient;

        /// <summary> Initializes a new instance of the <see cref="AuthorizationContractCollection"/> class for mocking. </summary>
        protected AuthorizationContractCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="AuthorizationContractCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal AuthorizationContractCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _authorizationContractAuthorizationClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.ApiManagement", AuthorizationContractResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(AuthorizationContractResource.ResourceType, out string authorizationContractAuthorizationApiVersion);
            _authorizationContractAuthorizationRestClient = new AuthorizationRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, authorizationContractAuthorizationApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != AuthorizationProviderContractResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, AuthorizationProviderContractResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates or updates authorization.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders/{authorizationProviderId}/authorizations/{authorizationId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Authorization_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AuthorizationContractResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="authorizationId"> Identifier of the authorization. </param>
        /// <param name="data"> Create parameters. </param>
        /// <param name="ifMatch"> ETag of the Entity. Not required when creating an entity, but required when updating an entity. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="authorizationId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="authorizationId"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<AuthorizationContractResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string authorizationId, AuthorizationContractData data, ETag? ifMatch = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(authorizationId, nameof(authorizationId));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _authorizationContractAuthorizationClientDiagnostics.CreateScope("AuthorizationContractCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _authorizationContractAuthorizationRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, authorizationId, data, ifMatch, cancellationToken).ConfigureAwait(false);
                var uri = _authorizationContractAuthorizationRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, authorizationId, data, ifMatch);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new ApiManagementArmOperation<AuthorizationContractResource>(Response.FromValue(new AuthorizationContractResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates authorization.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders/{authorizationProviderId}/authorizations/{authorizationId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Authorization_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AuthorizationContractResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="authorizationId"> Identifier of the authorization. </param>
        /// <param name="data"> Create parameters. </param>
        /// <param name="ifMatch"> ETag of the Entity. Not required when creating an entity, but required when updating an entity. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="authorizationId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="authorizationId"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<AuthorizationContractResource> CreateOrUpdate(WaitUntil waitUntil, string authorizationId, AuthorizationContractData data, ETag? ifMatch = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(authorizationId, nameof(authorizationId));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _authorizationContractAuthorizationClientDiagnostics.CreateScope("AuthorizationContractCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _authorizationContractAuthorizationRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, authorizationId, data, ifMatch, cancellationToken);
                var uri = _authorizationContractAuthorizationRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, authorizationId, data, ifMatch);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new ApiManagementArmOperation<AuthorizationContractResource>(Response.FromValue(new AuthorizationContractResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the details of the authorization specified by its identifier.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders/{authorizationProviderId}/authorizations/{authorizationId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Authorization_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AuthorizationContractResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="authorizationId"> Identifier of the authorization. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="authorizationId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="authorizationId"/> is null. </exception>
        public virtual async Task<Response<AuthorizationContractResource>> GetAsync(string authorizationId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(authorizationId, nameof(authorizationId));

            using var scope = _authorizationContractAuthorizationClientDiagnostics.CreateScope("AuthorizationContractCollection.Get");
            scope.Start();
            try
            {
                var response = await _authorizationContractAuthorizationRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, authorizationId, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new AuthorizationContractResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the details of the authorization specified by its identifier.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders/{authorizationProviderId}/authorizations/{authorizationId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Authorization_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AuthorizationContractResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="authorizationId"> Identifier of the authorization. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="authorizationId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="authorizationId"/> is null. </exception>
        public virtual Response<AuthorizationContractResource> Get(string authorizationId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(authorizationId, nameof(authorizationId));

            using var scope = _authorizationContractAuthorizationClientDiagnostics.CreateScope("AuthorizationContractCollection.Get");
            scope.Start();
            try
            {
                var response = _authorizationContractAuthorizationRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, authorizationId, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new AuthorizationContractResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists a collection of authorization providers defined within a authorization provider.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders/{authorizationProviderId}/authorizations</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Authorization_ListByAuthorizationProvider</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AuthorizationContractResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="filter"> |     Field     |     Usage     |     Supported operators     |     Supported functions     |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |&lt;/br&gt;| displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |&lt;/br&gt;. </param>
        /// <param name="top"> Number of records to return. </param>
        /// <param name="skip"> Number of records to skip. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="AuthorizationContractResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<AuthorizationContractResource> GetAllAsync(string filter = null, int? top = null, int? skip = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _authorizationContractAuthorizationRestClient.CreateListByAuthorizationProviderRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, filter, top, skip);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _authorizationContractAuthorizationRestClient.CreateListByAuthorizationProviderNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, filter, top, skip);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new AuthorizationContractResource(Client, AuthorizationContractData.DeserializeAuthorizationContractData(e)), _authorizationContractAuthorizationClientDiagnostics, Pipeline, "AuthorizationContractCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists a collection of authorization providers defined within a authorization provider.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders/{authorizationProviderId}/authorizations</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Authorization_ListByAuthorizationProvider</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AuthorizationContractResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="filter"> |     Field     |     Usage     |     Supported operators     |     Supported functions     |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |&lt;/br&gt;| displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |&lt;/br&gt;. </param>
        /// <param name="top"> Number of records to return. </param>
        /// <param name="skip"> Number of records to skip. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="AuthorizationContractResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<AuthorizationContractResource> GetAll(string filter = null, int? top = null, int? skip = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _authorizationContractAuthorizationRestClient.CreateListByAuthorizationProviderRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, filter, top, skip);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _authorizationContractAuthorizationRestClient.CreateListByAuthorizationProviderNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, filter, top, skip);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new AuthorizationContractResource(Client, AuthorizationContractData.DeserializeAuthorizationContractData(e)), _authorizationContractAuthorizationClientDiagnostics, Pipeline, "AuthorizationContractCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders/{authorizationProviderId}/authorizations/{authorizationId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Authorization_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AuthorizationContractResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="authorizationId"> Identifier of the authorization. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="authorizationId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="authorizationId"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string authorizationId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(authorizationId, nameof(authorizationId));

            using var scope = _authorizationContractAuthorizationClientDiagnostics.CreateScope("AuthorizationContractCollection.Exists");
            scope.Start();
            try
            {
                var response = await _authorizationContractAuthorizationRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, authorizationId, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders/{authorizationProviderId}/authorizations/{authorizationId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Authorization_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AuthorizationContractResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="authorizationId"> Identifier of the authorization. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="authorizationId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="authorizationId"/> is null. </exception>
        public virtual Response<bool> Exists(string authorizationId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(authorizationId, nameof(authorizationId));

            using var scope = _authorizationContractAuthorizationClientDiagnostics.CreateScope("AuthorizationContractCollection.Exists");
            scope.Start();
            try
            {
                var response = _authorizationContractAuthorizationRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, authorizationId, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders/{authorizationProviderId}/authorizations/{authorizationId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Authorization_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AuthorizationContractResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="authorizationId"> Identifier of the authorization. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="authorizationId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="authorizationId"/> is null. </exception>
        public virtual async Task<NullableResponse<AuthorizationContractResource>> GetIfExistsAsync(string authorizationId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(authorizationId, nameof(authorizationId));

            using var scope = _authorizationContractAuthorizationClientDiagnostics.CreateScope("AuthorizationContractCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _authorizationContractAuthorizationRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, authorizationId, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<AuthorizationContractResource>(response.GetRawResponse());
                return Response.FromValue(new AuthorizationContractResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders/{authorizationProviderId}/authorizations/{authorizationId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Authorization_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AuthorizationContractResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="authorizationId"> Identifier of the authorization. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="authorizationId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="authorizationId"/> is null. </exception>
        public virtual NullableResponse<AuthorizationContractResource> GetIfExists(string authorizationId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(authorizationId, nameof(authorizationId));

            using var scope = _authorizationContractAuthorizationClientDiagnostics.CreateScope("AuthorizationContractCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _authorizationContractAuthorizationRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, authorizationId, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<AuthorizationContractResource>(response.GetRawResponse());
                return Response.FromValue(new AuthorizationContractResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<AuthorizationContractResource> IEnumerable<AuthorizationContractResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<AuthorizationContractResource> IAsyncEnumerable<AuthorizationContractResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
