// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.ApiManagement
{
    /// <summary>
    /// A class representing a collection of <see cref="AuthorizationAccessPolicyContractResource"/> and their operations.
    /// Each <see cref="AuthorizationAccessPolicyContractResource"/> in the collection will belong to the same instance of <see cref="AuthorizationContractResource"/>.
    /// To get an <see cref="AuthorizationAccessPolicyContractCollection"/> instance call the GetAuthorizationAccessPolicyContracts method from an instance of <see cref="AuthorizationContractResource"/>.
    /// </summary>
    public partial class AuthorizationAccessPolicyContractCollection : ArmCollection, IEnumerable<AuthorizationAccessPolicyContractResource>, IAsyncEnumerable<AuthorizationAccessPolicyContractResource>
    {
        private readonly ClientDiagnostics _authorizationAccessPolicyContractAuthorizationAccessPolicyClientDiagnostics;
        private readonly AuthorizationAccessPolicyRestOperations _authorizationAccessPolicyContractAuthorizationAccessPolicyRestClient;

        /// <summary> Initializes a new instance of the <see cref="AuthorizationAccessPolicyContractCollection"/> class for mocking. </summary>
        protected AuthorizationAccessPolicyContractCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="AuthorizationAccessPolicyContractCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal AuthorizationAccessPolicyContractCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _authorizationAccessPolicyContractAuthorizationAccessPolicyClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.ApiManagement", AuthorizationAccessPolicyContractResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(AuthorizationAccessPolicyContractResource.ResourceType, out string authorizationAccessPolicyContractAuthorizationAccessPolicyApiVersion);
            _authorizationAccessPolicyContractAuthorizationAccessPolicyRestClient = new AuthorizationAccessPolicyRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, authorizationAccessPolicyContractAuthorizationAccessPolicyApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != AuthorizationContractResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, AuthorizationContractResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates or updates Authorization Access Policy.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders/{authorizationProviderId}/authorizations/{authorizationId}/accessPolicies/{authorizationAccessPolicyId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AuthorizationAccessPolicy_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AuthorizationAccessPolicyContractResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="authorizationAccessPolicyId"> Identifier of the authorization access policy. </param>
        /// <param name="data"> Create parameters. </param>
        /// <param name="ifMatch"> ETag of the Entity. Not required when creating an entity, but required when updating an entity. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="authorizationAccessPolicyId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="authorizationAccessPolicyId"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<AuthorizationAccessPolicyContractResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string authorizationAccessPolicyId, AuthorizationAccessPolicyContractData data, ETag? ifMatch = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(authorizationAccessPolicyId, nameof(authorizationAccessPolicyId));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _authorizationAccessPolicyContractAuthorizationAccessPolicyClientDiagnostics.CreateScope("AuthorizationAccessPolicyContractCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _authorizationAccessPolicyContractAuthorizationAccessPolicyRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, authorizationAccessPolicyId, data, ifMatch, cancellationToken).ConfigureAwait(false);
                var uri = _authorizationAccessPolicyContractAuthorizationAccessPolicyRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, authorizationAccessPolicyId, data, ifMatch);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new ApiManagementArmOperation<AuthorizationAccessPolicyContractResource>(Response.FromValue(new AuthorizationAccessPolicyContractResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates Authorization Access Policy.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders/{authorizationProviderId}/authorizations/{authorizationId}/accessPolicies/{authorizationAccessPolicyId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AuthorizationAccessPolicy_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AuthorizationAccessPolicyContractResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="authorizationAccessPolicyId"> Identifier of the authorization access policy. </param>
        /// <param name="data"> Create parameters. </param>
        /// <param name="ifMatch"> ETag of the Entity. Not required when creating an entity, but required when updating an entity. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="authorizationAccessPolicyId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="authorizationAccessPolicyId"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<AuthorizationAccessPolicyContractResource> CreateOrUpdate(WaitUntil waitUntil, string authorizationAccessPolicyId, AuthorizationAccessPolicyContractData data, ETag? ifMatch = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(authorizationAccessPolicyId, nameof(authorizationAccessPolicyId));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _authorizationAccessPolicyContractAuthorizationAccessPolicyClientDiagnostics.CreateScope("AuthorizationAccessPolicyContractCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _authorizationAccessPolicyContractAuthorizationAccessPolicyRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, authorizationAccessPolicyId, data, ifMatch, cancellationToken);
                var uri = _authorizationAccessPolicyContractAuthorizationAccessPolicyRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, authorizationAccessPolicyId, data, ifMatch);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new ApiManagementArmOperation<AuthorizationAccessPolicyContractResource>(Response.FromValue(new AuthorizationAccessPolicyContractResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the details of the authorization access policy specified by its identifier.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders/{authorizationProviderId}/authorizations/{authorizationId}/accessPolicies/{authorizationAccessPolicyId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AuthorizationAccessPolicy_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AuthorizationAccessPolicyContractResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="authorizationAccessPolicyId"> Identifier of the authorization access policy. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="authorizationAccessPolicyId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="authorizationAccessPolicyId"/> is null. </exception>
        public virtual async Task<Response<AuthorizationAccessPolicyContractResource>> GetAsync(string authorizationAccessPolicyId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(authorizationAccessPolicyId, nameof(authorizationAccessPolicyId));

            using var scope = _authorizationAccessPolicyContractAuthorizationAccessPolicyClientDiagnostics.CreateScope("AuthorizationAccessPolicyContractCollection.Get");
            scope.Start();
            try
            {
                var response = await _authorizationAccessPolicyContractAuthorizationAccessPolicyRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, authorizationAccessPolicyId, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new AuthorizationAccessPolicyContractResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the details of the authorization access policy specified by its identifier.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders/{authorizationProviderId}/authorizations/{authorizationId}/accessPolicies/{authorizationAccessPolicyId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AuthorizationAccessPolicy_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AuthorizationAccessPolicyContractResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="authorizationAccessPolicyId"> Identifier of the authorization access policy. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="authorizationAccessPolicyId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="authorizationAccessPolicyId"/> is null. </exception>
        public virtual Response<AuthorizationAccessPolicyContractResource> Get(string authorizationAccessPolicyId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(authorizationAccessPolicyId, nameof(authorizationAccessPolicyId));

            using var scope = _authorizationAccessPolicyContractAuthorizationAccessPolicyClientDiagnostics.CreateScope("AuthorizationAccessPolicyContractCollection.Get");
            scope.Start();
            try
            {
                var response = _authorizationAccessPolicyContractAuthorizationAccessPolicyRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, authorizationAccessPolicyId, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new AuthorizationAccessPolicyContractResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists a collection of authorization access policy defined within a authorization.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders/{authorizationProviderId}/authorizations/{authorizationId}/accessPolicies</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AuthorizationAccessPolicy_ListByAuthorization</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AuthorizationAccessPolicyContractResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="filter"> |     Field     |     Usage     |     Supported operators     |     Supported functions     |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |&lt;/br&gt;| displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |&lt;/br&gt;. </param>
        /// <param name="top"> Number of records to return. </param>
        /// <param name="skip"> Number of records to skip. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="AuthorizationAccessPolicyContractResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<AuthorizationAccessPolicyContractResource> GetAllAsync(string filter = null, int? top = null, int? skip = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _authorizationAccessPolicyContractAuthorizationAccessPolicyRestClient.CreateListByAuthorizationRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, filter, top, skip);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _authorizationAccessPolicyContractAuthorizationAccessPolicyRestClient.CreateListByAuthorizationNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, filter, top, skip);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new AuthorizationAccessPolicyContractResource(Client, AuthorizationAccessPolicyContractData.DeserializeAuthorizationAccessPolicyContractData(e)), _authorizationAccessPolicyContractAuthorizationAccessPolicyClientDiagnostics, Pipeline, "AuthorizationAccessPolicyContractCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists a collection of authorization access policy defined within a authorization.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders/{authorizationProviderId}/authorizations/{authorizationId}/accessPolicies</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AuthorizationAccessPolicy_ListByAuthorization</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AuthorizationAccessPolicyContractResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="filter"> |     Field     |     Usage     |     Supported operators     |     Supported functions     |&lt;/br&gt;|-------------|-------------|-------------|-------------|&lt;/br&gt;| name | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |&lt;/br&gt;| displayName | filter | ge, le, eq, ne, gt, lt | substringof, contains, startswith, endswith |&lt;/br&gt;. </param>
        /// <param name="top"> Number of records to return. </param>
        /// <param name="skip"> Number of records to skip. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="AuthorizationAccessPolicyContractResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<AuthorizationAccessPolicyContractResource> GetAll(string filter = null, int? top = null, int? skip = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _authorizationAccessPolicyContractAuthorizationAccessPolicyRestClient.CreateListByAuthorizationRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, filter, top, skip);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _authorizationAccessPolicyContractAuthorizationAccessPolicyRestClient.CreateListByAuthorizationNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, filter, top, skip);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new AuthorizationAccessPolicyContractResource(Client, AuthorizationAccessPolicyContractData.DeserializeAuthorizationAccessPolicyContractData(e)), _authorizationAccessPolicyContractAuthorizationAccessPolicyClientDiagnostics, Pipeline, "AuthorizationAccessPolicyContractCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders/{authorizationProviderId}/authorizations/{authorizationId}/accessPolicies/{authorizationAccessPolicyId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AuthorizationAccessPolicy_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AuthorizationAccessPolicyContractResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="authorizationAccessPolicyId"> Identifier of the authorization access policy. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="authorizationAccessPolicyId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="authorizationAccessPolicyId"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string authorizationAccessPolicyId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(authorizationAccessPolicyId, nameof(authorizationAccessPolicyId));

            using var scope = _authorizationAccessPolicyContractAuthorizationAccessPolicyClientDiagnostics.CreateScope("AuthorizationAccessPolicyContractCollection.Exists");
            scope.Start();
            try
            {
                var response = await _authorizationAccessPolicyContractAuthorizationAccessPolicyRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, authorizationAccessPolicyId, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders/{authorizationProviderId}/authorizations/{authorizationId}/accessPolicies/{authorizationAccessPolicyId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AuthorizationAccessPolicy_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AuthorizationAccessPolicyContractResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="authorizationAccessPolicyId"> Identifier of the authorization access policy. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="authorizationAccessPolicyId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="authorizationAccessPolicyId"/> is null. </exception>
        public virtual Response<bool> Exists(string authorizationAccessPolicyId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(authorizationAccessPolicyId, nameof(authorizationAccessPolicyId));

            using var scope = _authorizationAccessPolicyContractAuthorizationAccessPolicyClientDiagnostics.CreateScope("AuthorizationAccessPolicyContractCollection.Exists");
            scope.Start();
            try
            {
                var response = _authorizationAccessPolicyContractAuthorizationAccessPolicyRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, authorizationAccessPolicyId, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders/{authorizationProviderId}/authorizations/{authorizationId}/accessPolicies/{authorizationAccessPolicyId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AuthorizationAccessPolicy_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AuthorizationAccessPolicyContractResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="authorizationAccessPolicyId"> Identifier of the authorization access policy. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="authorizationAccessPolicyId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="authorizationAccessPolicyId"/> is null. </exception>
        public virtual async Task<NullableResponse<AuthorizationAccessPolicyContractResource>> GetIfExistsAsync(string authorizationAccessPolicyId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(authorizationAccessPolicyId, nameof(authorizationAccessPolicyId));

            using var scope = _authorizationAccessPolicyContractAuthorizationAccessPolicyClientDiagnostics.CreateScope("AuthorizationAccessPolicyContractCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _authorizationAccessPolicyContractAuthorizationAccessPolicyRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, authorizationAccessPolicyId, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<AuthorizationAccessPolicyContractResource>(response.GetRawResponse());
                return Response.FromValue(new AuthorizationAccessPolicyContractResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/authorizationProviders/{authorizationProviderId}/authorizations/{authorizationId}/accessPolicies/{authorizationAccessPolicyId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AuthorizationAccessPolicy_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AuthorizationAccessPolicyContractResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="authorizationAccessPolicyId"> Identifier of the authorization access policy. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="authorizationAccessPolicyId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="authorizationAccessPolicyId"/> is null. </exception>
        public virtual NullableResponse<AuthorizationAccessPolicyContractResource> GetIfExists(string authorizationAccessPolicyId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(authorizationAccessPolicyId, nameof(authorizationAccessPolicyId));

            using var scope = _authorizationAccessPolicyContractAuthorizationAccessPolicyClientDiagnostics.CreateScope("AuthorizationAccessPolicyContractCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _authorizationAccessPolicyContractAuthorizationAccessPolicyRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, authorizationAccessPolicyId, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<AuthorizationAccessPolicyContractResource>(response.GetRawResponse());
                return Response.FromValue(new AuthorizationAccessPolicyContractResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<AuthorizationAccessPolicyContractResource> IEnumerable<AuthorizationAccessPolicyContractResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<AuthorizationAccessPolicyContractResource> IAsyncEnumerable<AuthorizationAccessPolicyContractResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
