// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.ApiManagement.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.ApiManagement
{
    /// <summary>
    /// A class representing the ApiVersionSet data model.
    /// API Version Set Contract details.
    /// </summary>
    public partial class ApiVersionSetData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ApiVersionSetData"/>. </summary>
        public ApiVersionSetData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ApiVersionSetData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> Description of API Version Set. </param>
        /// <param name="versionQueryName"> Name of query parameter that indicates the API Version if versioningScheme is set to `query`. </param>
        /// <param name="versionHeaderName"> Name of HTTP header parameter that indicates the API Version if versioningScheme is set to `header`. </param>
        /// <param name="displayName"> Name of API Version Set. </param>
        /// <param name="versioningScheme"> An value that determines where the API Version identifier will be located in a HTTP request. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ApiVersionSetData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string description, string versionQueryName, string versionHeaderName, string displayName, VersioningScheme? versioningScheme, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Description = description;
            VersionQueryName = versionQueryName;
            VersionHeaderName = versionHeaderName;
            DisplayName = displayName;
            VersioningScheme = versioningScheme;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Description of API Version Set. </summary>
        [WirePath("properties.description")]
        public string Description { get; set; }
        /// <summary> Name of query parameter that indicates the API Version if versioningScheme is set to `query`. </summary>
        [WirePath("properties.versionQueryName")]
        public string VersionQueryName { get; set; }
        /// <summary> Name of HTTP header parameter that indicates the API Version if versioningScheme is set to `header`. </summary>
        [WirePath("properties.versionHeaderName")]
        public string VersionHeaderName { get; set; }
        /// <summary> Name of API Version Set. </summary>
        [WirePath("properties.displayName")]
        public string DisplayName { get; set; }
        /// <summary> An value that determines where the API Version identifier will be located in a HTTP request. </summary>
        [WirePath("properties.versioningScheme")]
        public VersioningScheme? VersioningScheme { get; set; }
    }
}
