// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.ApiManagement
{
    /// <summary>
    /// A class representing the ApiRelease data model.
    /// ApiRelease details.
    /// </summary>
    public partial class ApiReleaseData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ApiReleaseData"/>. </summary>
        public ApiReleaseData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ApiReleaseData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="apiId"> Identifier of the API the release belongs to. </param>
        /// <param name="createdOn"> The time the API was released. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard. </param>
        /// <param name="updatedOn"> The time the API release was updated. </param>
        /// <param name="notes"> Release Notes. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ApiReleaseData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, ResourceIdentifier apiId, DateTimeOffset? createdOn, DateTimeOffset? updatedOn, string notes, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            ApiId = apiId;
            CreatedOn = createdOn;
            UpdatedOn = updatedOn;
            Notes = notes;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Identifier of the API the release belongs to. </summary>
        [WirePath("properties.apiId")]
        public ResourceIdentifier ApiId { get; set; }
        /// <summary> The time the API was released. The date conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard. </summary>
        [WirePath("properties.createdDateTime")]
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> The time the API release was updated. </summary>
        [WirePath("properties.updatedDateTime")]
        public DateTimeOffset? UpdatedOn { get; }
        /// <summary> Release Notes. </summary>
        [WirePath("properties.notes")]
        public string Notes { get; set; }
    }
}
