// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.ApiManagement.Models;

namespace Azure.ResourceManager.ApiManagement
{
    /// <summary>
    /// A class representing a collection of <see cref="ApiManagementTenantSettingResource"/> and their operations.
    /// Each <see cref="ApiManagementTenantSettingResource"/> in the collection will belong to the same instance of <see cref="ApiManagementServiceResource"/>.
    /// To get an <see cref="ApiManagementTenantSettingCollection"/> instance call the GetApiManagementTenantSettings method from an instance of <see cref="ApiManagementServiceResource"/>.
    /// </summary>
    public partial class ApiManagementTenantSettingCollection : ArmCollection, IEnumerable<ApiManagementTenantSettingResource>, IAsyncEnumerable<ApiManagementTenantSettingResource>
    {
        private readonly ClientDiagnostics _apiManagementTenantSettingTenantSettingsClientDiagnostics;
        private readonly TenantSettingsRestOperations _apiManagementTenantSettingTenantSettingsRestClient;

        /// <summary> Initializes a new instance of the <see cref="ApiManagementTenantSettingCollection"/> class for mocking. </summary>
        protected ApiManagementTenantSettingCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="ApiManagementTenantSettingCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal ApiManagementTenantSettingCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _apiManagementTenantSettingTenantSettingsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.ApiManagement", ApiManagementTenantSettingResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ApiManagementTenantSettingResource.ResourceType, out string apiManagementTenantSettingTenantSettingsApiVersion);
            _apiManagementTenantSettingTenantSettingsRestClient = new TenantSettingsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, apiManagementTenantSettingTenantSettingsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ApiManagementServiceResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ApiManagementServiceResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Get tenant settings.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/settings/{settingsType}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>TenantSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ApiManagementTenantSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="settingsType"> The identifier of the settings. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<ApiManagementTenantSettingResource>> GetAsync(SettingsType settingsType, CancellationToken cancellationToken = default)
        {
            using var scope = _apiManagementTenantSettingTenantSettingsClientDiagnostics.CreateScope("ApiManagementTenantSettingCollection.Get");
            scope.Start();
            try
            {
                var response = await _apiManagementTenantSettingTenantSettingsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, settingsType, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ApiManagementTenantSettingResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get tenant settings.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/settings/{settingsType}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>TenantSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ApiManagementTenantSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="settingsType"> The identifier of the settings. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<ApiManagementTenantSettingResource> Get(SettingsType settingsType, CancellationToken cancellationToken = default)
        {
            using var scope = _apiManagementTenantSettingTenantSettingsClientDiagnostics.CreateScope("ApiManagementTenantSettingCollection.Get");
            scope.Start();
            try
            {
                var response = _apiManagementTenantSettingTenantSettingsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, settingsType, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ApiManagementTenantSettingResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Public settings.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/settings</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>TenantSettings_ListByService</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ApiManagementTenantSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="filter"> Not used. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="ApiManagementTenantSettingResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<ApiManagementTenantSettingResource> GetAllAsync(string filter = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _apiManagementTenantSettingTenantSettingsRestClient.CreateListByServiceRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, filter);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _apiManagementTenantSettingTenantSettingsRestClient.CreateListByServiceNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name, filter);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new ApiManagementTenantSettingResource(Client, ApiManagementTenantSettingData.DeserializeApiManagementTenantSettingData(e)), _apiManagementTenantSettingTenantSettingsClientDiagnostics, Pipeline, "ApiManagementTenantSettingCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Public settings.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/settings</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>TenantSettings_ListByService</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ApiManagementTenantSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="filter"> Not used. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="ApiManagementTenantSettingResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<ApiManagementTenantSettingResource> GetAll(string filter = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _apiManagementTenantSettingTenantSettingsRestClient.CreateListByServiceRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, filter);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _apiManagementTenantSettingTenantSettingsRestClient.CreateListByServiceNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name, filter);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new ApiManagementTenantSettingResource(Client, ApiManagementTenantSettingData.DeserializeApiManagementTenantSettingData(e)), _apiManagementTenantSettingTenantSettingsClientDiagnostics, Pipeline, "ApiManagementTenantSettingCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/settings/{settingsType}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>TenantSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ApiManagementTenantSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="settingsType"> The identifier of the settings. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<bool>> ExistsAsync(SettingsType settingsType, CancellationToken cancellationToken = default)
        {
            using var scope = _apiManagementTenantSettingTenantSettingsClientDiagnostics.CreateScope("ApiManagementTenantSettingCollection.Exists");
            scope.Start();
            try
            {
                var response = await _apiManagementTenantSettingTenantSettingsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, settingsType, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/settings/{settingsType}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>TenantSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ApiManagementTenantSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="settingsType"> The identifier of the settings. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<bool> Exists(SettingsType settingsType, CancellationToken cancellationToken = default)
        {
            using var scope = _apiManagementTenantSettingTenantSettingsClientDiagnostics.CreateScope("ApiManagementTenantSettingCollection.Exists");
            scope.Start();
            try
            {
                var response = _apiManagementTenantSettingTenantSettingsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, settingsType, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/settings/{settingsType}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>TenantSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ApiManagementTenantSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="settingsType"> The identifier of the settings. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<NullableResponse<ApiManagementTenantSettingResource>> GetIfExistsAsync(SettingsType settingsType, CancellationToken cancellationToken = default)
        {
            using var scope = _apiManagementTenantSettingTenantSettingsClientDiagnostics.CreateScope("ApiManagementTenantSettingCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _apiManagementTenantSettingTenantSettingsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, settingsType, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<ApiManagementTenantSettingResource>(response.GetRawResponse());
                return Response.FromValue(new ApiManagementTenantSettingResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/settings/{settingsType}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>TenantSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-03-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ApiManagementTenantSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="settingsType"> The identifier of the settings. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual NullableResponse<ApiManagementTenantSettingResource> GetIfExists(SettingsType settingsType, CancellationToken cancellationToken = default)
        {
            using var scope = _apiManagementTenantSettingTenantSettingsClientDiagnostics.CreateScope("ApiManagementTenantSettingCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _apiManagementTenantSettingTenantSettingsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, settingsType, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<ApiManagementTenantSettingResource>(response.GetRawResponse());
                return Response.FromValue(new ApiManagementTenantSettingResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<ApiManagementTenantSettingResource> IEnumerable<ApiManagementTenantSettingResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<ApiManagementTenantSettingResource> IAsyncEnumerable<ApiManagementTenantSettingResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
