// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.ApiManagement.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.ApiManagement
{
    /// <summary>
    /// A class representing the ApiManagementPortalSignUpSetting data model.
    /// Sign-Up settings for a developer portal.
    /// </summary>
    public partial class ApiManagementPortalSignUpSettingData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ApiManagementPortalSignUpSettingData"/>. </summary>
        public ApiManagementPortalSignUpSettingData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ApiManagementPortalSignUpSettingData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="isSignUpDeveloperPortalEnabled"> Allow users to sign up on a developer portal. </param>
        /// <param name="termsOfService"> Terms of service contract properties. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ApiManagementPortalSignUpSettingData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, bool? isSignUpDeveloperPortalEnabled, TermsOfServiceProperties termsOfService, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            IsSignUpDeveloperPortalEnabled = isSignUpDeveloperPortalEnabled;
            TermsOfService = termsOfService;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Allow users to sign up on a developer portal. </summary>
        [WirePath("properties.enabled")]
        public bool? IsSignUpDeveloperPortalEnabled { get; set; }
        /// <summary> Terms of service contract properties. </summary>
        [WirePath("properties.termsOfService")]
        public TermsOfServiceProperties TermsOfService { get; set; }
    }
}
