// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.ApiManagement.Samples
{
    public partial class Sample_ServiceWorkspaceTagProductLinkResource
    {
        // ApiManagementGetWorkspaceTagProductLink
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ApiManagementGetWorkspaceTagProductLink()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementGetWorkspaceTagProductLink.json
            // this example is just showing the usage of "WorkspaceTagProductLink_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceWorkspaceTagProductLinkResource created on azure
            // for more information of creating ServiceWorkspaceTagProductLinkResource, please refer to the document of ServiceWorkspaceTagProductLinkResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string workspaceId = "wks1";
            string tagId = "tag1";
            string productLinkId = "link1";
            ResourceIdentifier serviceWorkspaceTagProductLinkResourceId = ServiceWorkspaceTagProductLinkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, workspaceId, tagId, productLinkId);
            ServiceWorkspaceTagProductLinkResource serviceWorkspaceTagProductLink = client.GetServiceWorkspaceTagProductLinkResource(serviceWorkspaceTagProductLinkResourceId);

            // invoke the operation
            ServiceWorkspaceTagProductLinkResource result = await serviceWorkspaceTagProductLink.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            TagProductLinkContractData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ApiManagementCreateWorkspaceTagProductLink
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_ApiManagementCreateWorkspaceTagProductLink()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementCreateWorkspaceTagProductLink.json
            // this example is just showing the usage of "WorkspaceTagProductLink_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceWorkspaceTagProductLinkResource created on azure
            // for more information of creating ServiceWorkspaceTagProductLinkResource, please refer to the document of ServiceWorkspaceTagProductLinkResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string workspaceId = "wks1";
            string tagId = "tag1";
            string productLinkId = "link1";
            ResourceIdentifier serviceWorkspaceTagProductLinkResourceId = ServiceWorkspaceTagProductLinkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, workspaceId, tagId, productLinkId);
            ServiceWorkspaceTagProductLinkResource serviceWorkspaceTagProductLink = client.GetServiceWorkspaceTagProductLinkResource(serviceWorkspaceTagProductLinkResourceId);

            // invoke the operation
            TagProductLinkContractData data = new TagProductLinkContractData()
            {
                ProductId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/workspaces/wks1/products/product1",
            };
            ArmOperation<ServiceWorkspaceTagProductLinkResource> lro = await serviceWorkspaceTagProductLink.UpdateAsync(WaitUntil.Completed, data);
            ServiceWorkspaceTagProductLinkResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            TagProductLinkContractData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ApiManagementDeleteWorkspaceTagProductLink
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_ApiManagementDeleteWorkspaceTagProductLink()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementDeleteWorkspaceTagProductLink.json
            // this example is just showing the usage of "WorkspaceTagProductLink_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceWorkspaceTagProductLinkResource created on azure
            // for more information of creating ServiceWorkspaceTagProductLinkResource, please refer to the document of ServiceWorkspaceTagProductLinkResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string workspaceId = "wks1";
            string tagId = "tag1";
            string productLinkId = "link1";
            ResourceIdentifier serviceWorkspaceTagProductLinkResourceId = ServiceWorkspaceTagProductLinkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, workspaceId, tagId, productLinkId);
            ServiceWorkspaceTagProductLinkResource serviceWorkspaceTagProductLink = client.GetServiceWorkspaceTagProductLinkResource(serviceWorkspaceTagProductLinkResourceId);

            // invoke the operation
            await serviceWorkspaceTagProductLink.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
