// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.ApiManagement.Samples
{
    public partial class Sample_ServiceWorkspaceProductGroupLinkResource
    {
        // ApiManagementGetWorkspaceProductGroupLink
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ApiManagementGetWorkspaceProductGroupLink()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementGetWorkspaceProductGroupLink.json
            // this example is just showing the usage of "WorkspaceProductGroupLink_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceWorkspaceProductGroupLinkResource created on azure
            // for more information of creating ServiceWorkspaceProductGroupLinkResource, please refer to the document of ServiceWorkspaceProductGroupLinkResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string workspaceId = "wks1";
            string productId = "testproduct";
            string groupLinkId = "link1";
            ResourceIdentifier serviceWorkspaceProductGroupLinkResourceId = ServiceWorkspaceProductGroupLinkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, workspaceId, productId, groupLinkId);
            ServiceWorkspaceProductGroupLinkResource serviceWorkspaceProductGroupLink = client.GetServiceWorkspaceProductGroupLinkResource(serviceWorkspaceProductGroupLinkResourceId);

            // invoke the operation
            ServiceWorkspaceProductGroupLinkResource result = await serviceWorkspaceProductGroupLink.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ProductGroupLinkContractData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ApiManagementCreateWorkspaceProductGroupLink
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_ApiManagementCreateWorkspaceProductGroupLink()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementCreateWorkspaceProductGroupLink.json
            // this example is just showing the usage of "WorkspaceProductGroupLink_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceWorkspaceProductGroupLinkResource created on azure
            // for more information of creating ServiceWorkspaceProductGroupLinkResource, please refer to the document of ServiceWorkspaceProductGroupLinkResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string workspaceId = "wks1";
            string productId = "testproduct";
            string groupLinkId = "link1";
            ResourceIdentifier serviceWorkspaceProductGroupLinkResourceId = ServiceWorkspaceProductGroupLinkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, workspaceId, productId, groupLinkId);
            ServiceWorkspaceProductGroupLinkResource serviceWorkspaceProductGroupLink = client.GetServiceWorkspaceProductGroupLinkResource(serviceWorkspaceProductGroupLinkResourceId);

            // invoke the operation
            ProductGroupLinkContractData data = new ProductGroupLinkContractData()
            {
                GroupId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/workspaces/wks1/groups/group1",
            };
            ArmOperation<ServiceWorkspaceProductGroupLinkResource> lro = await serviceWorkspaceProductGroupLink.UpdateAsync(WaitUntil.Completed, data);
            ServiceWorkspaceProductGroupLinkResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ProductGroupLinkContractData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ApiManagementDeleteWorkspaceProductGroupLink
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_ApiManagementDeleteWorkspaceProductGroupLink()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementDeleteWorkspaceProductGroupLink.json
            // this example is just showing the usage of "WorkspaceProductGroupLink_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceWorkspaceProductGroupLinkResource created on azure
            // for more information of creating ServiceWorkspaceProductGroupLinkResource, please refer to the document of ServiceWorkspaceProductGroupLinkResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string workspaceId = "wks1";
            string productId = "testproduct";
            string groupLinkId = "link1";
            ResourceIdentifier serviceWorkspaceProductGroupLinkResourceId = ServiceWorkspaceProductGroupLinkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, workspaceId, productId, groupLinkId);
            ServiceWorkspaceProductGroupLinkResource serviceWorkspaceProductGroupLink = client.GetServiceWorkspaceProductGroupLinkResource(serviceWorkspaceProductGroupLinkResourceId);

            // invoke the operation
            await serviceWorkspaceProductGroupLink.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
