// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.ApiManagement.Models;

namespace Azure.ResourceManager.ApiManagement.Samples
{
    public partial class Sample_ServiceWorkspaceNotificationResource
    {
        // ApiManagementGetWorkspaceNotification
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ApiManagementGetWorkspaceNotification()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementGetWorkspaceNotification.json
            // this example is just showing the usage of "WorkspaceNotification_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceWorkspaceNotificationResource created on azure
            // for more information of creating ServiceWorkspaceNotificationResource, please refer to the document of ServiceWorkspaceNotificationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string workspaceId = "wks1";
            NotificationName notificationName = NotificationName.RequestPublisherNotificationMessage;
            ResourceIdentifier serviceWorkspaceNotificationResourceId = ServiceWorkspaceNotificationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, workspaceId, notificationName);
            ServiceWorkspaceNotificationResource serviceWorkspaceNotification = client.GetServiceWorkspaceNotificationResource(serviceWorkspaceNotificationResourceId);

            // invoke the operation
            ServiceWorkspaceNotificationResource result = await serviceWorkspaceNotification.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ApiManagementNotificationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ApiManagementCreateWorkspaceNotification
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_ApiManagementCreateWorkspaceNotification()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementCreateWorkspaceNotification.json
            // this example is just showing the usage of "WorkspaceNotification_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceWorkspaceNotificationResource created on azure
            // for more information of creating ServiceWorkspaceNotificationResource, please refer to the document of ServiceWorkspaceNotificationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string workspaceId = "wks1";
            NotificationName notificationName = NotificationName.RequestPublisherNotificationMessage;
            ResourceIdentifier serviceWorkspaceNotificationResourceId = ServiceWorkspaceNotificationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, workspaceId, notificationName);
            ServiceWorkspaceNotificationResource serviceWorkspaceNotification = client.GetServiceWorkspaceNotificationResource(serviceWorkspaceNotificationResourceId);

            // invoke the operation
            ArmOperation<ServiceWorkspaceNotificationResource> lro = await serviceWorkspaceNotification.UpdateAsync(WaitUntil.Completed);
            ServiceWorkspaceNotificationResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ApiManagementNotificationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ApiManagementListWorkspaceNotificationRecipientUsers
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetWorkspaceNotificationRecipientUsersByNotification_ApiManagementListWorkspaceNotificationRecipientUsers()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementListWorkspaceNotificationRecipientUsers.json
            // this example is just showing the usage of "WorkspaceNotificationRecipientUser_ListByNotification" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceWorkspaceNotificationResource created on azure
            // for more information of creating ServiceWorkspaceNotificationResource, please refer to the document of ServiceWorkspaceNotificationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string workspaceId = "wks1";
            NotificationName notificationName = NotificationName.RequestPublisherNotificationMessage;
            ResourceIdentifier serviceWorkspaceNotificationResourceId = ServiceWorkspaceNotificationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, workspaceId, notificationName);
            ServiceWorkspaceNotificationResource serviceWorkspaceNotification = client.GetServiceWorkspaceNotificationResource(serviceWorkspaceNotificationResourceId);

            // invoke the operation and iterate over the result
            await foreach (RecipientUserContract item in serviceWorkspaceNotification.GetWorkspaceNotificationRecipientUsersByNotificationAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // ApiManagementHeadWorkspaceNotificationRecipientUser
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CheckEntityExistsWorkspaceNotificationRecipientUser_ApiManagementHeadWorkspaceNotificationRecipientUser()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementHeadWorkspaceNotificationRecipientUser.json
            // this example is just showing the usage of "WorkspaceNotificationRecipientUser_CheckEntityExists" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceWorkspaceNotificationResource created on azure
            // for more information of creating ServiceWorkspaceNotificationResource, please refer to the document of ServiceWorkspaceNotificationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string workspaceId = "wks1";
            NotificationName notificationName = NotificationName.RequestPublisherNotificationMessage;
            ResourceIdentifier serviceWorkspaceNotificationResourceId = ServiceWorkspaceNotificationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, workspaceId, notificationName);
            ServiceWorkspaceNotificationResource serviceWorkspaceNotification = client.GetServiceWorkspaceNotificationResource(serviceWorkspaceNotificationResourceId);

            // invoke the operation
            string userId = "576823d0a40f7e74ec07d642";
            bool result = await serviceWorkspaceNotification.CheckEntityExistsWorkspaceNotificationRecipientUserAsync(userId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // ApiManagementCreateWorkspaceNotificationRecipientUser
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdateWorkspaceNotificationRecipientUser_ApiManagementCreateWorkspaceNotificationRecipientUser()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementCreateWorkspaceNotificationRecipientUser.json
            // this example is just showing the usage of "WorkspaceNotificationRecipientUser_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceWorkspaceNotificationResource created on azure
            // for more information of creating ServiceWorkspaceNotificationResource, please refer to the document of ServiceWorkspaceNotificationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string workspaceId = "wks1";
            NotificationName notificationName = NotificationName.RequestPublisherNotificationMessage;
            ResourceIdentifier serviceWorkspaceNotificationResourceId = ServiceWorkspaceNotificationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, workspaceId, notificationName);
            ServiceWorkspaceNotificationResource serviceWorkspaceNotification = client.GetServiceWorkspaceNotificationResource(serviceWorkspaceNotificationResourceId);

            // invoke the operation
            string userId = "576823d0a40f7e74ec07d642";
            RecipientUserContract result = await serviceWorkspaceNotification.CreateOrUpdateWorkspaceNotificationRecipientUserAsync(userId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // ApiManagementDeleteWorkspaceNotificationRecipientUser
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task DeleteWorkspaceNotificationRecipientUser_ApiManagementDeleteWorkspaceNotificationRecipientUser()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementDeleteWorkspaceNotificationRecipientUser.json
            // this example is just showing the usage of "WorkspaceNotificationRecipientUser_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceWorkspaceNotificationResource created on azure
            // for more information of creating ServiceWorkspaceNotificationResource, please refer to the document of ServiceWorkspaceNotificationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string workspaceId = "wks1";
            NotificationName notificationName = NotificationName.RequestPublisherNotificationMessage;
            ResourceIdentifier serviceWorkspaceNotificationResourceId = ServiceWorkspaceNotificationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, workspaceId, notificationName);
            ServiceWorkspaceNotificationResource serviceWorkspaceNotification = client.GetServiceWorkspaceNotificationResource(serviceWorkspaceNotificationResourceId);

            // invoke the operation
            string userId = "576823d0a40f7e74ec07d642";
            await serviceWorkspaceNotification.DeleteWorkspaceNotificationRecipientUserAsync(userId);

            Console.WriteLine($"Succeeded");
        }

        // ApiManagementListWorkspaceNotificationRecipientEmails
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetWorkspaceNotificationRecipientEmailsByNotification_ApiManagementListWorkspaceNotificationRecipientEmails()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementListWorkspaceNotificationRecipientEmails.json
            // this example is just showing the usage of "WorkspaceNotificationRecipientEmail_ListByNotification" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceWorkspaceNotificationResource created on azure
            // for more information of creating ServiceWorkspaceNotificationResource, please refer to the document of ServiceWorkspaceNotificationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string workspaceId = "wks1";
            NotificationName notificationName = NotificationName.RequestPublisherNotificationMessage;
            ResourceIdentifier serviceWorkspaceNotificationResourceId = ServiceWorkspaceNotificationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, workspaceId, notificationName);
            ServiceWorkspaceNotificationResource serviceWorkspaceNotification = client.GetServiceWorkspaceNotificationResource(serviceWorkspaceNotificationResourceId);

            // invoke the operation and iterate over the result
            await foreach (RecipientEmailContract item in serviceWorkspaceNotification.GetWorkspaceNotificationRecipientEmailsByNotificationAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // ApiManagementHeadWorkspaceNotificationRecipientEmail
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CheckEntityExistsWorkspaceNotificationRecipientEmail_ApiManagementHeadWorkspaceNotificationRecipientEmail()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementHeadWorkspaceNotificationRecipientEmail.json
            // this example is just showing the usage of "WorkspaceNotificationRecipientEmail_CheckEntityExists" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceWorkspaceNotificationResource created on azure
            // for more information of creating ServiceWorkspaceNotificationResource, please refer to the document of ServiceWorkspaceNotificationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string workspaceId = "wks1";
            NotificationName notificationName = NotificationName.RequestPublisherNotificationMessage;
            ResourceIdentifier serviceWorkspaceNotificationResourceId = ServiceWorkspaceNotificationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, workspaceId, notificationName);
            ServiceWorkspaceNotificationResource serviceWorkspaceNotification = client.GetServiceWorkspaceNotificationResource(serviceWorkspaceNotificationResourceId);

            // invoke the operation
            string email = "contoso@live.com";
            bool result = await serviceWorkspaceNotification.CheckEntityExistsWorkspaceNotificationRecipientEmailAsync(email);

            Console.WriteLine($"Succeeded: {result}");
        }

        // ApiManagementCreateWorkspaceNotificationRecipientEmail
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdateWorkspaceNotificationRecipientEmail_ApiManagementCreateWorkspaceNotificationRecipientEmail()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementCreateWorkspaceNotificationRecipientEmail.json
            // this example is just showing the usage of "WorkspaceNotificationRecipientEmail_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceWorkspaceNotificationResource created on azure
            // for more information of creating ServiceWorkspaceNotificationResource, please refer to the document of ServiceWorkspaceNotificationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string workspaceId = "wks1";
            NotificationName notificationName = NotificationName.RequestPublisherNotificationMessage;
            ResourceIdentifier serviceWorkspaceNotificationResourceId = ServiceWorkspaceNotificationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, workspaceId, notificationName);
            ServiceWorkspaceNotificationResource serviceWorkspaceNotification = client.GetServiceWorkspaceNotificationResource(serviceWorkspaceNotificationResourceId);

            // invoke the operation
            string email = "foobar@live.com";
            RecipientEmailContract result = await serviceWorkspaceNotification.CreateOrUpdateWorkspaceNotificationRecipientEmailAsync(email);

            Console.WriteLine($"Succeeded: {result}");
        }

        // ApiManagementDeleteWorkspaceNotificationRecipientEmail
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task DeleteWorkspaceNotificationRecipientEmail_ApiManagementDeleteWorkspaceNotificationRecipientEmail()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementDeleteWorkspaceNotificationRecipientEmail.json
            // this example is just showing the usage of "WorkspaceNotificationRecipientEmail_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceWorkspaceNotificationResource created on azure
            // for more information of creating ServiceWorkspaceNotificationResource, please refer to the document of ServiceWorkspaceNotificationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string workspaceId = "wks1";
            NotificationName notificationName = NotificationName.RequestPublisherNotificationMessage;
            ResourceIdentifier serviceWorkspaceNotificationResourceId = ServiceWorkspaceNotificationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, workspaceId, notificationName);
            ServiceWorkspaceNotificationResource serviceWorkspaceNotification = client.GetServiceWorkspaceNotificationResource(serviceWorkspaceNotificationResourceId);

            // invoke the operation
            string email = "contoso@live.com";
            await serviceWorkspaceNotification.DeleteWorkspaceNotificationRecipientEmailAsync(email);

            Console.WriteLine($"Succeeded");
        }
    }
}
