// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.ApiManagement.Models;

namespace Azure.ResourceManager.ApiManagement.Samples
{
    public partial class Sample_ServiceWorkspaceNamedValueResource
    {
        // ApiManagementHeadWorkspaceNamedValue
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetEntityTag_ApiManagementHeadWorkspaceNamedValue()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementHeadWorkspaceNamedValue.json
            // this example is just showing the usage of "WorkspaceNamedValue_GetEntityTag" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceWorkspaceNamedValueResource created on azure
            // for more information of creating ServiceWorkspaceNamedValueResource, please refer to the document of ServiceWorkspaceNamedValueResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string workspaceId = "wks1";
            string namedValueId = "testarmTemplateproperties2";
            ResourceIdentifier serviceWorkspaceNamedValueResourceId = ServiceWorkspaceNamedValueResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, workspaceId, namedValueId);
            ServiceWorkspaceNamedValueResource serviceWorkspaceNamedValue = client.GetServiceWorkspaceNamedValueResource(serviceWorkspaceNamedValueResourceId);

            // invoke the operation
            bool result = await serviceWorkspaceNamedValue.GetEntityTagAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // ApiManagementGetWorkspaceNamedValue
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ApiManagementGetWorkspaceNamedValue()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementGetWorkspaceNamedValue.json
            // this example is just showing the usage of "WorkspaceNamedValue_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceWorkspaceNamedValueResource created on azure
            // for more information of creating ServiceWorkspaceNamedValueResource, please refer to the document of ServiceWorkspaceNamedValueResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string workspaceId = "wks1";
            string namedValueId = "testarmTemplateproperties2";
            ResourceIdentifier serviceWorkspaceNamedValueResourceId = ServiceWorkspaceNamedValueResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, workspaceId, namedValueId);
            ServiceWorkspaceNamedValueResource serviceWorkspaceNamedValue = client.GetServiceWorkspaceNamedValueResource(serviceWorkspaceNamedValueResourceId);

            // invoke the operation
            ServiceWorkspaceNamedValueResource result = await serviceWorkspaceNamedValue.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ApiManagementNamedValueData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ApiManagementGetWorkspaceNamedValueWithKeyVault
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ApiManagementGetWorkspaceNamedValueWithKeyVault()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementGetWorkspaceNamedValueWithKeyVault.json
            // this example is just showing the usage of "WorkspaceNamedValue_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceWorkspaceNamedValueResource created on azure
            // for more information of creating ServiceWorkspaceNamedValueResource, please refer to the document of ServiceWorkspaceNamedValueResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string workspaceId = "wks1";
            string namedValueId = "testprop6";
            ResourceIdentifier serviceWorkspaceNamedValueResourceId = ServiceWorkspaceNamedValueResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, workspaceId, namedValueId);
            ServiceWorkspaceNamedValueResource serviceWorkspaceNamedValue = client.GetServiceWorkspaceNamedValueResource(serviceWorkspaceNamedValueResourceId);

            // invoke the operation
            ServiceWorkspaceNamedValueResource result = await serviceWorkspaceNamedValue.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ApiManagementNamedValueData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ApiManagementUpdateWorkspaceNamedValue
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_ApiManagementUpdateWorkspaceNamedValue()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementUpdateWorkspaceNamedValue.json
            // this example is just showing the usage of "WorkspaceNamedValue_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceWorkspaceNamedValueResource created on azure
            // for more information of creating ServiceWorkspaceNamedValueResource, please refer to the document of ServiceWorkspaceNamedValueResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string workspaceId = "wks1";
            string namedValueId = "testprop2";
            ResourceIdentifier serviceWorkspaceNamedValueResourceId = ServiceWorkspaceNamedValueResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, workspaceId, namedValueId);
            ServiceWorkspaceNamedValueResource serviceWorkspaceNamedValue = client.GetServiceWorkspaceNamedValueResource(serviceWorkspaceNamedValueResourceId);

            // invoke the operation
            ETag ifMatch = new ETag("*");
            ApiManagementNamedValuePatch patch = new ApiManagementNamedValuePatch()
            {
                Tags =
{
"foo","bar2"
},
                IsSecret = false,
                DisplayName = "prop3name",
                Value = "propValue",
            };
            ArmOperation<ServiceWorkspaceNamedValueResource> lro = await serviceWorkspaceNamedValue.UpdateAsync(WaitUntil.Completed, ifMatch, patch);
            ServiceWorkspaceNamedValueResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ApiManagementNamedValueData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ApiManagementDeleteWorkspaceNamedValue
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_ApiManagementDeleteWorkspaceNamedValue()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementDeleteWorkspaceNamedValue.json
            // this example is just showing the usage of "WorkspaceNamedValue_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceWorkspaceNamedValueResource created on azure
            // for more information of creating ServiceWorkspaceNamedValueResource, please refer to the document of ServiceWorkspaceNamedValueResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string workspaceId = "wks1";
            string namedValueId = "testprop2";
            ResourceIdentifier serviceWorkspaceNamedValueResourceId = ServiceWorkspaceNamedValueResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, workspaceId, namedValueId);
            ServiceWorkspaceNamedValueResource serviceWorkspaceNamedValue = client.GetServiceWorkspaceNamedValueResource(serviceWorkspaceNamedValueResourceId);

            // invoke the operation
            ETag ifMatch = new ETag("*");
            await serviceWorkspaceNamedValue.DeleteAsync(WaitUntil.Completed, ifMatch);

            Console.WriteLine($"Succeeded");
        }

        // ApiManagementWorkspaceNamedValueListValue
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetValue_ApiManagementWorkspaceNamedValueListValue()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementWorkspaceNamedValueListValue.json
            // this example is just showing the usage of "WorkspaceNamedValue_ListValue" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceWorkspaceNamedValueResource created on azure
            // for more information of creating ServiceWorkspaceNamedValueResource, please refer to the document of ServiceWorkspaceNamedValueResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string workspaceId = "wks1";
            string namedValueId = "testarmTemplateproperties2";
            ResourceIdentifier serviceWorkspaceNamedValueResourceId = ServiceWorkspaceNamedValueResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, workspaceId, namedValueId);
            ServiceWorkspaceNamedValueResource serviceWorkspaceNamedValue = client.GetServiceWorkspaceNamedValueResource(serviceWorkspaceNamedValueResourceId);

            // invoke the operation
            NamedValueSecretContract result = await serviceWorkspaceNamedValue.GetValueAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // ApiManagementRefreshWorkspaceNamedValue
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task RefreshSecret_ApiManagementRefreshWorkspaceNamedValue()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementRefreshWorkspaceNamedValue.json
            // this example is just showing the usage of "WorkspaceNamedValue_RefreshSecret" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceWorkspaceNamedValueResource created on azure
            // for more information of creating ServiceWorkspaceNamedValueResource, please refer to the document of ServiceWorkspaceNamedValueResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string workspaceId = "wks1";
            string namedValueId = "testprop2";
            ResourceIdentifier serviceWorkspaceNamedValueResourceId = ServiceWorkspaceNamedValueResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, workspaceId, namedValueId);
            ServiceWorkspaceNamedValueResource serviceWorkspaceNamedValue = client.GetServiceWorkspaceNamedValueResource(serviceWorkspaceNamedValueResourceId);

            // invoke the operation
            ArmOperation<ServiceWorkspaceNamedValueResource> lro = await serviceWorkspaceNamedValue.RefreshSecretAsync(WaitUntil.Completed);
            ServiceWorkspaceNamedValueResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ApiManagementNamedValueData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
