// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.ApiManagement.Samples
{
    public partial class Sample_ServiceTagProductLinkCollection
    {
        // ApiManagementListTagProductLinks
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ApiManagementListTagProductLinks()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementListTagProductLinks.json
            // this example is just showing the usage of "TagProductLink_ListByProduct" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApiManagementTagResource created on azure
            // for more information of creating ApiManagementTagResource, please refer to the document of ApiManagementTagResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string tagId = "tag1";
            ResourceIdentifier apiManagementTagResourceId = ApiManagementTagResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, tagId);
            ApiManagementTagResource apiManagementTag = client.GetApiManagementTagResource(apiManagementTagResourceId);

            // get the collection of this ServiceTagProductLinkResource
            ServiceTagProductLinkCollection collection = apiManagementTag.GetServiceTagProductLinks();

            // invoke the operation and iterate over the result
            await foreach (ServiceTagProductLinkResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                TagProductLinkContractData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // ApiManagementGetTagProductLink
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ApiManagementGetTagProductLink()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementGetTagProductLink.json
            // this example is just showing the usage of "TagProductLink_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApiManagementTagResource created on azure
            // for more information of creating ApiManagementTagResource, please refer to the document of ApiManagementTagResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string tagId = "tag1";
            ResourceIdentifier apiManagementTagResourceId = ApiManagementTagResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, tagId);
            ApiManagementTagResource apiManagementTag = client.GetApiManagementTagResource(apiManagementTagResourceId);

            // get the collection of this ServiceTagProductLinkResource
            ServiceTagProductLinkCollection collection = apiManagementTag.GetServiceTagProductLinks();

            // invoke the operation
            string productLinkId = "link1";
            ServiceTagProductLinkResource result = await collection.GetAsync(productLinkId);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            TagProductLinkContractData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ApiManagementGetTagProductLink
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_ApiManagementGetTagProductLink()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementGetTagProductLink.json
            // this example is just showing the usage of "TagProductLink_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApiManagementTagResource created on azure
            // for more information of creating ApiManagementTagResource, please refer to the document of ApiManagementTagResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string tagId = "tag1";
            ResourceIdentifier apiManagementTagResourceId = ApiManagementTagResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, tagId);
            ApiManagementTagResource apiManagementTag = client.GetApiManagementTagResource(apiManagementTagResourceId);

            // get the collection of this ServiceTagProductLinkResource
            ServiceTagProductLinkCollection collection = apiManagementTag.GetServiceTagProductLinks();

            // invoke the operation
            string productLinkId = "link1";
            bool result = await collection.ExistsAsync(productLinkId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // ApiManagementGetTagProductLink
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_ApiManagementGetTagProductLink()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementGetTagProductLink.json
            // this example is just showing the usage of "TagProductLink_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApiManagementTagResource created on azure
            // for more information of creating ApiManagementTagResource, please refer to the document of ApiManagementTagResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string tagId = "tag1";
            ResourceIdentifier apiManagementTagResourceId = ApiManagementTagResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, tagId);
            ApiManagementTagResource apiManagementTag = client.GetApiManagementTagResource(apiManagementTagResourceId);

            // get the collection of this ServiceTagProductLinkResource
            ServiceTagProductLinkCollection collection = apiManagementTag.GetServiceTagProductLinks();

            // invoke the operation
            string productLinkId = "link1";
            NullableResponse<ServiceTagProductLinkResource> response = await collection.GetIfExistsAsync(productLinkId);
            ServiceTagProductLinkResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                TagProductLinkContractData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // ApiManagementCreateTagProductLink
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_ApiManagementCreateTagProductLink()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementCreateTagProductLink.json
            // this example is just showing the usage of "TagProductLink_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApiManagementTagResource created on azure
            // for more information of creating ApiManagementTagResource, please refer to the document of ApiManagementTagResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string tagId = "tag1";
            ResourceIdentifier apiManagementTagResourceId = ApiManagementTagResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, tagId);
            ApiManagementTagResource apiManagementTag = client.GetApiManagementTagResource(apiManagementTagResourceId);

            // get the collection of this ServiceTagProductLinkResource
            ServiceTagProductLinkCollection collection = apiManagementTag.GetServiceTagProductLinks();

            // invoke the operation
            string productLinkId = "link1";
            TagProductLinkContractData data = new TagProductLinkContractData()
            {
                ProductId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/products/product1",
            };
            ArmOperation<ServiceTagProductLinkResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, productLinkId, data);
            ServiceTagProductLinkResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            TagProductLinkContractData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
