// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.ApiManagement.Samples
{
    public partial class Sample_ServiceTagOperationLinkResource
    {
        // ApiManagementGetTagOperationLink
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ApiManagementGetTagOperationLink()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementGetTagOperationLink.json
            // this example is just showing the usage of "TagOperationLink_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceTagOperationLinkResource created on azure
            // for more information of creating ServiceTagOperationLinkResource, please refer to the document of ServiceTagOperationLinkResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string tagId = "tag1";
            string operationLinkId = "link1";
            ResourceIdentifier serviceTagOperationLinkResourceId = ServiceTagOperationLinkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, tagId, operationLinkId);
            ServiceTagOperationLinkResource serviceTagOperationLink = client.GetServiceTagOperationLinkResource(serviceTagOperationLinkResourceId);

            // invoke the operation
            ServiceTagOperationLinkResource result = await serviceTagOperationLink.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            TagOperationLinkContractData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ApiManagementCreateTagOperationLink
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_ApiManagementCreateTagOperationLink()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementCreateTagOperationLink.json
            // this example is just showing the usage of "TagOperationLink_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceTagOperationLinkResource created on azure
            // for more information of creating ServiceTagOperationLinkResource, please refer to the document of ServiceTagOperationLinkResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string tagId = "tag1";
            string operationLinkId = "link1";
            ResourceIdentifier serviceTagOperationLinkResourceId = ServiceTagOperationLinkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, tagId, operationLinkId);
            ServiceTagOperationLinkResource serviceTagOperationLink = client.GetServiceTagOperationLinkResource(serviceTagOperationLinkResourceId);

            // invoke the operation
            TagOperationLinkContractData data = new TagOperationLinkContractData()
            {
                OperationId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/apis/echo-api/operations/op1",
            };
            ArmOperation<ServiceTagOperationLinkResource> lro = await serviceTagOperationLink.UpdateAsync(WaitUntil.Completed, data);
            ServiceTagOperationLinkResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            TagOperationLinkContractData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ApiManagementDeleteTagOperationLink
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_ApiManagementDeleteTagOperationLink()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementDeleteTagOperationLink.json
            // this example is just showing the usage of "TagOperationLink_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceTagOperationLinkResource created on azure
            // for more information of creating ServiceTagOperationLinkResource, please refer to the document of ServiceTagOperationLinkResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string tagId = "tag1";
            string operationLinkId = "link1";
            ResourceIdentifier serviceTagOperationLinkResourceId = ServiceTagOperationLinkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, tagId, operationLinkId);
            ServiceTagOperationLinkResource serviceTagOperationLink = client.GetServiceTagOperationLinkResource(serviceTagOperationLinkResourceId);

            // invoke the operation
            await serviceTagOperationLink.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
