// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.ApiManagement.Samples
{
    public partial class Sample_ServiceProductGroupLinkResource
    {
        // ApiManagementGetProductGroupLink
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ApiManagementGetProductGroupLink()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementGetProductGroupLink.json
            // this example is just showing the usage of "ProductGroupLink_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceProductGroupLinkResource created on azure
            // for more information of creating ServiceProductGroupLinkResource, please refer to the document of ServiceProductGroupLinkResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string productId = "testproduct";
            string groupLinkId = "link1";
            ResourceIdentifier serviceProductGroupLinkResourceId = ServiceProductGroupLinkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, productId, groupLinkId);
            ServiceProductGroupLinkResource serviceProductGroupLink = client.GetServiceProductGroupLinkResource(serviceProductGroupLinkResourceId);

            // invoke the operation
            ServiceProductGroupLinkResource result = await serviceProductGroupLink.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ProductGroupLinkContractData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ApiManagementCreateProductGroupLink
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_ApiManagementCreateProductGroupLink()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementCreateProductGroupLink.json
            // this example is just showing the usage of "ProductGroupLink_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceProductGroupLinkResource created on azure
            // for more information of creating ServiceProductGroupLinkResource, please refer to the document of ServiceProductGroupLinkResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string productId = "testproduct";
            string groupLinkId = "link1";
            ResourceIdentifier serviceProductGroupLinkResourceId = ServiceProductGroupLinkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, productId, groupLinkId);
            ServiceProductGroupLinkResource serviceProductGroupLink = client.GetServiceProductGroupLinkResource(serviceProductGroupLinkResourceId);

            // invoke the operation
            ProductGroupLinkContractData data = new ProductGroupLinkContractData()
            {
                GroupId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/groups/group1",
            };
            ArmOperation<ServiceProductGroupLinkResource> lro = await serviceProductGroupLink.UpdateAsync(WaitUntil.Completed, data);
            ServiceProductGroupLinkResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ProductGroupLinkContractData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ApiManagementDeleteProductGroupLink
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_ApiManagementDeleteProductGroupLink()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementDeleteProductGroupLink.json
            // this example is just showing the usage of "ProductGroupLink_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceProductGroupLinkResource created on azure
            // for more information of creating ServiceProductGroupLinkResource, please refer to the document of ServiceProductGroupLinkResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string productId = "testproduct";
            string groupLinkId = "link1";
            ResourceIdentifier serviceProductGroupLinkResourceId = ServiceProductGroupLinkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, productId, groupLinkId);
            ServiceProductGroupLinkResource serviceProductGroupLink = client.GetServiceProductGroupLinkResource(serviceProductGroupLinkResourceId);

            // invoke the operation
            await serviceProductGroupLink.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
