// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.ApiManagement.Models;

namespace Azure.ResourceManager.ApiManagement.Samples
{
    public partial class Sample_DocumentationContractResource
    {
        // ApiManagementHeadDocumentation
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetEntityTag_ApiManagementHeadDocumentation()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementHeadDocumentation.json
            // this example is just showing the usage of "Documentation_GetEntityTag" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DocumentationContractResource created on azure
            // for more information of creating DocumentationContractResource, please refer to the document of DocumentationContractResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string documentationId = "57d1f7558aa04f15146d9d8a";
            ResourceIdentifier documentationContractResourceId = DocumentationContractResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, documentationId);
            DocumentationContractResource documentationContract = client.GetDocumentationContractResource(documentationContractResourceId);

            // invoke the operation
            bool result = await documentationContract.GetEntityTagAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // ApiManagementGetDocumentation
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ApiManagementGetDocumentation()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementGetDocumentation.json
            // this example is just showing the usage of "Documentation_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DocumentationContractResource created on azure
            // for more information of creating DocumentationContractResource, please refer to the document of DocumentationContractResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string documentationId = "57d1f7558aa04f15146d9d8a";
            ResourceIdentifier documentationContractResourceId = DocumentationContractResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, documentationId);
            DocumentationContractResource documentationContract = client.GetDocumentationContractResource(documentationContractResourceId);

            // invoke the operation
            DocumentationContractResource result = await documentationContract.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DocumentationContractData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ApiManagementUpdateDocumentation
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_ApiManagementUpdateDocumentation()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementUpdateDocumentation.json
            // this example is just showing the usage of "Documentation_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DocumentationContractResource created on azure
            // for more information of creating DocumentationContractResource, please refer to the document of DocumentationContractResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string documentationId = "57d1f7558aa04f15146d9d8a";
            ResourceIdentifier documentationContractResourceId = DocumentationContractResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, documentationId);
            DocumentationContractResource documentationContract = client.GetDocumentationContractResource(documentationContractResourceId);

            // invoke the operation
            ETag ifMatch = default /* Warning: No value is provided for ifMatch in example 'ApiManagementUpdateDocumentation'. Please consider adding a proper example value for it in swagger*/;
            DocumentationContractPatch patch = new DocumentationContractPatch()
            {
                Title = "Title updated",
                Content = "content updated",
            };
            DocumentationContractResource result = await documentationContract.UpdateAsync(ifMatch, patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DocumentationContractData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ApiManagementDeleteDocumentation
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_ApiManagementDeleteDocumentation()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementDeleteDocumentation.json
            // this example is just showing the usage of "Documentation_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DocumentationContractResource created on azure
            // for more information of creating DocumentationContractResource, please refer to the document of DocumentationContractResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string documentationId = "57d1f7558aa04f15146d9d8a";
            ResourceIdentifier documentationContractResourceId = DocumentationContractResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, documentationId);
            DocumentationContractResource documentationContract = client.GetDocumentationContractResource(documentationContractResourceId);

            // invoke the operation
            ETag ifMatch = default /* Warning: No value is provided for ifMatch in example 'ApiManagementDeleteDocumentation'. Please consider adding a proper example value for it in swagger*/;
            await documentationContract.DeleteAsync(WaitUntil.Completed, ifMatch);

            Console.WriteLine($"Succeeded");
        }
    }
}
