// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.ApiManagement.Models;

namespace Azure.ResourceManager.ApiManagement.Samples
{
    public partial class Sample_AuthorizationContractResource
    {
        // ApiManagementGetAuthorization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ApiManagementGetAuthorization()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementGetAuthorization.json
            // this example is just showing the usage of "Authorization_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AuthorizationContractResource created on azure
            // for more information of creating AuthorizationContractResource, please refer to the document of AuthorizationContractResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string authorizationProviderId = "aadwithauthcode";
            string authorizationId = "authz1";
            ResourceIdentifier authorizationContractResourceId = AuthorizationContractResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, authorizationProviderId, authorizationId);
            AuthorizationContractResource authorizationContract = client.GetAuthorizationContractResource(authorizationContractResourceId);

            // invoke the operation
            AuthorizationContractResource result = await authorizationContract.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AuthorizationContractData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ApiManagementCreateAuthorizationAADAuthCode
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_ApiManagementCreateAuthorizationAADAuthCode()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementCreateAuthorizationAADAuthCode.json
            // this example is just showing the usage of "Authorization_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AuthorizationContractResource created on azure
            // for more information of creating AuthorizationContractResource, please refer to the document of AuthorizationContractResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string authorizationProviderId = "aadwithauthcode";
            string authorizationId = "authz2";
            ResourceIdentifier authorizationContractResourceId = AuthorizationContractResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, authorizationProviderId, authorizationId);
            AuthorizationContractResource authorizationContract = client.GetAuthorizationContractResource(authorizationContractResourceId);

            // invoke the operation
            AuthorizationContractData data = new AuthorizationContractData()
            {
                AuthorizationType = ApiManagementAuthorizationType.OAuth2,
                OAuth2GrantType = OAuth2GrantType.AuthorizationCode,
            };
            ArmOperation<AuthorizationContractResource> lro = await authorizationContract.UpdateAsync(WaitUntil.Completed, data);
            AuthorizationContractResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AuthorizationContractData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ApiManagementCreateAuthorizationAADClientCred
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_ApiManagementCreateAuthorizationAADClientCred()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementCreateAuthorizationAADClientCred.json
            // this example is just showing the usage of "Authorization_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AuthorizationContractResource created on azure
            // for more information of creating AuthorizationContractResource, please refer to the document of AuthorizationContractResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string authorizationProviderId = "aadwithclientcred";
            string authorizationId = "authz1";
            ResourceIdentifier authorizationContractResourceId = AuthorizationContractResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, authorizationProviderId, authorizationId);
            AuthorizationContractResource authorizationContract = client.GetAuthorizationContractResource(authorizationContractResourceId);

            // invoke the operation
            AuthorizationContractData data = new AuthorizationContractData()
            {
                AuthorizationType = ApiManagementAuthorizationType.OAuth2,
                OAuth2GrantType = OAuth2GrantType.AuthorizationCode,
                Parameters =
{
["clientId"] = "53790925-fdd3-4b80-bc7a-4c3aaf25801d",
["clientSecret"] = "xxxxxxxxxxxxxxx~xxxxxxxxx",
},
            };
            ArmOperation<AuthorizationContractResource> lro = await authorizationContract.UpdateAsync(WaitUntil.Completed, data);
            AuthorizationContractResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AuthorizationContractData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ApiManagementDeleteAuthorization
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_ApiManagementDeleteAuthorization()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementDeleteAuthorization.json
            // this example is just showing the usage of "Authorization_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AuthorizationContractResource created on azure
            // for more information of creating AuthorizationContractResource, please refer to the document of AuthorizationContractResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string authorizationProviderId = "aadwithauthcode";
            string authorizationId = "authz1";
            ResourceIdentifier authorizationContractResourceId = AuthorizationContractResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, authorizationProviderId, authorizationId);
            AuthorizationContractResource authorizationContract = client.GetAuthorizationContractResource(authorizationContractResourceId);

            // invoke the operation
            ETag ifMatch = new ETag("*");
            await authorizationContract.DeleteAsync(WaitUntil.Completed, ifMatch);

            Console.WriteLine($"Succeeded");
        }

        // ApiManagementPostAuthorizationConfirmConsentCodeRequest
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task ConfirmConsentCode_ApiManagementPostAuthorizationConfirmConsentCodeRequest()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementPostAuthorizationConfirmConsentCodeRequest.json
            // this example is just showing the usage of "Authorization_ConfirmConsentCode" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AuthorizationContractResource created on azure
            // for more information of creating AuthorizationContractResource, please refer to the document of AuthorizationContractResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string authorizationProviderId = "aadwithauthcode";
            string authorizationId = "authz1";
            ResourceIdentifier authorizationContractResourceId = AuthorizationContractResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, authorizationProviderId, authorizationId);
            AuthorizationContractResource authorizationContract = client.GetAuthorizationContractResource(authorizationContractResourceId);

            // invoke the operation
            AuthorizationConfirmConsentCodeContent content = new AuthorizationConfirmConsentCodeContent()
            {
                ConsentCode = "theconsentcode",
            };
            await authorizationContract.ConfirmConsentCodeAsync(content);

            Console.WriteLine($"Succeeded");
        }

        // ApiManagementGetAuthorizationLoginRequest
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task PostAuthorizationLoginLink_ApiManagementGetAuthorizationLoginRequest()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementGetAuthorizationLoginRequest.json
            // this example is just showing the usage of "AuthorizationLoginLinks_Post" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AuthorizationContractResource created on azure
            // for more information of creating AuthorizationContractResource, please refer to the document of AuthorizationContractResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string authorizationProviderId = "aadwithauthcode";
            string authorizationId = "authz1";
            ResourceIdentifier authorizationContractResourceId = AuthorizationContractResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, authorizationProviderId, authorizationId);
            AuthorizationContractResource authorizationContract = client.GetAuthorizationContractResource(authorizationContractResourceId);

            // invoke the operation
            AuthorizationLoginContent content = new AuthorizationLoginContent()
            {
                PostLoginRedirectUri = new Uri("https://www.bing.com/"),
            };
            AuthorizationLoginResult result = await authorizationContract.PostAuthorizationLoginLinkAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
