// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.ApiManagement.Samples
{
    public partial class Sample_AuthorizationAccessPolicyContractResource
    {
        // ApiManagementGetAuthorizationAccessPolicy
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ApiManagementGetAuthorizationAccessPolicy()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementGetAuthorizationAccessPolicy.json
            // this example is just showing the usage of "AuthorizationAccessPolicy_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AuthorizationAccessPolicyContractResource created on azure
            // for more information of creating AuthorizationAccessPolicyContractResource, please refer to the document of AuthorizationAccessPolicyContractResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string authorizationProviderId = "aadwithauthcode";
            string authorizationId = "authz1";
            string authorizationAccessPolicyId = "fe0bed83-631f-4149-bd0b-0464b1bc7cab";
            ResourceIdentifier authorizationAccessPolicyContractResourceId = AuthorizationAccessPolicyContractResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, authorizationProviderId, authorizationId, authorizationAccessPolicyId);
            AuthorizationAccessPolicyContractResource authorizationAccessPolicyContract = client.GetAuthorizationAccessPolicyContractResource(authorizationAccessPolicyContractResourceId);

            // invoke the operation
            AuthorizationAccessPolicyContractResource result = await authorizationAccessPolicyContract.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AuthorizationAccessPolicyContractData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ApiManagementCreateAuthorizationAccessPolicy
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_ApiManagementCreateAuthorizationAccessPolicy()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementCreateAuthorizationAccessPolicy.json
            // this example is just showing the usage of "AuthorizationAccessPolicy_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AuthorizationAccessPolicyContractResource created on azure
            // for more information of creating AuthorizationAccessPolicyContractResource, please refer to the document of AuthorizationAccessPolicyContractResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string authorizationProviderId = "aadwithauthcode";
            string authorizationId = "authz1";
            string authorizationAccessPolicyId = "fe0bed83-631f-4149-bd0b-0464b1bc7cab";
            ResourceIdentifier authorizationAccessPolicyContractResourceId = AuthorizationAccessPolicyContractResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, authorizationProviderId, authorizationId, authorizationAccessPolicyId);
            AuthorizationAccessPolicyContractResource authorizationAccessPolicyContract = client.GetAuthorizationAccessPolicyContractResource(authorizationAccessPolicyContractResourceId);

            // invoke the operation
            AuthorizationAccessPolicyContractData data = new AuthorizationAccessPolicyContractData()
            {
                TenantId = Guid.Parse("13932a0d-5c63-4d37-901d-1df9c97722ff"),
                ObjectId = "fe0bed83-631f-4149-bd0b-0464b1bc7cab",
            };
            ArmOperation<AuthorizationAccessPolicyContractResource> lro = await authorizationAccessPolicyContract.UpdateAsync(WaitUntil.Completed, data);
            AuthorizationAccessPolicyContractResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AuthorizationAccessPolicyContractData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ApiManagementDeleteAuthorizationAccessPolicy
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_ApiManagementDeleteAuthorizationAccessPolicy()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementDeleteAuthorizationAccessPolicy.json
            // this example is just showing the usage of "AuthorizationAccessPolicy_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AuthorizationAccessPolicyContractResource created on azure
            // for more information of creating AuthorizationAccessPolicyContractResource, please refer to the document of AuthorizationAccessPolicyContractResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string authorizationProviderId = "aadwithauthcode";
            string authorizationId = "authz1";
            string authorizationAccessPolicyId = "fe0bed83-631f-4149-bd0b-0464b1bc7cab";
            ResourceIdentifier authorizationAccessPolicyContractResourceId = AuthorizationAccessPolicyContractResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, authorizationProviderId, authorizationId, authorizationAccessPolicyId);
            AuthorizationAccessPolicyContractResource authorizationAccessPolicyContract = client.GetAuthorizationAccessPolicyContractResource(authorizationAccessPolicyContractResourceId);

            // invoke the operation
            ETag ifMatch = new ETag("*");
            await authorizationAccessPolicyContract.DeleteAsync(WaitUntil.Completed, ifMatch);

            Console.WriteLine($"Succeeded");
        }
    }
}
