// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.ApiManagement.Samples
{
    public partial class Sample_ApiManagementUserSubscriptionResource
    {
        // ApiManagementGetUserSubscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ApiManagementGetUserSubscription()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementGetUserSubscription.json
            // this example is just showing the usage of "UserSubscription_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApiManagementUserSubscriptionResource created on azure
            // for more information of creating ApiManagementUserSubscriptionResource, please refer to the document of ApiManagementUserSubscriptionResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string userId = "1";
            string sid = "5fa9b096f3df14003c070001";
            ResourceIdentifier apiManagementUserSubscriptionResourceId = ApiManagementUserSubscriptionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, userId, sid);
            ApiManagementUserSubscriptionResource apiManagementUserSubscription = client.GetApiManagementUserSubscriptionResource(apiManagementUserSubscriptionResourceId);

            // invoke the operation
            ApiManagementUserSubscriptionResource result = await apiManagementUserSubscription.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SubscriptionContractData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
