// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.ApiManagement.Models;

namespace Azure.ResourceManager.ApiManagement.Samples
{
    public partial class Sample_ApiManagementPortalSignUpSettingResource
    {
        // ApiManagementHeadSignUpSettings
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetEntityTag_ApiManagementHeadSignUpSettings()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementHeadSignUpSettings.json
            // this example is just showing the usage of "SignUpSettings_GetEntityTag" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApiManagementPortalSignUpSettingResource created on azure
            // for more information of creating ApiManagementPortalSignUpSettingResource, please refer to the document of ApiManagementPortalSignUpSettingResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            ResourceIdentifier apiManagementPortalSignUpSettingResourceId = ApiManagementPortalSignUpSettingResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName);
            ApiManagementPortalSignUpSettingResource apiManagementPortalSignUpSetting = client.GetApiManagementPortalSignUpSettingResource(apiManagementPortalSignUpSettingResourceId);

            // invoke the operation
            bool result = await apiManagementPortalSignUpSetting.GetEntityTagAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // ApiManagementPortalSettingsGetSignUp
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ApiManagementPortalSettingsGetSignUp()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementPortalSettingsGetSignUp.json
            // this example is just showing the usage of "SignUpSettings_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApiManagementPortalSignUpSettingResource created on azure
            // for more information of creating ApiManagementPortalSignUpSettingResource, please refer to the document of ApiManagementPortalSignUpSettingResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            ResourceIdentifier apiManagementPortalSignUpSettingResourceId = ApiManagementPortalSignUpSettingResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName);
            ApiManagementPortalSignUpSettingResource apiManagementPortalSignUpSetting = client.GetApiManagementPortalSignUpSettingResource(apiManagementPortalSignUpSettingResourceId);

            // invoke the operation
            ApiManagementPortalSignUpSettingResource result = await apiManagementPortalSignUpSetting.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ApiManagementPortalSignUpSettingData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ApiManagementPortalSettingsUpdateSignUp
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_ApiManagementPortalSettingsUpdateSignUp()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementPortalSettingsUpdateSignUp.json
            // this example is just showing the usage of "SignUpSettings_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApiManagementPortalSignUpSettingResource created on azure
            // for more information of creating ApiManagementPortalSignUpSettingResource, please refer to the document of ApiManagementPortalSignUpSettingResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            ResourceIdentifier apiManagementPortalSignUpSettingResourceId = ApiManagementPortalSignUpSettingResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName);
            ApiManagementPortalSignUpSettingResource apiManagementPortalSignUpSetting = client.GetApiManagementPortalSignUpSettingResource(apiManagementPortalSignUpSettingResourceId);

            // invoke the operation
            ETag ifMatch = new ETag("*");
            ApiManagementPortalSignUpSettingData data = new ApiManagementPortalSignUpSettingData()
            {
                IsSignUpDeveloperPortalEnabled = true,
                TermsOfService = new TermsOfServiceProperties()
                {
                    Text = "Terms of service text.",
                    IsDisplayEnabled = true,
                    IsConsentRequired = true,
                },
            };
            await apiManagementPortalSignUpSetting.UpdateAsync(ifMatch, data);

            Console.WriteLine($"Succeeded");
        }

        // ApiManagementPortalSettingsUpdateSignUp
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_ApiManagementPortalSettingsUpdateSignUp()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementPortalSettingsPutSignUp.json
            // this example is just showing the usage of "SignUpSettings_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApiManagementPortalSignUpSettingResource created on azure
            // for more information of creating ApiManagementPortalSignUpSettingResource, please refer to the document of ApiManagementPortalSignUpSettingResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            ResourceIdentifier apiManagementPortalSignUpSettingResourceId = ApiManagementPortalSignUpSettingResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName);
            ApiManagementPortalSignUpSettingResource apiManagementPortalSignUpSetting = client.GetApiManagementPortalSignUpSettingResource(apiManagementPortalSignUpSettingResourceId);

            // invoke the operation
            ApiManagementPortalSignUpSettingData data = new ApiManagementPortalSignUpSettingData()
            {
                IsSignUpDeveloperPortalEnabled = true,
                TermsOfService = new TermsOfServiceProperties()
                {
                    Text = "Terms of service text.",
                    IsDisplayEnabled = true,
                    IsConsentRequired = true,
                },
            };
            ETag? ifMatch = new ETag("*");
            ArmOperation<ApiManagementPortalSignUpSettingResource> lro = await apiManagementPortalSignUpSetting.CreateOrUpdateAsync(WaitUntil.Completed, data, ifMatch: ifMatch);
            ApiManagementPortalSignUpSettingResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ApiManagementPortalSignUpSettingData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
