// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.ApiManagement.Models;

namespace Azure.ResourceManager.ApiManagement.Samples
{
    public partial class Sample_ApiManagementNotificationResource
    {
        // ApiManagementGetNotification
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ApiManagementGetNotification()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementGetNotification.json
            // this example is just showing the usage of "Notification_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApiManagementNotificationResource created on azure
            // for more information of creating ApiManagementNotificationResource, please refer to the document of ApiManagementNotificationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            NotificationName notificationName = NotificationName.RequestPublisherNotificationMessage;
            ResourceIdentifier apiManagementNotificationResourceId = ApiManagementNotificationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, notificationName);
            ApiManagementNotificationResource apiManagementNotification = client.GetApiManagementNotificationResource(apiManagementNotificationResourceId);

            // invoke the operation
            ApiManagementNotificationResource result = await apiManagementNotification.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ApiManagementNotificationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ApiManagementCreateNotification
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_ApiManagementCreateNotification()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementCreateNotification.json
            // this example is just showing the usage of "Notification_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApiManagementNotificationResource created on azure
            // for more information of creating ApiManagementNotificationResource, please refer to the document of ApiManagementNotificationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            NotificationName notificationName = NotificationName.RequestPublisherNotificationMessage;
            ResourceIdentifier apiManagementNotificationResourceId = ApiManagementNotificationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, notificationName);
            ApiManagementNotificationResource apiManagementNotification = client.GetApiManagementNotificationResource(apiManagementNotificationResourceId);

            // invoke the operation
            ArmOperation<ApiManagementNotificationResource> lro = await apiManagementNotification.UpdateAsync(WaitUntil.Completed);
            ApiManagementNotificationResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ApiManagementNotificationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ApiManagementListNotificationRecipientUsers
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetNotificationRecipientUsers_ApiManagementListNotificationRecipientUsers()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementListNotificationRecipientUsers.json
            // this example is just showing the usage of "NotificationRecipientUser_ListByNotification" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApiManagementNotificationResource created on azure
            // for more information of creating ApiManagementNotificationResource, please refer to the document of ApiManagementNotificationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            NotificationName notificationName = NotificationName.RequestPublisherNotificationMessage;
            ResourceIdentifier apiManagementNotificationResourceId = ApiManagementNotificationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, notificationName);
            ApiManagementNotificationResource apiManagementNotification = client.GetApiManagementNotificationResource(apiManagementNotificationResourceId);

            // invoke the operation and iterate over the result
            await foreach (RecipientUserContract item in apiManagementNotification.GetNotificationRecipientUsersAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // ApiManagementHeadNotificationRecipientUser
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CheckNotificationRecipientUserEntityExists_ApiManagementHeadNotificationRecipientUser()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementHeadNotificationRecipientUser.json
            // this example is just showing the usage of "NotificationRecipientUser_CheckEntityExists" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApiManagementNotificationResource created on azure
            // for more information of creating ApiManagementNotificationResource, please refer to the document of ApiManagementNotificationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            NotificationName notificationName = NotificationName.RequestPublisherNotificationMessage;
            ResourceIdentifier apiManagementNotificationResourceId = ApiManagementNotificationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, notificationName);
            ApiManagementNotificationResource apiManagementNotification = client.GetApiManagementNotificationResource(apiManagementNotificationResourceId);

            // invoke the operation
            string userId = "576823d0a40f7e74ec07d642";
            bool result = await apiManagementNotification.CheckNotificationRecipientUserEntityExistsAsync(userId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // ApiManagementCreateNotificationRecipientUser
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdateNotificationRecipientUser_ApiManagementCreateNotificationRecipientUser()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementCreateNotificationRecipientUser.json
            // this example is just showing the usage of "NotificationRecipientUser_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApiManagementNotificationResource created on azure
            // for more information of creating ApiManagementNotificationResource, please refer to the document of ApiManagementNotificationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            NotificationName notificationName = NotificationName.RequestPublisherNotificationMessage;
            ResourceIdentifier apiManagementNotificationResourceId = ApiManagementNotificationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, notificationName);
            ApiManagementNotificationResource apiManagementNotification = client.GetApiManagementNotificationResource(apiManagementNotificationResourceId);

            // invoke the operation
            string userId = "576823d0a40f7e74ec07d642";
            RecipientUserContract result = await apiManagementNotification.CreateOrUpdateNotificationRecipientUserAsync(userId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // ApiManagementDeleteNotificationRecipientUser
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task DeleteNotificationRecipientUser_ApiManagementDeleteNotificationRecipientUser()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementDeleteNotificationRecipientUser.json
            // this example is just showing the usage of "NotificationRecipientUser_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApiManagementNotificationResource created on azure
            // for more information of creating ApiManagementNotificationResource, please refer to the document of ApiManagementNotificationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            NotificationName notificationName = NotificationName.RequestPublisherNotificationMessage;
            ResourceIdentifier apiManagementNotificationResourceId = ApiManagementNotificationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, notificationName);
            ApiManagementNotificationResource apiManagementNotification = client.GetApiManagementNotificationResource(apiManagementNotificationResourceId);

            // invoke the operation
            string userId = "576823d0a40f7e74ec07d642";
            await apiManagementNotification.DeleteNotificationRecipientUserAsync(userId);

            Console.WriteLine($"Succeeded");
        }

        // ApiManagementListNotificationRecipientEmails
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetNotificationRecipientEmails_ApiManagementListNotificationRecipientEmails()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementListNotificationRecipientEmails.json
            // this example is just showing the usage of "NotificationRecipientEmail_ListByNotification" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApiManagementNotificationResource created on azure
            // for more information of creating ApiManagementNotificationResource, please refer to the document of ApiManagementNotificationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            NotificationName notificationName = NotificationName.RequestPublisherNotificationMessage;
            ResourceIdentifier apiManagementNotificationResourceId = ApiManagementNotificationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, notificationName);
            ApiManagementNotificationResource apiManagementNotification = client.GetApiManagementNotificationResource(apiManagementNotificationResourceId);

            // invoke the operation and iterate over the result
            await foreach (RecipientEmailContract item in apiManagementNotification.GetNotificationRecipientEmailsAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // ApiManagementHeadNotificationRecipientEmail
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CheckNotificationRecipientEmailEntityExists_ApiManagementHeadNotificationRecipientEmail()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementHeadNotificationRecipientEmail.json
            // this example is just showing the usage of "NotificationRecipientEmail_CheckEntityExists" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApiManagementNotificationResource created on azure
            // for more information of creating ApiManagementNotificationResource, please refer to the document of ApiManagementNotificationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            NotificationName notificationName = NotificationName.RequestPublisherNotificationMessage;
            ResourceIdentifier apiManagementNotificationResourceId = ApiManagementNotificationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, notificationName);
            ApiManagementNotificationResource apiManagementNotification = client.GetApiManagementNotificationResource(apiManagementNotificationResourceId);

            // invoke the operation
            string email = "contoso@live.com";
            bool result = await apiManagementNotification.CheckNotificationRecipientEmailEntityExistsAsync(email);

            Console.WriteLine($"Succeeded: {result}");
        }

        // ApiManagementCreateNotificationRecipientEmail
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdateNotificationRecipientEmail_ApiManagementCreateNotificationRecipientEmail()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementCreateNotificationRecipientEmail.json
            // this example is just showing the usage of "NotificationRecipientEmail_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApiManagementNotificationResource created on azure
            // for more information of creating ApiManagementNotificationResource, please refer to the document of ApiManagementNotificationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            NotificationName notificationName = NotificationName.RequestPublisherNotificationMessage;
            ResourceIdentifier apiManagementNotificationResourceId = ApiManagementNotificationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, notificationName);
            ApiManagementNotificationResource apiManagementNotification = client.GetApiManagementNotificationResource(apiManagementNotificationResourceId);

            // invoke the operation
            string email = "foobar@live.com";
            RecipientEmailContract result = await apiManagementNotification.CreateOrUpdateNotificationRecipientEmailAsync(email);

            Console.WriteLine($"Succeeded: {result}");
        }

        // ApiManagementDeleteNotificationRecipientEmail
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task DeleteNotificationRecipientEmail_ApiManagementDeleteNotificationRecipientEmail()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementDeleteNotificationRecipientEmail.json
            // this example is just showing the usage of "NotificationRecipientEmail_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApiManagementNotificationResource created on azure
            // for more information of creating ApiManagementNotificationResource, please refer to the document of ApiManagementNotificationResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            NotificationName notificationName = NotificationName.RequestPublisherNotificationMessage;
            ResourceIdentifier apiManagementNotificationResourceId = ApiManagementNotificationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, notificationName);
            ApiManagementNotificationResource apiManagementNotification = client.GetApiManagementNotificationResource(apiManagementNotificationResourceId);

            // invoke the operation
            string email = "contoso@live.com";
            await apiManagementNotification.DeleteNotificationRecipientEmailAsync(email);

            Console.WriteLine($"Succeeded");
        }
    }
}
