// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.ApiManagement.Models;

namespace Azure.ResourceManager.ApiManagement.Samples
{
    public partial class Sample_ApiManagementIdentityProviderResource
    {
        // ApiManagementHeadIdentityProvider
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetEntityTag_ApiManagementHeadIdentityProvider()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementHeadIdentityProvider.json
            // this example is just showing the usage of "IdentityProvider_GetEntityTag" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApiManagementIdentityProviderResource created on azure
            // for more information of creating ApiManagementIdentityProviderResource, please refer to the document of ApiManagementIdentityProviderResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            IdentityProviderType identityProviderName = IdentityProviderType.AadB2C;
            ResourceIdentifier apiManagementIdentityProviderResourceId = ApiManagementIdentityProviderResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, identityProviderName);
            ApiManagementIdentityProviderResource apiManagementIdentityProvider = client.GetApiManagementIdentityProviderResource(apiManagementIdentityProviderResourceId);

            // invoke the operation
            bool result = await apiManagementIdentityProvider.GetEntityTagAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // ApiManagementGetIdentityProvider
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ApiManagementGetIdentityProvider()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementGetIdentityProvider.json
            // this example is just showing the usage of "IdentityProvider_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApiManagementIdentityProviderResource created on azure
            // for more information of creating ApiManagementIdentityProviderResource, please refer to the document of ApiManagementIdentityProviderResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            IdentityProviderType identityProviderName = IdentityProviderType.AadB2C;
            ResourceIdentifier apiManagementIdentityProviderResourceId = ApiManagementIdentityProviderResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, identityProviderName);
            ApiManagementIdentityProviderResource apiManagementIdentityProvider = client.GetApiManagementIdentityProviderResource(apiManagementIdentityProviderResourceId);

            // invoke the operation
            ApiManagementIdentityProviderResource result = await apiManagementIdentityProvider.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ApiManagementIdentityProviderData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ApiManagementUpdateIdentityProvider
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_ApiManagementUpdateIdentityProvider()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementUpdateIdentityProvider.json
            // this example is just showing the usage of "IdentityProvider_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApiManagementIdentityProviderResource created on azure
            // for more information of creating ApiManagementIdentityProviderResource, please refer to the document of ApiManagementIdentityProviderResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            IdentityProviderType identityProviderName = IdentityProviderType.Facebook;
            ResourceIdentifier apiManagementIdentityProviderResourceId = ApiManagementIdentityProviderResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, identityProviderName);
            ApiManagementIdentityProviderResource apiManagementIdentityProvider = client.GetApiManagementIdentityProviderResource(apiManagementIdentityProviderResourceId);

            // invoke the operation
            ETag ifMatch = new ETag("*");
            ApiManagementIdentityProviderPatch patch = new ApiManagementIdentityProviderPatch()
            {
                ClientId = "updatedfacebookid",
                ClientSecret = "updatedfacebooksecret",
            };
            ApiManagementIdentityProviderResource result = await apiManagementIdentityProvider.UpdateAsync(ifMatch, patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ApiManagementIdentityProviderData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ApiManagementDeleteIdentityProvider
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_ApiManagementDeleteIdentityProvider()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementDeleteIdentityProvider.json
            // this example is just showing the usage of "IdentityProvider_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApiManagementIdentityProviderResource created on azure
            // for more information of creating ApiManagementIdentityProviderResource, please refer to the document of ApiManagementIdentityProviderResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            IdentityProviderType identityProviderName = IdentityProviderType.Aad;
            ResourceIdentifier apiManagementIdentityProviderResourceId = ApiManagementIdentityProviderResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, identityProviderName);
            ApiManagementIdentityProviderResource apiManagementIdentityProvider = client.GetApiManagementIdentityProviderResource(apiManagementIdentityProviderResourceId);

            // invoke the operation
            ETag ifMatch = new ETag("*");
            await apiManagementIdentityProvider.DeleteAsync(WaitUntil.Completed, ifMatch);

            Console.WriteLine($"Succeeded");
        }

        // ApiManagementIdentityProviderListSecrets
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetSecrets_ApiManagementIdentityProviderListSecrets()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementIdentityProviderListSecrets.json
            // this example is just showing the usage of "IdentityProvider_ListSecrets" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApiManagementIdentityProviderResource created on azure
            // for more information of creating ApiManagementIdentityProviderResource, please refer to the document of ApiManagementIdentityProviderResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            IdentityProviderType identityProviderName = IdentityProviderType.AadB2C;
            ResourceIdentifier apiManagementIdentityProviderResourceId = ApiManagementIdentityProviderResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, identityProviderName);
            ApiManagementIdentityProviderResource apiManagementIdentityProvider = client.GetApiManagementIdentityProviderResource(apiManagementIdentityProviderResourceId);

            // invoke the operation
            ClientSecretContract result = await apiManagementIdentityProvider.GetSecretsAsync();

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
