// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.ApiManagement.Samples
{
    public partial class Sample_ApiManagementGatewayCertificateAuthorityResource
    {
        // ApiManagementHeadGatewayCertificateAuthority
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetEntityTag_ApiManagementHeadGatewayCertificateAuthority()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementHeadGatewayCertificateAuthority.json
            // this example is just showing the usage of "GatewayCertificateAuthority_GetEntityTag" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApiManagementGatewayCertificateAuthorityResource created on azure
            // for more information of creating ApiManagementGatewayCertificateAuthorityResource, please refer to the document of ApiManagementGatewayCertificateAuthorityResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string gatewayId = "gw1";
            string certificateId = "cert1";
            ResourceIdentifier apiManagementGatewayCertificateAuthorityResourceId = ApiManagementGatewayCertificateAuthorityResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, gatewayId, certificateId);
            ApiManagementGatewayCertificateAuthorityResource apiManagementGatewayCertificateAuthority = client.GetApiManagementGatewayCertificateAuthorityResource(apiManagementGatewayCertificateAuthorityResourceId);

            // invoke the operation
            bool result = await apiManagementGatewayCertificateAuthority.GetEntityTagAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // ApiManagementGetGatewayCertificateAuthority
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_ApiManagementGetGatewayCertificateAuthority()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementGetGatewayCertificateAuthority.json
            // this example is just showing the usage of "GatewayCertificateAuthority_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApiManagementGatewayCertificateAuthorityResource created on azure
            // for more information of creating ApiManagementGatewayCertificateAuthorityResource, please refer to the document of ApiManagementGatewayCertificateAuthorityResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string gatewayId = "gw1";
            string certificateId = "cert1";
            ResourceIdentifier apiManagementGatewayCertificateAuthorityResourceId = ApiManagementGatewayCertificateAuthorityResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, gatewayId, certificateId);
            ApiManagementGatewayCertificateAuthorityResource apiManagementGatewayCertificateAuthority = client.GetApiManagementGatewayCertificateAuthorityResource(apiManagementGatewayCertificateAuthorityResourceId);

            // invoke the operation
            ApiManagementGatewayCertificateAuthorityResource result = await apiManagementGatewayCertificateAuthority.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ApiManagementGatewayCertificateAuthorityData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ApiManagementCreateGatewayCertificateAuthority
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_ApiManagementCreateGatewayCertificateAuthority()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementCreateGatewayCertificateAuthority.json
            // this example is just showing the usage of "GatewayCertificateAuthority_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApiManagementGatewayCertificateAuthorityResource created on azure
            // for more information of creating ApiManagementGatewayCertificateAuthorityResource, please refer to the document of ApiManagementGatewayCertificateAuthorityResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string gatewayId = "gw1";
            string certificateId = "cert1";
            ResourceIdentifier apiManagementGatewayCertificateAuthorityResourceId = ApiManagementGatewayCertificateAuthorityResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, gatewayId, certificateId);
            ApiManagementGatewayCertificateAuthorityResource apiManagementGatewayCertificateAuthority = client.GetApiManagementGatewayCertificateAuthorityResource(apiManagementGatewayCertificateAuthorityResourceId);

            // invoke the operation
            ApiManagementGatewayCertificateAuthorityData data = new ApiManagementGatewayCertificateAuthorityData()
            {
                IsTrusted = false,
            };
            ArmOperation<ApiManagementGatewayCertificateAuthorityResource> lro = await apiManagementGatewayCertificateAuthority.UpdateAsync(WaitUntil.Completed, data);
            ApiManagementGatewayCertificateAuthorityResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ApiManagementGatewayCertificateAuthorityData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // ApiManagementDeleteGatewayCertificateAuthority
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_ApiManagementDeleteGatewayCertificateAuthority()
        {
            // Generated from example definition: specification/apimanagement/resource-manager/Microsoft.ApiManagement/preview/2023-03-01-preview/examples/ApiManagementDeleteGatewayCertificateAuthority.json
            // this example is just showing the usage of "GatewayCertificateAuthority_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ApiManagementGatewayCertificateAuthorityResource created on azure
            // for more information of creating ApiManagementGatewayCertificateAuthorityResource, please refer to the document of ApiManagementGatewayCertificateAuthorityResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "rg1";
            string serviceName = "apimService1";
            string gatewayId = "gw1";
            string certificateId = "default";
            ResourceIdentifier apiManagementGatewayCertificateAuthorityResourceId = ApiManagementGatewayCertificateAuthorityResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serviceName, gatewayId, certificateId);
            ApiManagementGatewayCertificateAuthorityResource apiManagementGatewayCertificateAuthority = client.GetApiManagementGatewayCertificateAuthorityResource(apiManagementGatewayCertificateAuthorityResourceId);

            // invoke the operation
            ETag ifMatch = new ETag("*");
            await apiManagementGatewayCertificateAuthority.DeleteAsync(WaitUntil.Completed, ifMatch);

            Console.WriteLine($"Succeeded");
        }
    }
}
