﻿// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

using System;
using System.Collections.Generic;
using System.Globalization;
using Azure.AI.AnomalyDetector;

namespace Azure.AI.AnomalyDetector.Tests.Infrastructure
{
    internal static class TestData
    {
        public static UnivariateDetectionOptions TestPointSeries = new UnivariateDetectionOptions(
            new List<TimeSeriesPoint>{
                new TimeSeriesPoint(826){ Timestamp = DateTime.Parse("1972-01-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(799){ Timestamp = DateTime.Parse("1972-02-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(890){ Timestamp = DateTime.Parse("1972-03-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(900){ Timestamp = DateTime.Parse("1972-04-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(961){ Timestamp = DateTime.Parse("1972-05-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(935){ Timestamp = DateTime.Parse("1972-06-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(894){ Timestamp = DateTime.Parse("1972-07-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(855){ Timestamp = DateTime.Parse("1972-08-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(809){ Timestamp = DateTime.Parse("1972-09-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(810){ Timestamp = DateTime.Parse("1972-10-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(766){ Timestamp = DateTime.Parse("1972-11-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(805){ Timestamp = DateTime.Parse("1972-12-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(821){ Timestamp = DateTime.Parse("1973-01-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(773){ Timestamp = DateTime.Parse("1973-02-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(883){ Timestamp = DateTime.Parse("1973-03-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(898){ Timestamp = DateTime.Parse("1973-04-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(957){ Timestamp = DateTime.Parse("1973-05-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(924){ Timestamp = DateTime.Parse("1973-06-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(881){ Timestamp = DateTime.Parse("1973-07-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(837){ Timestamp = DateTime.Parse("1973-08-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(784){ Timestamp = DateTime.Parse("1973-09-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(791){ Timestamp = DateTime.Parse("1973-10-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(760){ Timestamp = DateTime.Parse("1973-11-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(802){ Timestamp = DateTime.Parse("1973-12-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(828){ Timestamp = DateTime.Parse("1974-01-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(1030){ Timestamp = DateTime.Parse("1974-02-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(889){ Timestamp = DateTime.Parse("1974-03-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(902){ Timestamp = DateTime.Parse("1974-04-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(969){ Timestamp = DateTime.Parse("1974-05-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(947){ Timestamp = DateTime.Parse("1974-06-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(908){ Timestamp = DateTime.Parse("1974-07-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(867){ Timestamp = DateTime.Parse("1974-08-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(815){ Timestamp = DateTime.Parse("1974-09-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(812){ Timestamp = DateTime.Parse("1974-10-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(773){ Timestamp = DateTime.Parse("1974-11-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(813){ Timestamp = DateTime.Parse("1974-12-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(834){ Timestamp = DateTime.Parse("1975-01-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(782){ Timestamp = DateTime.Parse("1975-02-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(892){ Timestamp = DateTime.Parse("1975-03-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(903){ Timestamp = DateTime.Parse("1975-04-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(966){ Timestamp = DateTime.Parse("1975-05-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(937){ Timestamp = DateTime.Parse("1975-06-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(896){ Timestamp = DateTime.Parse("1975-07-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(858){ Timestamp = DateTime.Parse("1975-08-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(817){ Timestamp = DateTime.Parse("1975-09-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(827){ Timestamp = DateTime.Parse("1975-10-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(797){ Timestamp = DateTime.Parse("1975-11-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
                new TimeSeriesPoint(843){ Timestamp = DateTime.Parse("1975-12-01T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)}
            })
        {
            Granularity = TimeGranularity.Monthly
        };

        public static UnivariateChangePointDetectionOptions TestChangePointSeries = new UnivariateChangePointDetectionOptions(
            new List<TimeSeriesPoint>{
               new TimeSeriesPoint(1639196){ Timestamp = DateTime.Parse("2017-01-01T06:45:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1639290){ Timestamp = DateTime.Parse("2017-01-01T06:50:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1667293){ Timestamp = DateTime.Parse("2017-01-01T06:55:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1703130){ Timestamp = DateTime.Parse("2017-01-01T07:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1650912){ Timestamp = DateTime.Parse("2017-01-01T07:05:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1653596){ Timestamp = DateTime.Parse("2017-01-01T07:10:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1653793){ Timestamp = DateTime.Parse("2017-01-01T07:15:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1653795){ Timestamp = DateTime.Parse("2017-01-01T07:20:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1663471){ Timestamp = DateTime.Parse("2017-01-01T07:25:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1662358){ Timestamp = DateTime.Parse("2017-01-01T07:30:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1664320){ Timestamp = DateTime.Parse("2017-01-01T07:35:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1664942){ Timestamp = DateTime.Parse("2017-01-01T07:40:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1664966){ Timestamp = DateTime.Parse("2017-01-01T07:45:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1724271){ Timestamp = DateTime.Parse("2017-01-01T07:50:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1678720){ Timestamp = DateTime.Parse("2017-01-01T07:55:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1672536){ Timestamp = DateTime.Parse("2017-01-01T08:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1672544){ Timestamp = DateTime.Parse("2017-01-01T08:05:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1672364){ Timestamp = DateTime.Parse("2017-01-01T08:10:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1672912){ Timestamp = DateTime.Parse("2017-01-01T08:15:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1672736){ Timestamp = DateTime.Parse("2017-01-01T08:20:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1672725){ Timestamp = DateTime.Parse("2017-01-01T08:25:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1673247){ Timestamp = DateTime.Parse("2017-01-01T08:30:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1673109){ Timestamp = DateTime.Parse("2017-01-01T08:35:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1690088){ Timestamp = DateTime.Parse("2017-01-01T08:40:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1703865){ Timestamp = DateTime.Parse("2017-01-01T08:45:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1703865){ Timestamp = DateTime.Parse("2017-01-01T08:50:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1786581){ Timestamp = DateTime.Parse("2017-01-01T08:55:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1800945){ Timestamp = DateTime.Parse("2017-01-01T09:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1800957){ Timestamp = DateTime.Parse("2017-01-01T09:05:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1801191){ Timestamp = DateTime.Parse("2017-01-01T09:10:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1801412){ Timestamp = DateTime.Parse("2017-01-01T09:15:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1801621){ Timestamp = DateTime.Parse("2017-01-01T09:20:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1801621){ Timestamp = DateTime.Parse("2017-01-01T09:25:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1801654){ Timestamp = DateTime.Parse("2017-01-01T09:30:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1802105){ Timestamp = DateTime.Parse("2017-01-01T09:35:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1801800){ Timestamp = DateTime.Parse("2017-01-01T09:40:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1803040){ Timestamp = DateTime.Parse("2017-01-01T09:45:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1803672){ Timestamp = DateTime.Parse("2017-01-01T09:50:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1803535){ Timestamp = DateTime.Parse("2017-01-01T09:55:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1803541){ Timestamp = DateTime.Parse("2017-01-01T10:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1803545){ Timestamp = DateTime.Parse("2017-01-01T10:05:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1803599){ Timestamp = DateTime.Parse("2017-01-01T10:10:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1803616){ Timestamp = DateTime.Parse("2017-01-01T10:15:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1803619){ Timestamp = DateTime.Parse("2017-01-01T10:20:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1809942){ Timestamp = DateTime.Parse("2017-01-01T10:25:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1802720){ Timestamp = DateTime.Parse("2017-01-01T10:30:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1802720){ Timestamp = DateTime.Parse("2017-01-01T10:35:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1802888){ Timestamp = DateTime.Parse("2017-01-01T10:40:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1809574){ Timestamp = DateTime.Parse("2017-01-01T10:45:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1803896){ Timestamp = DateTime.Parse("2017-01-01T10:50:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1803850){ Timestamp = DateTime.Parse("2017-01-01T10:55:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1803854){ Timestamp = DateTime.Parse("2017-01-01T11:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1803854){ Timestamp = DateTime.Parse("2017-01-01T11:05:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1803797){ Timestamp = DateTime.Parse("2017-01-01T11:10:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1803921){ Timestamp = DateTime.Parse("2017-01-01T11:15:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1803933){ Timestamp = DateTime.Parse("2017-01-01T11:20:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1804040){ Timestamp = DateTime.Parse("2017-01-01T11:25:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1804044){ Timestamp = DateTime.Parse("2017-01-01T11:30:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1804070){ Timestamp = DateTime.Parse("2017-01-01T11:35:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1804070){ Timestamp = DateTime.Parse("2017-01-01T11:40:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1804068){ Timestamp = DateTime.Parse("2017-01-01T11:45:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1804073){ Timestamp = DateTime.Parse("2017-01-01T11:50:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1804101){ Timestamp = DateTime.Parse("2017-01-01T11:55:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1804674){ Timestamp = DateTime.Parse("2017-01-01T12:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1804714){ Timestamp = DateTime.Parse("2017-01-01T12:05:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1804730){ Timestamp = DateTime.Parse("2017-01-01T12:10:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1804816){ Timestamp = DateTime.Parse("2017-01-01T12:15:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1803996){ Timestamp = DateTime.Parse("2017-01-01T12:20:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1803998){ Timestamp = DateTime.Parse("2017-01-01T12:25:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1804015){ Timestamp = DateTime.Parse("2017-01-01T12:30:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1804047){ Timestamp = DateTime.Parse("2017-01-01T12:35:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1804050){ Timestamp = DateTime.Parse("2017-01-01T12:40:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1804218){ Timestamp = DateTime.Parse("2017-01-01T12:45:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1804217){ Timestamp = DateTime.Parse("2017-01-01T12:50:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1804217){ Timestamp = DateTime.Parse("2017-01-01T12:55:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1804205){ Timestamp = DateTime.Parse("2017-01-01T13:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1804728){ Timestamp = DateTime.Parse("2017-01-01T13:05:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1804748){ Timestamp = DateTime.Parse("2017-01-01T13:10:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1805232){ Timestamp = DateTime.Parse("2017-01-01T13:15:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1814121){ Timestamp = DateTime.Parse("2017-01-01T13:20:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1806789){ Timestamp = DateTime.Parse("2017-01-01T13:25:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1806119){ Timestamp = DateTime.Parse("2017-01-01T13:30:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1806329){ Timestamp = DateTime.Parse("2017-01-01T13:35:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1806454){ Timestamp = DateTime.Parse("2017-01-01T13:40:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1806852){ Timestamp = DateTime.Parse("2017-01-01T13:45:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1807347){ Timestamp = DateTime.Parse("2017-01-01T13:50:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1812144){ Timestamp = DateTime.Parse("2017-01-01T13:55:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1807418){ Timestamp = DateTime.Parse("2017-01-01T14:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1807418){ Timestamp = DateTime.Parse("2017-01-01T14:05:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1807432){ Timestamp = DateTime.Parse("2017-01-01T14:10:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1808540){ Timestamp = DateTime.Parse("2017-01-01T14:15:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1808541){ Timestamp = DateTime.Parse("2017-01-01T14:20:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1807831){ Timestamp = DateTime.Parse("2017-01-01T14:25:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1807852){ Timestamp = DateTime.Parse("2017-01-01T14:30:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1807811){ Timestamp = DateTime.Parse("2017-01-01T14:35:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2214285){ Timestamp = DateTime.Parse("2017-01-01T14:40:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2215019){ Timestamp = DateTime.Parse("2017-01-01T14:45:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2215329){ Timestamp = DateTime.Parse("2017-01-01T14:50:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2215097){ Timestamp = DateTime.Parse("2017-01-01T14:55:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2215129){ Timestamp = DateTime.Parse("2017-01-01T15:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2215120){ Timestamp = DateTime.Parse("2017-01-01T15:05:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2217056){ Timestamp = DateTime.Parse("2017-01-01T15:10:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2217056){ Timestamp = DateTime.Parse("2017-01-01T15:15:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2222126){ Timestamp = DateTime.Parse("2017-01-01T15:20:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2226472){ Timestamp = DateTime.Parse("2017-01-01T15:25:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2226722){ Timestamp = DateTime.Parse("2017-01-01T15:30:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2226729){ Timestamp = DateTime.Parse("2017-01-01T15:35:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2226735){ Timestamp = DateTime.Parse("2017-01-01T15:40:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2226735){ Timestamp = DateTime.Parse("2017-01-01T15:45:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2226735){ Timestamp = DateTime.Parse("2017-01-01T15:50:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2226952){ Timestamp = DateTime.Parse("2017-01-01T15:55:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2226962){ Timestamp = DateTime.Parse("2017-01-01T16:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2649337){ Timestamp = DateTime.Parse("2017-01-01T16:05:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2092796){ Timestamp = DateTime.Parse("2017-01-01T16:10:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2092839){ Timestamp = DateTime.Parse("2017-01-01T16:15:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2092940){ Timestamp = DateTime.Parse("2017-01-01T16:20:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2092940){ Timestamp = DateTime.Parse("2017-01-01T16:25:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2092965){ Timestamp = DateTime.Parse("2017-01-01T16:30:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2092979){ Timestamp = DateTime.Parse("2017-01-01T16:35:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2095588){ Timestamp = DateTime.Parse("2017-01-01T16:40:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2099586){ Timestamp = DateTime.Parse("2017-01-01T16:45:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2102981){ Timestamp = DateTime.Parse("2017-01-01T16:50:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2108053){ Timestamp = DateTime.Parse("2017-01-01T16:55:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2107907){ Timestamp = DateTime.Parse("2017-01-01T17:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2108241){ Timestamp = DateTime.Parse("2017-01-01T17:05:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2100321){ Timestamp = DateTime.Parse("2017-01-01T17:10:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2100448){ Timestamp = DateTime.Parse("2017-01-01T17:15:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2100483){ Timestamp = DateTime.Parse("2017-01-01T17:20:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2103042){ Timestamp = DateTime.Parse("2017-01-01T17:25:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2103037){ Timestamp = DateTime.Parse("2017-01-01T17:30:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2103040){ Timestamp = DateTime.Parse("2017-01-01T17:35:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2103054){ Timestamp = DateTime.Parse("2017-01-01T17:40:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2103058){ Timestamp = DateTime.Parse("2017-01-01T17:45:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1830757){ Timestamp = DateTime.Parse("2017-01-01T17:50:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1830855){ Timestamp = DateTime.Parse("2017-01-01T17:55:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1831495){ Timestamp = DateTime.Parse("2017-01-01T18:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1831463){ Timestamp = DateTime.Parse("2017-01-01T18:05:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1831963){ Timestamp = DateTime.Parse("2017-01-01T18:10:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1832046){ Timestamp = DateTime.Parse("2017-01-01T18:15:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1832070){ Timestamp = DateTime.Parse("2017-01-01T18:20:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1835511){ Timestamp = DateTime.Parse("2017-01-01T18:25:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1835265){ Timestamp = DateTime.Parse("2017-01-01T18:30:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1835481){ Timestamp = DateTime.Parse("2017-01-01T18:35:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1835578){ Timestamp = DateTime.Parse("2017-01-01T18:40:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1835611){ Timestamp = DateTime.Parse("2017-01-01T18:45:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1836314){ Timestamp = DateTime.Parse("2017-01-01T18:50:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1836369){ Timestamp = DateTime.Parse("2017-01-01T18:55:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1837280){ Timestamp = DateTime.Parse("2017-01-01T19:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1842939){ Timestamp = DateTime.Parse("2017-01-01T19:05:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1843126){ Timestamp = DateTime.Parse("2017-01-01T19:10:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1845840){ Timestamp = DateTime.Parse("2017-01-01T19:15:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1842444){ Timestamp = DateTime.Parse("2017-01-01T19:20:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1839891){ Timestamp = DateTime.Parse("2017-01-01T19:25:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1839875){ Timestamp = DateTime.Parse("2017-01-01T19:30:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1839870){ Timestamp = DateTime.Parse("2017-01-01T19:35:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1840090){ Timestamp = DateTime.Parse("2017-01-01T19:40:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1840479){ Timestamp = DateTime.Parse("2017-01-01T19:45:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1840479){ Timestamp = DateTime.Parse("2017-01-01T19:50:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1840482){ Timestamp = DateTime.Parse("2017-01-01T19:55:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1841522){ Timestamp = DateTime.Parse("2017-01-01T20:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1841836){ Timestamp = DateTime.Parse("2017-01-01T20:05:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1842377){ Timestamp = DateTime.Parse("2017-01-01T20:10:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1842388){ Timestamp = DateTime.Parse("2017-01-01T20:15:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1842489){ Timestamp = DateTime.Parse("2017-01-01T20:20:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1842489){ Timestamp = DateTime.Parse("2017-01-01T20:25:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1842489){ Timestamp = DateTime.Parse("2017-01-01T20:30:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1842496){ Timestamp = DateTime.Parse("2017-01-01T20:35:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1842689){ Timestamp = DateTime.Parse("2017-01-01T20:40:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1843117){ Timestamp = DateTime.Parse("2017-01-01T20:45:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1843116){ Timestamp = DateTime.Parse("2017-01-01T20:50:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1843227){ Timestamp = DateTime.Parse("2017-01-01T20:55:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1843138){ Timestamp = DateTime.Parse("2017-01-01T21:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1843141){ Timestamp = DateTime.Parse("2017-01-01T21:05:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1843310){ Timestamp = DateTime.Parse("2017-01-01T21:10:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1843310){ Timestamp = DateTime.Parse("2017-01-01T21:15:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1843507){ Timestamp = DateTime.Parse("2017-01-01T21:20:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1843953){ Timestamp = DateTime.Parse("2017-01-01T21:25:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1844778){ Timestamp = DateTime.Parse("2017-01-01T21:30:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1843918){ Timestamp = DateTime.Parse("2017-01-01T21:35:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1882692){ Timestamp = DateTime.Parse("2017-01-01T21:40:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(1974888){ Timestamp = DateTime.Parse("2017-01-01T21:45:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2157136){ Timestamp = DateTime.Parse("2017-01-01T21:50:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2154987){ Timestamp = DateTime.Parse("2017-01-01T21:55:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2155664){ Timestamp = DateTime.Parse("2017-01-01T22:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2155660){ Timestamp = DateTime.Parse("2017-01-01T22:05:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2155824){ Timestamp = DateTime.Parse("2017-01-01T22:10:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2155824){ Timestamp = DateTime.Parse("2017-01-01T22:15:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2156329){ Timestamp = DateTime.Parse("2017-01-01T22:20:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2156479){ Timestamp = DateTime.Parse("2017-01-01T22:25:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2165269){ Timestamp = DateTime.Parse("2017-01-01T22:30:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2165433){ Timestamp = DateTime.Parse("2017-01-01T22:35:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2165739){ Timestamp = DateTime.Parse("2017-01-01T22:40:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2165931){ Timestamp = DateTime.Parse("2017-01-01T22:45:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2165928){ Timestamp = DateTime.Parse("2017-01-01T22:50:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2165989){ Timestamp = DateTime.Parse("2017-01-01T22:55:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2228961){ Timestamp = DateTime.Parse("2017-01-01T23:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2228961){ Timestamp = DateTime.Parse("2017-01-01T23:05:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2228961){ Timestamp = DateTime.Parse("2017-01-01T23:10:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2485802){ Timestamp = DateTime.Parse("2017-01-01T23:15:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2485802){ Timestamp = DateTime.Parse("2017-01-01T23:20:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2486021){ Timestamp = DateTime.Parse("2017-01-01T23:25:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2485293){ Timestamp = DateTime.Parse("2017-01-01T23:30:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2485293){ Timestamp = DateTime.Parse("2017-01-01T23:35:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2485324){ Timestamp = DateTime.Parse("2017-01-01T23:40:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2489142){ Timestamp = DateTime.Parse("2017-01-01T23:45:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2526312){ Timestamp = DateTime.Parse("2017-01-01T23:50:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2526313){ Timestamp = DateTime.Parse("2017-01-01T23:55:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2526314){ Timestamp = DateTime.Parse("2017-01-02T00:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2526324){ Timestamp = DateTime.Parse("2017-01-02T00:05:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2526325){ Timestamp = DateTime.Parse("2017-01-02T00:10:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2526205){ Timestamp = DateTime.Parse("2017-01-02T00:15:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2526226){ Timestamp = DateTime.Parse("2017-01-02T00:20:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2526475){ Timestamp = DateTime.Parse("2017-01-02T00:25:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2526471){ Timestamp = DateTime.Parse("2017-01-02T00:30:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2526471){ Timestamp = DateTime.Parse("2017-01-02T00:35:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2526534){ Timestamp = DateTime.Parse("2017-01-02T00:40:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2526646){ Timestamp = DateTime.Parse("2017-01-02T00:45:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2526646){ Timestamp = DateTime.Parse("2017-01-02T00:50:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2526648){ Timestamp = DateTime.Parse("2017-01-02T00:55:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2526658){ Timestamp = DateTime.Parse("2017-01-02T01:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2526771){ Timestamp = DateTime.Parse("2017-01-02T01:05:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2526773){ Timestamp = DateTime.Parse("2017-01-02T01:10:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2526793){ Timestamp = DateTime.Parse("2017-01-02T01:15:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2527010){ Timestamp = DateTime.Parse("2017-01-02T01:20:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(2527031){ Timestamp = DateTime.Parse("2017-01-02T01:25:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(3178096){ Timestamp = DateTime.Parse("2017-01-02T01:30:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(3196305){ Timestamp = DateTime.Parse("2017-01-02T01:35:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(3196202){ Timestamp = DateTime.Parse("2017-01-02T01:40:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(3196202){ Timestamp = DateTime.Parse("2017-01-02T01:45:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(3196205){ Timestamp = DateTime.Parse("2017-01-02T01:50:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(3229232){ Timestamp = DateTime.Parse("2017-01-02T01:55:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(3230463){ Timestamp = DateTime.Parse("2017-01-02T02:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(3230468){ Timestamp = DateTime.Parse("2017-01-02T02:05:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(3230468){ Timestamp = DateTime.Parse("2017-01-02T02:10:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(3230468){ Timestamp = DateTime.Parse("2017-01-02T02:15:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(3230470){ Timestamp = DateTime.Parse("2017-01-02T02:20:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(3230467){ Timestamp = DateTime.Parse("2017-01-02T02:25:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(3230506){ Timestamp = DateTime.Parse("2017-01-02T02:30:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(3231536){ Timestamp = DateTime.Parse("2017-01-02T02:35:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(3230723){ Timestamp = DateTime.Parse("2017-01-02T02:40:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(3230727){ Timestamp = DateTime.Parse("2017-01-02T02:45:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(3230727){ Timestamp = DateTime.Parse("2017-01-02T02:50:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(3230727){ Timestamp = DateTime.Parse("2017-01-02T02:55:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(3231880){ Timestamp = DateTime.Parse("2017-01-02T03:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(3232283){ Timestamp = DateTime.Parse("2017-01-02T03:05:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(3232283){ Timestamp = DateTime.Parse("2017-01-02T03:10:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(3232283){ Timestamp = DateTime.Parse("2017-01-02T03:15:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(3232325){ Timestamp = DateTime.Parse("2017-01-02T03:20:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(3232323){ Timestamp = DateTime.Parse("2017-01-02T03:25:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(3232327){ Timestamp = DateTime.Parse("2017-01-02T03:30:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(3232340){ Timestamp = DateTime.Parse("2017-01-02T03:35:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(3232713){ Timestamp = DateTime.Parse("2017-01-02T03:40:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(3232729){ Timestamp = DateTime.Parse("2017-01-02T03:45:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(3232756){ Timestamp = DateTime.Parse("2017-01-02T03:50:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(3233500){ Timestamp = DateTime.Parse("2017-01-02T03:55:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(3233500){ Timestamp = DateTime.Parse("2017-01-02T04:00:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
               new TimeSeriesPoint(3233500){ Timestamp = DateTime.Parse("2017-01-02T04:05:00Z", CultureInfo.InvariantCulture, DateTimeStyles.RoundtripKind)},
            },
            TimeGranularity.PerMinute);

        public static UnivariateChangePointDetectionResult ExpectedChangePointResult = AIAnomalyDetectorModelFactory.UnivariateChangePointDetectionResult(
            0,
            new List<bool>
            {
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                true,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false,
                false
            },
            new List<float>
            {
                0F,
                2.920781E-16F,
                0.002917574F,
                0.004975212F,
                0.0166258123F,
                0.009722051F,
                0.006512067F,
                0.004530033F,
                0.000579451735F,
                0.000516144268F,
                5.97296821E-05F,
                0.000127625826F,
                0.000534147432F,
                0.0267906059F,
                0.00258630631F,
                0.00618410157F,
                0.00591934472F,
                0.005767946F,
                0.005247969F,
                0.00516934926F,
                0.00499718124F,
                0.00455702841F,
                0.0045186067F,
                0.00458317669F,
                0.0105929933F,
                0.008313608F,
                0.0509395376F,
                0.0506007932F,
                0.0423676446F,
                0.0352095962F,
                0.0288537331F,
                0.0231949631F,
                0.0180345979F,
                0.0134433722F,
                0.009567125F,
                0.005666109F,
                0.003030563F,
                0.000314924255F,
                0.00256776228F,
                0.005088542F,
                0.007367402F,
                0.00940016F,
                0.0112614566F,
                0.0129558193F,
                0.0108687291F,
                0.0167279541F,
                0.0179328732F,
                0.0189283453F,
                0.0160649624F,
                0.0205642581F,
                0.0214418378F,
                0.022209242F,
                0.0229071435F,
                0.02357251F,
                0.0240699816F,
                0.0245831367F,
                0.0249908268F,
                0.0254167709F,
                0.0257873144F,
                0.0261349175F,
                0.0264476333F,
                0.0267229974F,
                0.0269545F,
                0.02683794F,
                0.0270300861F,
                0.0272127837F,
                0.0273315273F,
                0.027967358F,
                0.0280692019F,
                0.0281451717F,
                0.02819705F,
                0.0282525755F,
                0.0281967223F,
                0.0282340553F,
                0.0282589346F,
                0.02828001F,
                0.0279721227F,
                0.0279702712F,
                0.027683083F,
                0.0223882645F,
                0.0270244945F,
                0.02745224F,
                0.0273260232F,
                0.027248878F,
                0.0270045269F,
                0.026706066F,
                0.0238377079F,
                0.026797656F,
                0.0267868F,
                0.0267614815F,
                0.0260743424F,
                0.0260751471F,
                0.02649704F,
                0.0264560226F,
                0.0264481828F,
                0.218084767F,
                0.208482787F,
                0.198968545F,
                0.189466342F,
                0.18046011F,
                0.171745583F,
                0.16450794F,
                0.156348765F,
                0.151529789F,
                0.146427512F,
                0.1390157F,
                0.131706253F,
                0.124640815F,
                0.11780671F,
                0.11119847F,
                0.104938544F,
                0.0987573862F,
                0.348443717F,
                0.003315012F,
                0.00587439351F,
                0.008310645F,
                0.010724673F,
                0.0130412178F,
                0.0152857127F,
                0.0158801265F,
                0.0156102013F,
                0.01571291F,
                0.01479218F,
                0.017067479F,
                0.0189771149F,
                0.0258392375F,
                0.02759435F,
                0.0293478351F,
                0.02950946F,
                0.0312220138F,
                0.03287439F,
                0.0344668254F,
                0.0360141173F,
                0.2032686F,
                0.1997489F,
                0.195980087F,
                0.192708686F,
                0.189186886F,
                0.186000019F,
                0.182920352F,
                0.177825749F,
                0.175103784F,
                0.1721584F,
                0.169350088F,
                0.1666415F,
                0.163581982F,
                0.160985336F,
                0.157921016F,
                0.152025044F,
                0.149612918F,
                0.145707592F,
                0.145624012F,
                0.145015165F,
                0.142859474F,
                0.14074035F,
                0.138526F,
                0.136253029F,
                0.1342641F,
                0.132312343F,
                0.129764318F,
                0.127713218F,
                0.125563726F,
                0.123781465F,
                0.121978037F,
                0.120270856F,
                0.118595764F,
                0.1169477F,
                0.115216374F,
                0.113373704F,
                0.111829013F,
                0.110243924F,
                0.108810514F,
                0.107346348F,
                0.10580676F,
                0.104398787F,
                0.102895066F,
                0.101265818F,
                0.0994341F,
                0.098670274F,
                0.07360533F,
                0.0163116362F,
                0.09498651F,
                0.09071371F,
                0.0882620439F,
                0.0854398459F,
                0.08277607F,
                0.080063425F,
                0.0777136F,
                0.0751908F,
                0.07802264F,
                0.07549329F,
                0.07309938F,
                0.07068077F,
                0.06818809F,
                0.06578192F,
                0.102081746F,
                0.0989426747F,
                0.0958615243F,
                0.250722259F,
                0.244595245F,
                0.238711834F,
                0.232350126F,
                0.226549312F,
                0.220869645F,
                0.217618838F,
                0.234936729F,
                0.2290451F,
                0.223255411F,
                0.21757111F,
                0.211978942F,
                0.2064081F,
                0.201019272F,
                0.195862457F,
                0.1906371F,
                0.185502529F,
                0.180493265F,
                0.175598234F,
                0.170716092F,
                0.165916651F,
                0.161201984F,
                0.156628951F,
                0.152063042F,
                0.1475835F,
                0.143298924F,
                0.13896361F,
                0.545466065F,
                0F,
                0.00191431493F,
                0.00227779639F,
                0.0022705833F,
                0.00770466076F,
                0.0020893577F,
                0.00169284944F,
                0.00401055533F,
                0.00545468F,
                0.00635580858F,
                0.00691194646F,
                0.007220237F,
                0.00691873766F,
                0.007509071F,
                0.007513988F,
                0.007470701F,
                0.00739258574F,
                0.00670840824F,
                0.0065024076F,
                0.006512731F,
                0.00649555726F,
                0.006435601F,
                0.00638686027F,
                0.00632262F,
                0.006244876F,
                0.00596736837F,
                0.005906344F,
                0.005833742F,
                0.005365143F,
                0.00535262655F,
                0.005331466F,
            });
    }
}
