// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.AnomalyDetector
{
    /// <summary> Variable status. </summary>
    public partial class VariableState
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="VariableState"/>. </summary>
        internal VariableState()
        {
        }

        /// <summary> Initializes a new instance of <see cref="VariableState"/>. </summary>
        /// <param name="variable"> Variable name in variable states. </param>
        /// <param name="filledNARatio"> Proportion of missing values that need to be filled by fillNAMethod. </param>
        /// <param name="effectiveCount"> Number of effective data points before fillNAMethod is applied. </param>
        /// <param name="firstTimestamp"> First valid time stamp with a value of input data. </param>
        /// <param name="lastTimestamp"> Last valid time stamp with a value of input data. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal VariableState(string variable, float? filledNARatio, int? effectiveCount, DateTimeOffset? firstTimestamp, DateTimeOffset? lastTimestamp, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Variable = variable;
            FilledNARatio = filledNARatio;
            EffectiveCount = effectiveCount;
            FirstTimestamp = firstTimestamp;
            LastTimestamp = lastTimestamp;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Variable name in variable states. </summary>
        public string Variable { get; }
        /// <summary> Proportion of missing values that need to be filled by fillNAMethod. </summary>
        public float? FilledNARatio { get; }
        /// <summary> Number of effective data points before fillNAMethod is applied. </summary>
        public int? EffectiveCount { get; }
        /// <summary> First valid time stamp with a value of input data. </summary>
        public DateTimeOffset? FirstTimestamp { get; }
        /// <summary> Last valid time stamp with a value of input data. </summary>
        public DateTimeOffset? LastTimestamp { get; }
    }
}
