// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.AI.AnomalyDetector
{
    /// <summary> Response of the last anomaly detection. </summary>
    public partial class UnivariateLastDetectionResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="UnivariateLastDetectionResult"/>. </summary>
        /// <param name="period">
        /// Frequency extracted from the series. Zero means no recurrent pattern has been
        /// found.
        /// </param>
        /// <param name="suggestedWindow"> Suggested input series points needed for detecting the latest point. </param>
        /// <param name="expectedValue"> Expected value of the latest point. </param>
        /// <param name="upperMargin">
        /// Upper margin of the latest point. UpperMargin is used to calculate
        /// upperBoundary, which is equal to expectedValue + (100 - marginScale)*upperMargin.
        /// If the value of latest point is between upperBoundary and lowerBoundary, it
        /// should be treated as a normal value. Adjusting the marginScale value enables the anomaly
        /// status of the latest point to be changed.
        /// </param>
        /// <param name="lowerMargin">
        /// Lower margin of the latest point. LowerMargin is used to calculate
        /// lowerBoundary, which is equal to expectedValue - (100 - marginScale)*lowerMargin.
        /// </param>
        /// <param name="isAnomaly">
        /// Anomaly status of the latest point. True means the latest point is an anomaly,
        /// either in the negative direction or in the positive direction.
        /// </param>
        /// <param name="isNegativeAnomaly">
        /// Anomaly status of the latest point in a negative direction. True means the latest
        /// point is an anomaly and its real value is smaller than the expected one.
        /// </param>
        /// <param name="isPositiveAnomaly">
        /// Anomaly status of the latest point in a positive direction. True means the latest
        /// point is an anomaly and its real value is larger than the expected one.
        /// </param>
        internal UnivariateLastDetectionResult(int period, int suggestedWindow, float expectedValue, float upperMargin, float lowerMargin, bool isAnomaly, bool isNegativeAnomaly, bool isPositiveAnomaly)
        {
            Period = period;
            SuggestedWindow = suggestedWindow;
            ExpectedValue = expectedValue;
            UpperMargin = upperMargin;
            LowerMargin = lowerMargin;
            IsAnomaly = isAnomaly;
            IsNegativeAnomaly = isNegativeAnomaly;
            IsPositiveAnomaly = isPositiveAnomaly;
        }

        /// <summary> Initializes a new instance of <see cref="UnivariateLastDetectionResult"/>. </summary>
        /// <param name="period">
        /// Frequency extracted from the series. Zero means no recurrent pattern has been
        /// found.
        /// </param>
        /// <param name="suggestedWindow"> Suggested input series points needed for detecting the latest point. </param>
        /// <param name="expectedValue"> Expected value of the latest point. </param>
        /// <param name="upperMargin">
        /// Upper margin of the latest point. UpperMargin is used to calculate
        /// upperBoundary, which is equal to expectedValue + (100 - marginScale)*upperMargin.
        /// If the value of latest point is between upperBoundary and lowerBoundary, it
        /// should be treated as a normal value. Adjusting the marginScale value enables the anomaly
        /// status of the latest point to be changed.
        /// </param>
        /// <param name="lowerMargin">
        /// Lower margin of the latest point. LowerMargin is used to calculate
        /// lowerBoundary, which is equal to expectedValue - (100 - marginScale)*lowerMargin.
        /// </param>
        /// <param name="isAnomaly">
        /// Anomaly status of the latest point. True means the latest point is an anomaly,
        /// either in the negative direction or in the positive direction.
        /// </param>
        /// <param name="isNegativeAnomaly">
        /// Anomaly status of the latest point in a negative direction. True means the latest
        /// point is an anomaly and its real value is smaller than the expected one.
        /// </param>
        /// <param name="isPositiveAnomaly">
        /// Anomaly status of the latest point in a positive direction. True means the latest
        /// point is an anomaly and its real value is larger than the expected one.
        /// </param>
        /// <param name="severity">
        /// Severity score for the last input point. The larger the value is, the more
        /// severe the anomaly is. For normal points, the severity is always 0.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UnivariateLastDetectionResult(int period, int suggestedWindow, float expectedValue, float upperMargin, float lowerMargin, bool isAnomaly, bool isNegativeAnomaly, bool isPositiveAnomaly, float? severity, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Period = period;
            SuggestedWindow = suggestedWindow;
            ExpectedValue = expectedValue;
            UpperMargin = upperMargin;
            LowerMargin = lowerMargin;
            IsAnomaly = isAnomaly;
            IsNegativeAnomaly = isNegativeAnomaly;
            IsPositiveAnomaly = isPositiveAnomaly;
            Severity = severity;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="UnivariateLastDetectionResult"/> for deserialization. </summary>
        internal UnivariateLastDetectionResult()
        {
        }

        /// <summary>
        /// Frequency extracted from the series. Zero means no recurrent pattern has been
        /// found.
        /// </summary>
        public int Period { get; }
        /// <summary> Suggested input series points needed for detecting the latest point. </summary>
        public int SuggestedWindow { get; }
        /// <summary> Expected value of the latest point. </summary>
        public float ExpectedValue { get; }
        /// <summary>
        /// Upper margin of the latest point. UpperMargin is used to calculate
        /// upperBoundary, which is equal to expectedValue + (100 - marginScale)*upperMargin.
        /// If the value of latest point is between upperBoundary and lowerBoundary, it
        /// should be treated as a normal value. Adjusting the marginScale value enables the anomaly
        /// status of the latest point to be changed.
        /// </summary>
        public float UpperMargin { get; }
        /// <summary>
        /// Lower margin of the latest point. LowerMargin is used to calculate
        /// lowerBoundary, which is equal to expectedValue - (100 - marginScale)*lowerMargin.
        /// </summary>
        public float LowerMargin { get; }
        /// <summary>
        /// Anomaly status of the latest point. True means the latest point is an anomaly,
        /// either in the negative direction or in the positive direction.
        /// </summary>
        public bool IsAnomaly { get; }
        /// <summary>
        /// Anomaly status of the latest point in a negative direction. True means the latest
        /// point is an anomaly and its real value is smaller than the expected one.
        /// </summary>
        public bool IsNegativeAnomaly { get; }
        /// <summary>
        /// Anomaly status of the latest point in a positive direction. True means the latest
        /// point is an anomaly and its real value is larger than the expected one.
        /// </summary>
        public bool IsPositiveAnomaly { get; }
        /// <summary>
        /// Severity score for the last input point. The larger the value is, the more
        /// severe the anomaly is. For normal points, the severity is always 0.
        /// </summary>
        public float? Severity { get; }
    }
}
