// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.AnomalyDetector
{
    /// <summary> The TimeGranularity. </summary>
    public readonly partial struct TimeGranularity : IEquatable<TimeGranularity>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TimeGranularity"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TimeGranularity(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string YearlyValue = "yearly";
        private const string MonthlyValue = "monthly";
        private const string WeeklyValue = "weekly";
        private const string DailyValue = "daily";
        private const string HourlyValue = "hourly";
        private const string PerMinuteValue = "minutely";
        private const string PerSecondValue = "secondly";
        private const string MicrosecondValue = "microsecond";
        private const string NoneValue = "none";

        /// <summary> yearly. </summary>
        public static TimeGranularity Yearly { get; } = new TimeGranularity(YearlyValue);
        /// <summary> monthly. </summary>
        public static TimeGranularity Monthly { get; } = new TimeGranularity(MonthlyValue);
        /// <summary> weekly. </summary>
        public static TimeGranularity Weekly { get; } = new TimeGranularity(WeeklyValue);
        /// <summary> daily. </summary>
        public static TimeGranularity Daily { get; } = new TimeGranularity(DailyValue);
        /// <summary> hourly. </summary>
        public static TimeGranularity Hourly { get; } = new TimeGranularity(HourlyValue);
        /// <summary> minutely. </summary>
        public static TimeGranularity PerMinute { get; } = new TimeGranularity(PerMinuteValue);
        /// <summary> secondly. </summary>
        public static TimeGranularity PerSecond { get; } = new TimeGranularity(PerSecondValue);
        /// <summary> microsecond. </summary>
        public static TimeGranularity Microsecond { get; } = new TimeGranularity(MicrosecondValue);
        /// <summary> none. </summary>
        public static TimeGranularity None { get; } = new TimeGranularity(NoneValue);
        /// <summary> Determines if two <see cref="TimeGranularity"/> values are the same. </summary>
        public static bool operator ==(TimeGranularity left, TimeGranularity right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TimeGranularity"/> values are not the same. </summary>
        public static bool operator !=(TimeGranularity left, TimeGranularity right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TimeGranularity"/>. </summary>
        public static implicit operator TimeGranularity(string value) => new TimeGranularity(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TimeGranularity other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TimeGranularity other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
