// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.AI.AnomalyDetector
{
    /// <summary> The ImputeMode. </summary>
    public readonly partial struct ImputeMode : IEquatable<ImputeMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ImputeMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ImputeMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AutoValue = "auto";
        private const string PreviousValue = "previous";
        private const string LinearValue = "linear";
        private const string FixedValue = "fixed";
        private const string ZeroValue = "zero";
        private const string NotFillValue = "notFill";

        /// <summary> auto. </summary>
        public static ImputeMode Auto { get; } = new ImputeMode(AutoValue);
        /// <summary> previous. </summary>
        public static ImputeMode Previous { get; } = new ImputeMode(PreviousValue);
        /// <summary> linear. </summary>
        public static ImputeMode Linear { get; } = new ImputeMode(LinearValue);
        /// <summary> fixed. </summary>
        public static ImputeMode Fixed { get; } = new ImputeMode(FixedValue);
        /// <summary> zero. </summary>
        public static ImputeMode Zero { get; } = new ImputeMode(ZeroValue);
        /// <summary> notFill. </summary>
        public static ImputeMode NotFill { get; } = new ImputeMode(NotFillValue);
        /// <summary> Determines if two <see cref="ImputeMode"/> values are the same. </summary>
        public static bool operator ==(ImputeMode left, ImputeMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ImputeMode"/> values are not the same. </summary>
        public static bool operator !=(ImputeMode left, ImputeMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ImputeMode"/>. </summary>
        public static implicit operator ImputeMode(string value) => new ImputeMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ImputeMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ImputeMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
