---
page_type: sample
languages:
- csharp
products:
- azure
- azure-cognitive-services
- azure-anomaly-detector
name: Azure Anomaly Detector samples for .NET
description: Samples for the Azure.AI.AnomalyDetector client library
---

# Azure Anomaly Detector client SDK Samples
These code samples show common scenario operations with the Anomaly Detector client library.

|**Sample Name**|**Description**|
|----------------|-------------|
|[Sample1_DetectEntireSeriesAnomaly][sample_detect_entire_series_anomaly] |Detecting anomalies in the entire time series.|
|[Sample2_DetectLastPointAnomaly][sample_detect_last_point_anomaly] |Detecting the anomaly status of the latest data point.|
|[Sample3_DetectChangePoint][sample_detect_change_point] |Detecting change points in the entire time series.|
|[Sample4_MultivariateDetect][sample_multivariate_detect] |Detecting the anomalies in the multivariate time series.|

<!-- LINKS -->
[sample_detect_entire_series_anomaly]: https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/anomalydetector/Azure.AI.AnomalyDetector/samples/Sample1_DetectEntireSeriesAnomaly.md
[sample_detect_last_point_anomaly]: https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/anomalydetector/Azure.AI.AnomalyDetector/samples/Sample2_DetectLastPointAnomaly.md
[sample_detect_change_point]: https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/anomalydetector/Azure.AI.AnomalyDetector/samples/Sample3_DetectChangePoint.md
[sample_multivariate_detect]: https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/anomalydetector/Azure.AI.AnomalyDetector/samples/Sample4_MultivariateDetect.md
