// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager;
using Azure.ResourceManager.Analysis;
using Azure.ResourceManager.Analysis.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.Analysis.Samples
{
    public partial class Sample_AnalysisServerResource
    {
        // Get details of a server
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetDetailsOfAServer()
        {
            // Generated from example definition: specification/analysisservices/resource-manager/Microsoft.AnalysisServices/stable/2017-08-01/examples/getServer.json
            // this example is just showing the usage of "Servers_GetDetails" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AnalysisServerResource created on azure
            // for more information of creating AnalysisServerResource, please refer to the document of AnalysisServerResource
            string subscriptionId = "613192d7-503f-477a-9cfe-4efc3ee2bd60";
            string resourceGroupName = "TestRG";
            string serverName = "azsdktest";
            ResourceIdentifier analysisServerResourceId = AnalysisServerResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName);
            AnalysisServerResource analysisServer = client.GetAnalysisServerResource(analysisServerResourceId);

            // invoke the operation
            AnalysisServerResource result = await analysisServer.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AnalysisServerData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete a server.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteAServer()
        {
            // Generated from example definition: specification/analysisservices/resource-manager/Microsoft.AnalysisServices/stable/2017-08-01/examples/deleteServer.json
            // this example is just showing the usage of "Servers_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AnalysisServerResource created on azure
            // for more information of creating AnalysisServerResource, please refer to the document of AnalysisServerResource
            string subscriptionId = "613192d7-503f-477a-9cfe-4efc3ee2bd60";
            string resourceGroupName = "TestRG";
            string serverName = "azsdktest";
            ResourceIdentifier analysisServerResourceId = AnalysisServerResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName);
            AnalysisServerResource analysisServer = client.GetAnalysisServerResource(analysisServerResourceId);

            // invoke the operation
            await analysisServer.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Update a server.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateAServer()
        {
            // Generated from example definition: specification/analysisservices/resource-manager/Microsoft.AnalysisServices/stable/2017-08-01/examples/updateServer.json
            // this example is just showing the usage of "Servers_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AnalysisServerResource created on azure
            // for more information of creating AnalysisServerResource, please refer to the document of AnalysisServerResource
            string subscriptionId = "613192d7-503f-477a-9cfe-4efc3ee2bd60";
            string resourceGroupName = "TestRG";
            string serverName = "azsdktest";
            ResourceIdentifier analysisServerResourceId = AnalysisServerResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName);
            AnalysisServerResource analysisServer = client.GetAnalysisServerResource(analysisServerResourceId);

            // invoke the operation
            AnalysisServerPatch patch = new AnalysisServerPatch()
            {
                Sku = new AnalysisResourceSku("S1")
                {
                    Tier = AnalysisSkuTier.Standard,
                    Capacity = 1,
                },
                Tags =
{
["testKey"] = "testValue",
},
                AsAdministratorIdentities =
{
"azsdktest@microsoft.com","azsdktest2@microsoft.com"
},
            };
            ArmOperation<AnalysisServerResource> lro = await analysisServer.UpdateAsync(WaitUntil.Completed, patch);
            AnalysisServerResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AnalysisServerData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Suspend a server.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Suspend_SuspendAServer()
        {
            // Generated from example definition: specification/analysisservices/resource-manager/Microsoft.AnalysisServices/stable/2017-08-01/examples/suspendServer.json
            // this example is just showing the usage of "Servers_Suspend" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AnalysisServerResource created on azure
            // for more information of creating AnalysisServerResource, please refer to the document of AnalysisServerResource
            string subscriptionId = "613192d7-503f-477a-9cfe-4efc3ee2bd60";
            string resourceGroupName = "TestRG";
            string serverName = "azsdktest";
            ResourceIdentifier analysisServerResourceId = AnalysisServerResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName);
            AnalysisServerResource analysisServer = client.GetAnalysisServerResource(analysisServerResourceId);

            // invoke the operation
            await analysisServer.SuspendAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Resume a server.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Resume_ResumeAServer()
        {
            // Generated from example definition: specification/analysisservices/resource-manager/Microsoft.AnalysisServices/stable/2017-08-01/examples/resumeServer.json
            // this example is just showing the usage of "Servers_Resume" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AnalysisServerResource created on azure
            // for more information of creating AnalysisServerResource, please refer to the document of AnalysisServerResource
            string subscriptionId = "613192d7-503f-477a-9cfe-4efc3ee2bd60";
            string resourceGroupName = "TestRG";
            string serverName = "azsdktest";
            ResourceIdentifier analysisServerResourceId = AnalysisServerResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName);
            AnalysisServerResource analysisServer = client.GetAnalysisServerResource(analysisServerResourceId);

            // invoke the operation
            await analysisServer.ResumeAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // List existing servers under the subscription.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAnalysisServers_ListExistingServersUnderTheSubscription()
        {
            // Generated from example definition: specification/analysisservices/resource-manager/Microsoft.AnalysisServices/stable/2017-08-01/examples/listServers.json
            // this example is just showing the usage of "Servers_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "613192d7-503f-477a-9cfe-4efc3ee2bd60";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            await foreach (AnalysisServerResource item in subscriptionResource.GetAnalysisServersAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                AnalysisServerData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // List eligible SKUs for a new server
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetEligibleSkus_ListEligibleSKUsForANewServer()
        {
            // Generated from example definition: specification/analysisservices/resource-manager/Microsoft.AnalysisServices/stable/2017-08-01/examples/listSkusForNew.json
            // this example is just showing the usage of "Servers_ListSkusForNew" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "613192d7-503f-477a-9cfe-4efc3ee2bd60";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            await foreach (AnalysisResourceSku item in subscriptionResource.GetEligibleSkusAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // List eligible SKUs for an existing server
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetExistingSkus_ListEligibleSKUsForAnExistingServer()
        {
            // Generated from example definition: specification/analysisservices/resource-manager/Microsoft.AnalysisServices/stable/2017-08-01/examples/listSkusForExisting.json
            // this example is just showing the usage of "Servers_ListSkusForExisting" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AnalysisServerResource created on azure
            // for more information of creating AnalysisServerResource, please refer to the document of AnalysisServerResource
            string subscriptionId = "613192d7-503f-477a-9cfe-4efc3ee2bd60";
            string resourceGroupName = "TestRG";
            string serverName = "azsdktest";
            ResourceIdentifier analysisServerResourceId = AnalysisServerResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName);
            AnalysisServerResource analysisServer = client.GetAnalysisServerResource(analysisServerResourceId);

            // invoke the operation and iterate over the result
            await foreach (AnalysisExistingSku item in analysisServer.GetExistingSkusAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Get details of a server
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetGatewayStatus_GetDetailsOfAServer()
        {
            // Generated from example definition: specification/analysisservices/resource-manager/Microsoft.AnalysisServices/stable/2017-08-01/examples/listGatewayStatus.json
            // this example is just showing the usage of "Servers_ListGatewayStatus" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AnalysisServerResource created on azure
            // for more information of creating AnalysisServerResource, please refer to the document of AnalysisServerResource
            string subscriptionId = "613192d7-503f-477a-9cfe-4efc3ee2bd60";
            string resourceGroupName = "TestRG";
            string serverName = "azsdktest";
            ResourceIdentifier analysisServerResourceId = AnalysisServerResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName);
            AnalysisServerResource analysisServer = client.GetAnalysisServerResource(analysisServerResourceId);

            // invoke the operation
            AnalysisGatewayStatus result = await analysisServer.GetGatewayStatusAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get details of a server
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task DissociateGateway_GetDetailsOfAServer()
        {
            // Generated from example definition: specification/analysisservices/resource-manager/Microsoft.AnalysisServices/stable/2017-08-01/examples/dissociateGateway.json
            // this example is just showing the usage of "Servers_DissociateGateway" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AnalysisServerResource created on azure
            // for more information of creating AnalysisServerResource, please refer to the document of AnalysisServerResource
            string subscriptionId = "613192d7-503f-477a-9cfe-4efc3ee2bd60";
            string resourceGroupName = "TestRG";
            string serverName = "azsdktest";
            ResourceIdentifier analysisServerResourceId = AnalysisServerResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, serverName);
            AnalysisServerResource analysisServer = client.GetAnalysisServerResource(analysisServerResourceId);

            // invoke the operation
            await analysisServer.DissociateGatewayAsync();

            Console.WriteLine($"Succeeded");
        }

        // Get details of a server
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CheckAnalysisServerNameAvailability_GetDetailsOfAServer()
        {
            // Generated from example definition: specification/analysisservices/resource-manager/Microsoft.AnalysisServices/stable/2017-08-01/examples/checkNameAvailability.json
            // this example is just showing the usage of "Servers_CheckNameAvailability" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "613192d7-503f-477a-9cfe-4efc3ee2bd60";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation
            AzureLocation location = new AzureLocation("West US");
            AnalysisServerNameAvailabilityContent content = new AnalysisServerNameAvailabilityContent()
            {
                Name = "azsdktest",
                ResourceType = "Microsoft.AnalysisServices/servers",
            };
            AnalysisServerNameAvailabilityResult result = await subscriptionResource.CheckAnalysisServerNameAvailabilityAsync(location, content);

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
