// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;
using System.Globalization;

namespace Azure.ResourceManager.Analysis.Models
{
    /// <summary> Live message of list gateway. Status: 0 - Live. </summary>
    public readonly partial struct AnalysisStatus : IEquatable<AnalysisStatus>
    {
        private readonly int _value;

        /// <summary> Initializes a new instance of <see cref="AnalysisStatus"/>. </summary>
        public AnalysisStatus(int value)
        {
            _value = value;
        }

        private const int ZeroValue = 0;

        /// <summary> 0. </summary>
        public static AnalysisStatus Zero { get; } = new AnalysisStatus(ZeroValue);

        internal int ToSerialInt32() => _value;

        /// <summary> Determines if two <see cref="AnalysisStatus"/> values are the same. </summary>
        public static bool operator ==(AnalysisStatus left, AnalysisStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AnalysisStatus"/> values are not the same. </summary>
        public static bool operator !=(AnalysisStatus left, AnalysisStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="int"/> to a <see cref="AnalysisStatus"/>. </summary>
        public static implicit operator AnalysisStatus(int value) => new AnalysisStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AnalysisStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AnalysisStatus other) => Equals(_value, other._value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value.GetHashCode();
        /// <inheritdoc />
        public override string ToString() => _value.ToString(CultureInfo.InvariantCulture);
    }
}
