// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Analysis.Models
{
    /// <summary> The current state of Analysis Services resource. The state is to indicate more states outside of resource provisioning. </summary>
    public readonly partial struct AnalysisState : IEquatable<AnalysisState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AnalysisState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AnalysisState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DeletingValue = "Deleting";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string PausedValue = "Paused";
        private const string SuspendedValue = "Suspended";
        private const string ProvisioningValue = "Provisioning";
        private const string UpdatingValue = "Updating";
        private const string SuspendingValue = "Suspending";
        private const string PausingValue = "Pausing";
        private const string ResumingValue = "Resuming";
        private const string PreparingValue = "Preparing";
        private const string ScalingValue = "Scaling";

        /// <summary> Deleting. </summary>
        public static AnalysisState Deleting { get; } = new AnalysisState(DeletingValue);
        /// <summary> Succeeded. </summary>
        public static AnalysisState Succeeded { get; } = new AnalysisState(SucceededValue);
        /// <summary> Failed. </summary>
        public static AnalysisState Failed { get; } = new AnalysisState(FailedValue);
        /// <summary> Paused. </summary>
        public static AnalysisState Paused { get; } = new AnalysisState(PausedValue);
        /// <summary> Suspended. </summary>
        public static AnalysisState Suspended { get; } = new AnalysisState(SuspendedValue);
        /// <summary> Provisioning. </summary>
        public static AnalysisState Provisioning { get; } = new AnalysisState(ProvisioningValue);
        /// <summary> Updating. </summary>
        public static AnalysisState Updating { get; } = new AnalysisState(UpdatingValue);
        /// <summary> Suspending. </summary>
        public static AnalysisState Suspending { get; } = new AnalysisState(SuspendingValue);
        /// <summary> Pausing. </summary>
        public static AnalysisState Pausing { get; } = new AnalysisState(PausingValue);
        /// <summary> Resuming. </summary>
        public static AnalysisState Resuming { get; } = new AnalysisState(ResumingValue);
        /// <summary> Preparing. </summary>
        public static AnalysisState Preparing { get; } = new AnalysisState(PreparingValue);
        /// <summary> Scaling. </summary>
        public static AnalysisState Scaling { get; } = new AnalysisState(ScalingValue);
        /// <summary> Determines if two <see cref="AnalysisState"/> values are the same. </summary>
        public static bool operator ==(AnalysisState left, AnalysisState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AnalysisState"/> values are not the same. </summary>
        public static bool operator !=(AnalysisState left, AnalysisState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AnalysisState"/>. </summary>
        public static implicit operator AnalysisState(string value) => new AnalysisState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AnalysisState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AnalysisState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
