// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Analysis.Models
{
    /// <summary> The name of the Azure pricing tier to which the SKU applies. </summary>
    public readonly partial struct AnalysisSkuTier : IEquatable<AnalysisSkuTier>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AnalysisSkuTier"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AnalysisSkuTier(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DevelopmentValue = "Development";
        private const string BasicValue = "Basic";
        private const string StandardValue = "Standard";

        /// <summary> Development. </summary>
        public static AnalysisSkuTier Development { get; } = new AnalysisSkuTier(DevelopmentValue);
        /// <summary> Basic. </summary>
        public static AnalysisSkuTier Basic { get; } = new AnalysisSkuTier(BasicValue);
        /// <summary> Standard. </summary>
        public static AnalysisSkuTier Standard { get; } = new AnalysisSkuTier(StandardValue);
        /// <summary> Determines if two <see cref="AnalysisSkuTier"/> values are the same. </summary>
        public static bool operator ==(AnalysisSkuTier left, AnalysisSkuTier right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AnalysisSkuTier"/> values are not the same. </summary>
        public static bool operator !=(AnalysisSkuTier left, AnalysisSkuTier right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AnalysisSkuTier"/>. </summary>
        public static implicit operator AnalysisSkuTier(string value) => new AnalysisSkuTier(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AnalysisSkuTier other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AnalysisSkuTier other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
