// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Analysis.Models
{
    /// <summary> Provision request specification. </summary>
    public partial class AnalysisServerPatch
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AnalysisServerPatch"/>. </summary>
        public AnalysisServerPatch()
        {
            Tags = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="AnalysisServerPatch"/>. </summary>
        /// <param name="sku"> The SKU of the Analysis Services resource. </param>
        /// <param name="tags"> Key-value pairs of additional provisioning properties. </param>
        /// <param name="asAdministrators"> A collection of AS server administrators. </param>
        /// <param name="backupBlobContainerUri"> The SAS container URI to the backup container. </param>
        /// <param name="gatewayDetails"> The gateway details configured for the AS server. </param>
        /// <param name="ipV4FirewallSettings"> The firewall settings for the AS server. </param>
        /// <param name="querypoolConnectionMode"> How the read-write server's participation in the query pool is controlled.&lt;br/&gt;It can have the following values: &lt;ul&gt;&lt;li&gt;readOnly - indicates that the read-write server is intended not to participate in query operations&lt;/li&gt;&lt;li&gt;all - indicates that the read-write server can participate in query operations&lt;/li&gt;&lt;/ul&gt;Specifying readOnly when capacity is 1 results in error. </param>
        /// <param name="managedMode"> The managed mode of the server (0 = not managed, 1 = managed). </param>
        /// <param name="serverMonitorMode"> The server monitor mode for AS server. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AnalysisServerPatch(AnalysisResourceSku sku, IDictionary<string, string> tags, ServerAdministrators asAdministrators, Uri backupBlobContainerUri, AnalysisGatewayDetails gatewayDetails, AnalysisIPv4FirewallSettings ipV4FirewallSettings, AnalysisConnectionMode? querypoolConnectionMode, AnalysisManagedMode? managedMode, ServerMonitorMode? serverMonitorMode, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Sku = sku;
            Tags = tags;
            AsAdministrators = asAdministrators;
            BackupBlobContainerUri = backupBlobContainerUri;
            GatewayDetails = gatewayDetails;
            IPV4FirewallSettings = ipV4FirewallSettings;
            QuerypoolConnectionMode = querypoolConnectionMode;
            ManagedMode = managedMode;
            ServerMonitorMode = serverMonitorMode;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The SKU of the Analysis Services resource. </summary>
        public AnalysisResourceSku Sku { get; set; }
        /// <summary> Key-value pairs of additional provisioning properties. </summary>
        public IDictionary<string, string> Tags { get; }
        /// <summary> A collection of AS server administrators. </summary>
        internal ServerAdministrators AsAdministrators { get; set; }
        /// <summary> An array of administrator user identities. </summary>
        public IList<string> AsAdministratorIdentities
        {
            get
            {
                if (AsAdministrators is null)
                    AsAdministrators = new ServerAdministrators();
                return AsAdministrators.AsAdministratorIdentities;
            }
        }

        /// <summary> The SAS container URI to the backup container. </summary>
        public Uri BackupBlobContainerUri { get; set; }
        /// <summary> The gateway details configured for the AS server. </summary>
        public AnalysisGatewayDetails GatewayDetails { get; set; }
        /// <summary> The firewall settings for the AS server. </summary>
        public AnalysisIPv4FirewallSettings IPV4FirewallSettings { get; set; }
        /// <summary> How the read-write server's participation in the query pool is controlled.&lt;br/&gt;It can have the following values: &lt;ul&gt;&lt;li&gt;readOnly - indicates that the read-write server is intended not to participate in query operations&lt;/li&gt;&lt;li&gt;all - indicates that the read-write server can participate in query operations&lt;/li&gt;&lt;/ul&gt;Specifying readOnly when capacity is 1 results in error. </summary>
        public AnalysisConnectionMode? QuerypoolConnectionMode { get; set; }
        /// <summary> The managed mode of the server (0 = not managed, 1 = managed). </summary>
        public AnalysisManagedMode? ManagedMode { get; set; }
        /// <summary> The server monitor mode for AS server. </summary>
        public ServerMonitorMode? ServerMonitorMode { get; set; }
    }
}
