// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Analysis.Models
{
    public partial class AnalysisServerPatch : IUtf8JsonSerializable, IJsonModel<AnalysisServerPatch>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AnalysisServerPatch>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AnalysisServerPatch>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AnalysisServerPatch>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AnalysisServerPatch)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Sku))
            {
                writer.WritePropertyName("sku"u8);
                writer.WriteObjectValue(Sku, options);
            }
            if (Optional.IsCollectionDefined(Tags))
            {
                writer.WritePropertyName("tags"u8);
                writer.WriteStartObject();
                foreach (var item in Tags)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteStringValue(item.Value);
                }
                writer.WriteEndObject();
            }
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(AsAdministrators))
            {
                writer.WritePropertyName("asAdministrators"u8);
                writer.WriteObjectValue(AsAdministrators, options);
            }
            if (Optional.IsDefined(BackupBlobContainerUri))
            {
                writer.WritePropertyName("backupBlobContainerUri"u8);
                writer.WriteStringValue(BackupBlobContainerUri.AbsoluteUri);
            }
            if (Optional.IsDefined(GatewayDetails))
            {
                writer.WritePropertyName("gatewayDetails"u8);
                writer.WriteObjectValue(GatewayDetails, options);
            }
            if (Optional.IsDefined(IPV4FirewallSettings))
            {
                writer.WritePropertyName("ipV4FirewallSettings"u8);
                writer.WriteObjectValue(IPV4FirewallSettings, options);
            }
            if (Optional.IsDefined(QuerypoolConnectionMode))
            {
                writer.WritePropertyName("querypoolConnectionMode"u8);
                writer.WriteStringValue(QuerypoolConnectionMode.Value.ToSerialString());
            }
            if (Optional.IsDefined(ManagedMode))
            {
                writer.WritePropertyName("managedMode"u8);
                writer.WriteNumberValue(ManagedMode.Value.ToSerialInt32());
            }
            if (Optional.IsDefined(ServerMonitorMode))
            {
                writer.WritePropertyName("serverMonitorMode"u8);
                writer.WriteNumberValue(ServerMonitorMode.Value.ToSerialInt32());
            }
            writer.WriteEndObject();
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AnalysisServerPatch IJsonModel<AnalysisServerPatch>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AnalysisServerPatch>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AnalysisServerPatch)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAnalysisServerPatch(document.RootElement, options);
        }

        internal static AnalysisServerPatch DeserializeAnalysisServerPatch(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            AnalysisResourceSku sku = default;
            IDictionary<string, string> tags = default;
            ServerAdministrators asAdministrators = default;
            Uri backupBlobContainerUri = default;
            AnalysisGatewayDetails gatewayDetails = default;
            AnalysisIPv4FirewallSettings ipV4FirewallSettings = default;
            AnalysisConnectionMode? querypoolConnectionMode = default;
            AnalysisManagedMode? managedMode = default;
            ServerMonitorMode? serverMonitorMode = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("sku"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    sku = AnalysisResourceSku.DeserializeAnalysisResourceSku(property.Value, options);
                    continue;
                }
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("asAdministrators"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            asAdministrators = ServerAdministrators.DeserializeServerAdministrators(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("backupBlobContainerUri"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            backupBlobContainerUri = new Uri(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("gatewayDetails"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            gatewayDetails = AnalysisGatewayDetails.DeserializeAnalysisGatewayDetails(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("ipV4FirewallSettings"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            ipV4FirewallSettings = AnalysisIPv4FirewallSettings.DeserializeAnalysisIPv4FirewallSettings(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("querypoolConnectionMode"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            querypoolConnectionMode = property0.Value.GetString().ToAnalysisConnectionMode();
                            continue;
                        }
                        if (property0.NameEquals("managedMode"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            managedMode = new AnalysisManagedMode(property0.Value.GetInt32());
                            continue;
                        }
                        if (property0.NameEquals("serverMonitorMode"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            serverMonitorMode = new ServerMonitorMode(property0.Value.GetInt32());
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AnalysisServerPatch(
                sku,
                tags ?? new ChangeTrackingDictionary<string, string>(),
                asAdministrators,
                backupBlobContainerUri,
                gatewayDetails,
                ipV4FirewallSettings,
                querypoolConnectionMode,
                managedMode,
                serverMonitorMode,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AnalysisServerPatch>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AnalysisServerPatch>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AnalysisServerPatch)} does not support writing '{options.Format}' format.");
            }
        }

        AnalysisServerPatch IPersistableModel<AnalysisServerPatch>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AnalysisServerPatch>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAnalysisServerPatch(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AnalysisServerPatch)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AnalysisServerPatch>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
