// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Analysis.Models
{
    /// <summary> The current deployment state of Analysis Services resource. The provisioningState is to indicate states for resource provisioning. </summary>
    public readonly partial struct AnalysisProvisioningState : IEquatable<AnalysisProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AnalysisProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AnalysisProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DeletingValue = "Deleting";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string PausedValue = "Paused";
        private const string SuspendedValue = "Suspended";
        private const string ProvisioningValue = "Provisioning";
        private const string UpdatingValue = "Updating";
        private const string SuspendingValue = "Suspending";
        private const string PausingValue = "Pausing";
        private const string ResumingValue = "Resuming";
        private const string PreparingValue = "Preparing";
        private const string ScalingValue = "Scaling";

        /// <summary> Deleting. </summary>
        public static AnalysisProvisioningState Deleting { get; } = new AnalysisProvisioningState(DeletingValue);
        /// <summary> Succeeded. </summary>
        public static AnalysisProvisioningState Succeeded { get; } = new AnalysisProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static AnalysisProvisioningState Failed { get; } = new AnalysisProvisioningState(FailedValue);
        /// <summary> Paused. </summary>
        public static AnalysisProvisioningState Paused { get; } = new AnalysisProvisioningState(PausedValue);
        /// <summary> Suspended. </summary>
        public static AnalysisProvisioningState Suspended { get; } = new AnalysisProvisioningState(SuspendedValue);
        /// <summary> Provisioning. </summary>
        public static AnalysisProvisioningState Provisioning { get; } = new AnalysisProvisioningState(ProvisioningValue);
        /// <summary> Updating. </summary>
        public static AnalysisProvisioningState Updating { get; } = new AnalysisProvisioningState(UpdatingValue);
        /// <summary> Suspending. </summary>
        public static AnalysisProvisioningState Suspending { get; } = new AnalysisProvisioningState(SuspendingValue);
        /// <summary> Pausing. </summary>
        public static AnalysisProvisioningState Pausing { get; } = new AnalysisProvisioningState(PausingValue);
        /// <summary> Resuming. </summary>
        public static AnalysisProvisioningState Resuming { get; } = new AnalysisProvisioningState(ResumingValue);
        /// <summary> Preparing. </summary>
        public static AnalysisProvisioningState Preparing { get; } = new AnalysisProvisioningState(PreparingValue);
        /// <summary> Scaling. </summary>
        public static AnalysisProvisioningState Scaling { get; } = new AnalysisProvisioningState(ScalingValue);
        /// <summary> Determines if two <see cref="AnalysisProvisioningState"/> values are the same. </summary>
        public static bool operator ==(AnalysisProvisioningState left, AnalysisProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AnalysisProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(AnalysisProvisioningState left, AnalysisProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AnalysisProvisioningState"/>. </summary>
        public static implicit operator AnalysisProvisioningState(string value) => new AnalysisProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AnalysisProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AnalysisProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
